/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.examples.runtime.emf.clipboard.transfer;

import java.io.UnsupportedEncodingException;

public final class EmfTransferType {
    private String string;

    public EmfTransferType(String string) {
        assert (string != null);
        this.string = string;
    }

    public String getString() {
        return this.string;
    }

    byte[] toBytes() {
        try {
            return this.string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("UTF-8 encoding not supported by String class", e);
        }
    }

    static EmfTransferType fromBytes(byte[] bytes) {
        try {
            return new EmfTransferType(new String(bytes, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("UTF-8 encoding not supported by String class", e);
        }
    }
}

