/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.doc.ui.actions;

import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.internal.bridge.wizards.GMFMapGuideModelWizard;
import org.eclipse.gmf.internal.bridge.wizards.pages.NewMapFileCreationPage;
import org.eclipse.gmf.internal.doc.ui.Activator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.cheatsheets.ICheatSheetAction;
import org.eclipse.ui.cheatsheets.ICheatSheetManager;

public class OpenMapWizardAction
extends Action
implements ICheatSheetAction {
    private static final int WIZARD_WIDTH = 500;
    private static final int WIZARD_HEIGHT = 500;

    public OpenMapWizardAction() {
        super("OpenMapWizard");
    }

    public void run() {
        this.run(new String[0], null);
    }

    public void run(String[] params, ICheatSheetManager manager) {
        String modelFolder = params != null && params.length > 0 ? params[0] : "org.eclipse.gmf.examples.mindmap/model";
        String modelName = params != null && params.length > 1 ? params[1] : "mindmap.gmfmap";
        ArrayList<URI> uris = new ArrayList<URI>();
        int i = 2;
        while (i < 5) {
            String param = params[i];
            if (param != null) {
                try {
                    uris.add(URI.createURI((String)param));
                }
                catch (IllegalArgumentException iae) {
                    Activator.log(iae);
                }
            }
            ++i;
        }
        GMFMapGuideModelWizard wizard = new GMFMapGuideModelWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection(uris));
        WizardDialog dialog = new WizardDialog(Activator.getActiveWorkbenchShell(), (IWizard)wizard);
        dialog.create();
        NewMapFileCreationPage filePage = (NewMapFileCreationPage)wizard.getPage("newMapFileCreationPage");
        filePage.setContainerFullPath((IPath)new Path(modelFolder));
        filePage.setFileName(modelName);
        dialog.getShell().setSize(Math.max(500, dialog.getShell().getSize().x), 500);
        dialog.open();
        this.notifyResult(dialog.getReturnCode() == 0);
    }
}

