/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards.pages;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.gmf.gmfgraph.Canvas;
import org.eclipse.gmf.gmfgraph.provider.GMFGraphItemProviderAdapterFactory;
import org.eclipse.gmf.internal.bridge.wizards.pages.CreateToolDef;
import org.eclipse.gmf.internal.bridge.wizards.pages.MapDefFeeder;
import org.eclipse.gmf.internal.bridge.wizards.pages.ToolDefLookup;
import org.eclipse.gmf.internal.bridge.wizards.pages.ToolDefSupplier;
import org.eclipse.gmf.mappings.CanvasMapping;
import org.eclipse.gmf.mappings.GMFMapFactory;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.Mapping;
import org.eclipse.gmf.mappings.NodeReference;
import org.eclipse.gmf.mappings.provider.GMFMapItemProviderAdapterFactory;
import org.eclipse.gmf.tooldef.ToolRegistry;
import org.eclipse.gmf.tooldef.provider.GMFToolItemProviderAdapterFactory;

public abstract class WizardInput {
    public static final String TOOLDEF_FILE_EXT = "gmftool";
    public static final String GRAPHDEF_FILE_EXT = "gmfgraph";
    public static final String ECORE_FILE_EXT = "ecore";
    private Mapping mapInstance;
    private EditingDomain myEditingDomain;
    private AdapterFactory myAdapterFactory;
    private IFile myResultFile;
    private MapDefFeeder myFeeder;

    public AdapterFactory getAdapterFactory() {
        if (this.myAdapterFactory == null) {
            ArrayList<Object> factories = new ArrayList<Object>();
            factories.add(new ResourceItemProviderAdapterFactory());
            factories.add(new GMFMapItemProviderAdapterFactory());
            factories.add(new GMFGraphItemProviderAdapterFactory());
            factories.add(new GMFToolItemProviderAdapterFactory());
            factories.add(new ReflectiveItemProviderAdapterFactory());
            this.myAdapterFactory = new ComposedAdapterFactory(factories);
        }
        return this.myAdapterFactory;
    }

    public EditingDomain getEditingDomain() {
        if (this.myEditingDomain == null) {
            this.myEditingDomain = new AdapterFactoryEditingDomain(this.getAdapterFactory(), (CommandStack)new BasicCommandStack());
        }
        return this.myEditingDomain;
    }

    public ResourceSet getResourceSet() {
        return this.getEditingDomain().getResourceSet();
    }

    public abstract EPackage getDomainModel();

    public abstract Canvas getCanvasDef();

    public abstract ToolRegistry getToolDef();

    public abstract boolean isNewBlankToolDef();

    public void setMappingFile(IFile resultFile) {
        this.myResultFile = resultFile;
    }

    public IFile getMappingFile() {
        return this.myResultFile;
    }

    public Mapping getMapping() {
        if (this.mapInstance == null) {
            this.mapInstance = GMFMapFactory.eINSTANCE.createMapping();
            URI res = URI.createPlatformResourceURI((String)this.getMappingFile().getFullPath().toString(), (boolean)true);
            this.getResourceSet().createResource(res).getContents().add((Object)this.mapInstance);
            CanvasMapping cm = GMFMapFactory.eINSTANCE.createCanvasMapping();
            this.mapInstance.setDiagram(cm);
        }
        return this.mapInstance;
    }

    public void selectCanvasElement(EClass eClass) {
        assert (eClass.getEPackage() == this.getDomainModel());
        CanvasMapping cm = this.getMapping().getDiagram();
        cm.setDiagramCanvas(this.getCanvasDef());
        cm.setDomainMetaElement(eClass);
        cm.setDomainModel(eClass.getEPackage());
    }

    public void feedDefaultMapping() {
        this.myFeeder = new MapDefFeeder(this, this.createToolDefSupplier());
        this.myFeeder.feedDefaultMapping();
    }

    private ToolDefSupplier createToolDefSupplier() {
        if (this.isNewBlankToolDef()) {
            return new CreateToolDef(this.getToolDef());
        }
        return new ToolDefLookup(this.getToolDef());
    }

    public NodeReference[] nodeCandidates() {
        return this.myFeeder.getInitialNodes();
    }

    public LinkMapping[] linkCandidates() {
        return this.myFeeder.getInitialLinks();
    }
}

