/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.build;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmf.internal.xpand.inactive.StreamDecoder;
import org.eclipse.gmf.internal.xpand.model.XpandResource;
import org.eclipse.gmf.internal.xpand.util.ParserException;
import org.eclipse.gmf.internal.xpand.util.ResourceManagerImpl;
import org.eclipse.gmf.internal.xpand.util.StreamConverter;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;
import org.eclipse.m2m.internal.qvt.oml.project.builder.WorkspaceUnitResolver;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.BundleUnitResolver;
import org.osgi.framework.Bundle;

public class WorkspaceResourceManager
extends ResourceManagerImpl {
    private static final IPath[] EMPTY_PATH = new IPath[0];
    private final IProject contextProject;
    private final IPath[] myConfiguredRoots;

    public WorkspaceResourceManager(IProject context) {
        this(context, EMPTY_PATH);
    }

    public WorkspaceResourceManager(IProject context, IPath[] configuredRoots) {
        this.contextProject = context;
        this.myConfiguredRoots = configuredRoots;
    }

    public XpandResource loadXpandResource(IFile file) throws CoreException, IOException, ParserException {
        String fullyQualifiedName;
        if (file == null || (fullyQualifiedName = this.toFullyQualifiedName(file)) == null) {
            return null;
        }
        Reader r = new StreamConverter().toContentsReader(file);
        XpandResource[] loadXpandResources = this.loadXpandResources(new Reader[]{r}, fullyQualifiedName);
        assert (loadXpandResources.length == 1 && loadXpandResources[0] != null);
        return loadXpandResources[0];
    }

    protected void handleParserException(ParserException ex) {
    }

    protected boolean shouldCache() {
        return true;
    }

    public void forget(IFile resource) {
    }

    protected Reader[] resolveMultiple(String fqn, String ext) throws IOException {
        IPath fp = new Path(fqn.replaceAll("::", "/")).addFileExtension(ext);
        IPath[] resolutions = this.getResolutions(fp);
        ArrayList<Reader> result = new ArrayList<Reader>(resolutions.length);
        IPath[] iPathArray = this.getResolutions(fp);
        int n = iPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPath p = iPathArray[n2];
            Reader nextReader = this.getReader(p);
            if (nextReader != null) {
                result.add(nextReader);
            }
            ++n2;
        }
        if (result.isEmpty()) {
            throw new FileNotFoundException(fp.toString());
        }
        return result.toArray(new Reader[result.size()]);
    }

    private Reader getReader(IPath p) throws IOException {
        if (p.isAbsolute()) {
            URL url;
            assert (p.segmentCount() > 1);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(p.segment(0));
            if (project.isAccessible()) {
                return this.getWorkspaceFileReader(project, p.removeFirstSegments(1));
            }
            Bundle platformBundle = Platform.getBundle((String)p.segment(0));
            if (platformBundle != null && (url = platformBundle.getEntry(p.removeFirstSegments(1).toString())) != null) {
                InputStream is = url.openStream();
                return new StreamDecoder(is, StreamDecoder.LEGACY_ENCODING).getReader();
            }
        } else {
            return this.getWorkspaceFileReader(this.contextProject, p);
        }
        return null;
    }

    private Reader getWorkspaceFileReader(IProject project, IPath path) throws IOException {
        IResource r = project.findMember(path);
        if (r instanceof IFile) {
            try {
                return new StreamConverter().toContentsReader((IFile)r);
            }
            catch (CoreException ex) {
                IOException wrap = new IOException(ex.getStatus().getMessage());
                wrap.initCause(ex);
                throw wrap;
            }
        }
        return null;
    }

    private IPath[] getResolutions(IPath p) {
        IPath[] rv = new IPath[this.myConfiguredRoots.length];
        int i = 0;
        while (i < this.myConfiguredRoots.length) {
            rv[i] = this.myConfiguredRoots[i].append(p);
            ++i;
        }
        return rv;
    }

    private String toFullyQualifiedName(IFile file) {
        IPath[] iPathArray = this.myConfiguredRoots;
        int n = this.myConfiguredRoots.length;
        int n2 = 0;
        while (n2 < n) {
            IPath nextRoot = iPathArray[n2];
            if (!nextRoot.isAbsolute()) {
                if (file.getProject().equals((Object)this.contextProject) && nextRoot.isPrefixOf(file.getProjectRelativePath())) {
                    return WorkspaceResourceManager.toFullyQualifiedName(file.getProjectRelativePath().removeFirstSegments(nextRoot.segmentCount()));
                }
            } else if (nextRoot.isPrefixOf(file.getFullPath())) {
                return WorkspaceResourceManager.toFullyQualifiedName(file.getFullPath().removeFirstSegments(nextRoot.segmentCount()));
            }
            ++n2;
        }
        return null;
    }

    private static String toFullyQualifiedName(IPath filePath) {
        return filePath.removeFileExtension().toString().replace("/", "::");
    }

    protected String resolveCFileFullPath(String fullyQualifiedName, String fileExtension) {
        IPath[] resolutions;
        IPath fp = new Path(fullyQualifiedName.replaceAll("::", "/")).addFileExtension(fileExtension);
        IPath[] iPathArray = resolutions = this.getResolutions(fp);
        int n = resolutions.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file;
            IPath resolvedPath = iPathArray[n2];
            IFile iFile = file = resolvedPath.isAbsolute() ? ResourcesPlugin.getWorkspace().getRoot().getFile(resolvedPath) : this.contextProject.getFile(resolvedPath);
            if (file.exists()) {
                return file.getLocation().toOSString();
            }
            ++n2;
        }
        return String.valueOf(fullyQualifiedName) + "." + fileExtension;
    }

    protected UnitResolver getQVTUnitResolver() {
        ArrayList<URL> bundleRootURLs = new ArrayList<URL>();
        IPath[] iPathArray = this.myConfiguredRoots;
        int n = this.myConfiguredRoots.length;
        int n2 = 0;
        while (n2 < n) {
            IPath rootPath = iPathArray[n2];
            if (rootPath.isAbsolute()) {
                URL url;
                Bundle platformBundle;
                if (!rootPath.hasTrailingSeparator()) {
                    rootPath = rootPath.addTrailingSeparator();
                }
                if ((platformBundle = Platform.getBundle((String)rootPath.segment(0))) != null && (url = platformBundle.getEntry(rootPath.removeFirstSegments(1).toString())) != null) {
                    bundleRootURLs.add(url);
                }
            }
            ++n2;
        }
        final UnitResolver bundleDelegate = BundleUnitResolver.createResolver(bundleRootURLs, (boolean)true);
        WorkspaceUnitResolver resolver = new WorkspaceUnitResolver(Collections.emptyList()){

            protected UnitResolver getParent() {
                return bundleDelegate;
            }
        };
        IPath[] iPathArray2 = this.myConfiguredRoots;
        int n3 = this.myConfiguredRoots.length;
        int n4 = 0;
        while (n4 < n3) {
            IContainer container;
            IResource member;
            IPath rootPath = iPathArray2[n4];
            if (!rootPath.isAbsolute()) {
                rootPath = this.contextProject.getFullPath().append(rootPath);
            }
            if ((member = ResourcesPlugin.getWorkspace().getRoot().findMember(rootPath)) != null && member instanceof IContainer && (container = (IContainer)member).exists()) {
                resolver.addSourceContainer(container);
            }
            ++n4;
        }
        return resolver;
    }
}

