/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.migration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModelExt;
import org.eclipse.gmf.internal.xpand.ResourceManager;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.EvaluationException;
import org.eclipse.gmf.internal.xpand.expression.ast.SyntaxElement;
import org.eclipse.gmf.internal.xpand.migration.ExpressionAnalyzeTrace;
import org.eclipse.gmf.internal.xpand.migration.ExpressionMigrationFacade;
import org.eclipse.gmf.internal.xpand.migration.JavaExtensionDescriptor;
import org.eclipse.gmf.internal.xpand.migration.MigrationException;
import org.eclipse.gmf.internal.xpand.migration.MigrationExecutionContext;
import org.eclipse.gmf.internal.xpand.migration.MigrationExecutionContextImpl;
import org.eclipse.gmf.internal.xpand.migration.ModelManager;
import org.eclipse.gmf.internal.xpand.migration.ModeltypeImports;
import org.eclipse.gmf.internal.xpand.migration.OclKeywordManager;
import org.eclipse.gmf.internal.xpand.migration.OperationCallTrace;
import org.eclipse.gmf.internal.xpand.migration.StandardLibraryImports;
import org.eclipse.gmf.internal.xpand.migration.TypeManager;
import org.eclipse.gmf.internal.xpand.migration.VariableNameDispatcher;
import org.eclipse.gmf.internal.xpand.util.CompositeXtendResource;
import org.eclipse.gmf.internal.xpand.xtend.ast.CreateExtensionStatement;
import org.eclipse.gmf.internal.xpand.xtend.ast.ExpressionExtensionStatement;
import org.eclipse.gmf.internal.xpand.xtend.ast.Extension;
import org.eclipse.gmf.internal.xpand.xtend.ast.ExtensionFile;
import org.eclipse.gmf.internal.xpand.xtend.ast.JavaExtensionStatement;
import org.eclipse.gmf.internal.xpand.xtend.ast.WorkflowSlotExtensionStatement;
import org.eclipse.gmf.internal.xpand.xtend.ast.XtendResource;

public class XtendMigrationFacade {
    private static final String JAVA_ARRAY_TYPE_SUFFIX = ".List";
    private static final String JAVA_LANG_PACKAGE_PREFIX = "java.lang.";
    private ResourceManager resourceManager;
    private StringBuilder output = new StringBuilder();
    private String resourceName;
    private StandardLibraryImports stdLibImportsManager;
    private boolean injectUnusedImports;
    private MigrationExecutionContext rootExecutionContext;
    private TypeManager typeManager;
    private ModeltypeImports modeltypeImportsManger;
    private ModelManager modelManager;
    private List<JavaExtensionDescriptor> javaExtensionDescriptors = new ArrayList<JavaExtensionDescriptor>();
    private List<String> importedMetamodels = new ArrayList<String>();
    private String nativeLibraryClassName;
    private String nativeLibraryPackageName = "";
    private OclKeywordManager oclKeywordManager;

    private static String getLastSegment(String string, String separator) {
        int delimeterIndex = string.lastIndexOf(separator);
        if (delimeterIndex > 0) {
            return string.substring(delimeterIndex + separator.length());
        }
        return string;
    }

    public XtendMigrationFacade(ResourceManager resourceManager, String xtendResourceName, boolean injectUnusedImports) {
        this(resourceManager, xtendResourceName);
        this.injectUnusedImports = injectUnusedImports;
    }

    public XtendMigrationFacade(ResourceManager resourceManager, String xtendResourceName, MigrationExecutionContext executionContext) {
        this(resourceManager, xtendResourceName);
        this.rootExecutionContext = executionContext;
    }

    public XtendMigrationFacade(ResourceManager resourceManager, String xtendResourceName) {
        this.resourceManager = resourceManager;
        this.resourceName = xtendResourceName;
    }

    public StringBuilder migrateXtendResource() throws MigrationException {
        XtendResource xtendResource = this.resourceManager.loadXtendResource(this.resourceName);
        if (xtendResource == null) {
            throw new MigrationException(MigrationException.Type.RESOURCE_NOT_FOUND, this.resourceName, "Unable to load resource: " + this.resourceName);
        }
        MigrationExecutionContext ctx = (MigrationExecutionContext)(this.rootExecutionContext != null ? this.rootExecutionContext : new MigrationExecutionContextImpl(this.resourceManager, new EPackage[0])).cloneWithResource(xtendResource);
        HashSet<AnalysationIssue> issues = new HashSet<AnalysationIssue>();
        xtendResource.analyze(ctx, issues);
        if (MigrationException.hasErrors(issues)) {
            throw new MigrationException(issues, this.resourceName);
        }
        ExtensionFile extensionFile = this.getFirstExtensionFile(xtendResource);
        String shortResourceName = XtendMigrationFacade.getLastSegment(this.resourceName, "::");
        if (shortResourceName.length() == 0) {
            throw new MigrationException(MigrationException.Type.INCORRECT_RESOURCE_NAME, this.resourceName, this.resourceName);
        }
        this.stdLibImportsManager = new StandardLibraryImports(this.output);
        this.oclKeywordManager = new OclKeywordManager();
        this.modelManager = new ModelManager(this.stdLibImportsManager, this.oclKeywordManager);
        this.addLibraryImports(extensionFile, false);
        if (extensionFile.getImportedExtensions().length > 0) {
            this.writeln("");
        }
        this.modeltypeImportsManger = new ModeltypeImports(this.output, this.injectUnusedImports, this.oclKeywordManager);
        String[] stringArray = extensionFile.getImportedNamespaces();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String namespace = stringArray[n2];
            this.modeltypeImportsManger.registerModeltype(namespace);
            this.importedMetamodels.add(namespace);
            ++n2;
        }
        this.typeManager = new TypeManager(this.modeltypeImportsManger, this.oclKeywordManager);
        this.writeln("library " + shortResourceName + ";");
        this.writeln("");
        Iterator<Extension> it = extensionFile.getExtensions().iterator();
        while (it.hasNext()) {
            Extension extension = it.next();
            this.migrateExtension(extension, ctx);
            if (!it.hasNext()) continue;
            this.writeln("");
        }
        this.injectModeltypeImports();
        this.injectStdlibImports();
        return this.output;
    }

    private ExtensionFile getFirstExtensionFile(XtendResource xtendResource) throws MigrationException {
        while (xtendResource instanceof CompositeXtendResource) {
            xtendResource = ((CompositeXtendResource)xtendResource).getFirstDefinition();
        }
        if (!(xtendResource instanceof ExtensionFile)) {
            throw new MigrationException(MigrationException.Type.UNSUPPORTED_XTEND_RESOURCE, this.resourceName, "Only ExtensionFile instances are supported, but loaded: " + xtendResource);
        }
        return (ExtensionFile)xtendResource;
    }

    public StringBuilder getNativeLibraryXmlDeclaration() {
        if (this.javaExtensionDescriptors.size() == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        result.append("<library class=\"");
        result.append(this.getNativeLibraryFullClassName());
        result.append("\">");
        for (String metamodel : this.importedMetamodels) {
            result.append("<metamodel nsURI=\"");
            result.append(metamodel);
            result.append("\"/>");
        }
        result.append("</library>");
        result.append(ExpressionMigrationFacade.LF);
        return result;
    }

    private String getNativeLibraryFullClassName() {
        return this.getNativeLibraryPackageName().length() == 0 ? this.getNativeLibraryClassName() : String.valueOf(this.getNativeLibraryPackageName()) + "." + this.getNativeLibraryClassName();
    }

    public StringBuilder getNativeLibraryClassBody() throws MigrationException {
        if (this.javaExtensionDescriptors.size() == 0) {
            return null;
        }
        String lf = ExpressionMigrationFacade.LF;
        StringBuilder result = new StringBuilder();
        if (this.getNativeLibraryPackageName().length() > 0) {
            result.append("package ");
            result.append(this.getNativeLibraryPackageName());
            result.append(";");
            result.append(lf);
        }
        result.append("import org.eclipse.m2m.qvt.oml.blackbox.java.Operation;");
        result.append(lf);
        result.append("import org.eclipse.m2m.qvt.oml.blackbox.java.Operation.Kind;");
        result.append(lf);
        result.append("public class ");
        result.append(this.getNativeLibraryClassName());
        result.append(" {");
        result.append(lf);
        for (JavaExtensionDescriptor descriptor : this.javaExtensionDescriptors) {
            this.addNativeMethod(descriptor, result);
            result.append(lf);
        }
        result.append("}");
        return result;
    }

    private void addNativeMethod(JavaExtensionDescriptor descriptor, StringBuilder result) throws MigrationException {
        result.append("@Operation(contextual = ");
        result.append(!descriptor.isStaticQvtoCall());
        result.append(", kind = Kind.HELPER)");
        result.append(ExpressionMigrationFacade.LF);
        result.append("public ");
        if (descriptor.isStaticQvtoCall()) {
            result.append("static ");
        }
        EClassifier extensionReturnType = descriptor.getReturnType();
        result.append(this.getJavaType(extensionReturnType));
        result.append(" ");
        this.addNativeMethodSignature(descriptor, result);
        result.append(" { return ");
        if (BuiltinMetaModel.isParameterizedType(extensionReturnType)) {
            result.append("org.eclipse.ocl.util.CollectionUtil.<");
            result.append(this.getJavaType(BuiltinMetaModel.getInnerType(extensionReturnType)));
            result.append("> ");
            if (BuiltinMetaModelExt.isSetType(extensionReturnType)) {
                result.append("createNewSet(");
            } else if (BuiltinMetaModelExt.isListType(extensionReturnType)) {
                result.append("createNewSequence(");
            } else {
                result.append("createNewBag(");
            }
        }
        result.append(descriptor.getClassName());
        result.append(".");
        result.append(descriptor.getMethodName());
        result.append("(");
        List<String> parameterNames = descriptor.getParameterNames();
        List<String> javaParameterTypes = descriptor.getJavaParameterTypes();
        int i = 0;
        while (i < parameterNames.size()) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(parameterNames.get(i));
            String javaParameterType = javaParameterTypes.get(i);
            if (javaParameterType.endsWith(JAVA_ARRAY_TYPE_SUFFIX)) {
                javaParameterType = javaParameterType.substring(0, javaParameterType.length() - JAVA_ARRAY_TYPE_SUFFIX.length());
                result.append(".toArray(new ");
                result.append(this.suppressJavaLang(javaParameterType));
                result.append("[");
                result.append(parameterNames.get(i));
                result.append(".size()]");
                result.append(")");
            }
            ++i;
        }
        result.append(")");
        if (BuiltinMetaModel.isParameterizedType(extensionReturnType)) {
            result.append(")");
        }
        result.append("; }");
    }

    private String getJavaType(EClassifier xpandType) throws MigrationException {
        if (xpandType == BuiltinMetaModel.VOID) {
            throw new MigrationException(MigrationException.Type.UNSUPPORTED_NATIVE_EXTENSION_TYPE, this.resourceName, "Void type is not supported for native extensions");
        }
        if (xpandType == EcorePackage.eINSTANCE.getEBoolean()) {
            return "Boolean";
        }
        if (xpandType.getInstanceClassName() != null) {
            String instanceClassName = xpandType.getInstanceClassName();
            return this.suppressJavaLang(instanceClassName);
        }
        if (BuiltinMetaModel.isParameterizedType(xpandType)) {
            EClassifier innerType = BuiltinMetaModel.getInnerType(xpandType);
            String innerJavaType = this.getJavaType(innerType);
            if (BuiltinMetaModelExt.isSetType(xpandType)) {
                return "java.util.Set<" + innerJavaType + ">";
            }
            if (BuiltinMetaModelExt.isListType(xpandType)) {
                return "java.util.List<" + innerJavaType + ">";
            }
            if (BuiltinMetaModelExt.isCollectionType(xpandType)) {
                return "java.util.Collection<" + innerJavaType + ">";
            }
        }
        throw new MigrationException(MigrationException.Type.UNSUPPORTED_NATIVE_EXTENSION_TYPE, this.resourceName, "Metamodel types without instanceClassName set are not supported for native extensions: " + xpandType.getName());
    }

    private String suppressJavaLang(String instanceClassName) {
        String simpleClassName;
        if (instanceClassName.startsWith(JAVA_LANG_PACKAGE_PREFIX) && (simpleClassName = instanceClassName.substring(JAVA_LANG_PACKAGE_PREFIX.length())).indexOf(".") == -1) {
            return simpleClassName;
        }
        return instanceClassName;
    }

    private void addNativeMethodSignature(JavaExtensionDescriptor descriptor, StringBuilder result) throws MigrationException {
        result.append(descriptor.getExtensionName());
        result.append("(");
        List<EClassifier> parameterTypes = descriptor.getParameterTypes();
        List<String> parameterNames = descriptor.getParameterNames();
        assert (parameterTypes.size() == parameterNames.size());
        int i = 0;
        while (i < parameterTypes.size()) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(this.getJavaType(parameterTypes.get(i)));
            result.append(" ");
            result.append(parameterNames.get(i));
            ++i;
        }
        result.append(")");
    }

    public String getNativeLibraryClassName() {
        return this.nativeLibraryClassName;
    }

    public String getNativeLibraryPackageName() {
        return this.nativeLibraryPackageName;
    }

    private void injectStdlibImports() {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = this.stdLibImportsManager.getLibraries();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String libraryName = stringArray[n2];
            sb.append("import ");
            sb.append(libraryName.replaceAll("::", "."));
            sb.append(";");
            sb.append(ExpressionMigrationFacade.LF);
            ++n2;
        }
        if (sb.length() > 0) {
            sb.append(ExpressionMigrationFacade.LF);
            this.write(sb, this.stdLibImportsManager.getPlaceholderIndex());
        }
    }

    private void injectModeltypeImports() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.modeltypeImportsManger.getModelTypes().entrySet()) {
            sb.append("modeltype ");
            sb.append(entry.getValue());
            sb.append(" uses \"");
            sb.append(entry.getKey());
            sb.append("\";");
            sb.append(ExpressionMigrationFacade.LF);
        }
        if (sb.length() > 0) {
            sb.append(ExpressionMigrationFacade.LF);
            this.write(sb, this.modeltypeImportsManger.getPlaceholderIndex());
        }
    }

    private void addLibraryImports(XtendResource xtendResource, boolean reexportedOnly) throws MigrationException {
        String[] stringArray = xtendResource.getImportedExtensions();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            if (!reexportedOnly || xtendResource.isReexported(extension)) {
                this.writeln("import " + extension.replaceAll("::", ".") + ";");
                XtendResource referencedResource = this.resourceManager.loadXtendResource(extension);
                if (referencedResource == null) {
                    throw new MigrationException(MigrationException.Type.RESOURCE_NOT_FOUND, this.resourceName, "Unable to load extension file: " + extension);
                }
                this.addLibraryImports(referencedResource, true);
            }
            ++n2;
        }
    }

    private void migrateExtension(Extension extension, MigrationExecutionContext ctx) throws MigrationException {
        if (extension instanceof JavaExtensionStatement) {
            this.migrateJavaExtension((JavaExtensionStatement)extension, ctx);
            return;
        }
        try {
            extension.init(ctx);
        }
        catch (EvaluationException e) {
            throw new MigrationException(MigrationException.Type.ANALYZATION_PROBLEMS, this.resourceName, (SyntaxElement)extension, e);
        }
        this.write("helper ");
        List<String> parameterNames = extension.getParameterNames();
        List<EClassifier> parameterTypes = extension.getParameterTypes();
        assert (parameterNames.size() == parameterTypes.size());
        Iterator<String> parameterNamesIterator = parameterNames.iterator();
        Iterator<EClassifier> parameterTypesIterator = parameterTypes.iterator();
        String selfParameterName = null;
        if (!OperationCallTrace.isStaticQvtoCall(ctx, extension)) {
            assert (parameterNamesIterator.hasNext());
            selfParameterName = parameterNamesIterator.next();
            EClassifier selfParameterType = parameterTypesIterator.next();
            this.write(this.typeManager.getQvtFQName(selfParameterType));
            this.write("::");
            this.modelManager.registerSelfAlias(selfParameterName);
        }
        this.write(extension.getName());
        this.write("(");
        while (parameterNamesIterator.hasNext()) {
            this.write(this.oclKeywordManager.getValidIdentifierValue(parameterNamesIterator.next()));
            this.write(" : ");
            this.write(this.typeManager.getQvtFQName(parameterTypesIterator.next()));
            if (!parameterNamesIterator.hasNext()) continue;
            this.write(", ");
        }
        this.write(") : ");
        this.write(this.typeManager.getQvtFQName(this.getReturnType(extension, ctx)));
        this.writeln(" {");
        if (extension instanceof ExpressionExtensionStatement) {
            this.migrateExpressionExtension((ExpressionExtensionStatement)extension, ctx);
        } else if (extension instanceof CreateExtensionStatement) {
            this.migrateCreateExtension((CreateExtensionStatement)extension);
        } else if (extension instanceof WorkflowSlotExtensionStatement) {
            this.migrateWorkflowSlotExtension((WorkflowSlotExtensionStatement)extension, ctx);
        } else {
            throw new MigrationException(MigrationException.Type.UNSUPPORTED_EXTENSION, this.resourceName, (SyntaxElement)extension, extension.getClass().getName());
        }
        if (selfParameterName != null) {
            this.modelManager.unregisterSelfAlias(selfParameterName);
        }
        this.writeln("}");
    }

    private EClassifier getReturnType(Extension extension, MigrationExecutionContext ctx) throws MigrationException {
        HashSet<AnalysationIssue> issues = new HashSet<AnalysationIssue>();
        EClassifier returnType = extension.getReturnType(extension.getParameterTypes().toArray(new EClassifier[extension.getParameterNames().size()]), ctx, issues);
        if (issues.size() > 0) {
            throw new MigrationException(issues, this.resourceName, extension);
        }
        if (returnType == null) {
            throw new MigrationException(MigrationException.Type.TYPE_NOT_FOUND, this.resourceName, (SyntaxElement)extension.getReturnTypeIdentifier(), extension.getReturnTypeIdentifier().getValue());
        }
        return returnType;
    }

    private void migrateExpressionExtension(ExpressionExtensionStatement extension, MigrationExecutionContext ctx) throws MigrationException {
        HashMap<String, EClassifier> envVariables = new HashMap<String, EClassifier>();
        List<String> parameterNames = extension.getParameterNames();
        List<EClassifier> parameterTypes = extension.getParameterTypes();
        assert (parameterNames.size() == parameterTypes.size());
        Iterator<String> parameterNamesIterator = parameterNames.iterator();
        Iterator<EClassifier> parameterTypesIterator = parameterTypes.iterator();
        while (parameterNamesIterator.hasNext()) {
            envVariables.put(parameterNamesIterator.next(), parameterTypesIterator.next());
        }
        this.write("\t");
        ExpressionAnalyzeTrace expressionAnalyzeTrace = ctx.getTraces().get(extension);
        ExpressionMigrationFacade expressionMigrationFacade = new ExpressionMigrationFacade(extension.getExpression(), expressionAnalyzeTrace.getResultType(), envVariables, this.typeManager, this.modelManager, new VariableNameDispatcher(extension), ctx, this.resourceName);
        StringBuilder expressionContent = expressionMigrationFacade.migrate();
        this.writeln(expressionContent.insert(expressionMigrationFacade.getReturnPosition(), "return "));
    }

    private void migrateJavaExtension(JavaExtensionStatement extension, MigrationExecutionContext ctx) throws MigrationException {
        this.javaExtensionDescriptors.add(new JavaExtensionDescriptor(extension, ctx));
        if (this.nativeLibraryClassName == null) {
            this.nativeLibraryClassName = JavaExtensionDescriptor.getNativeLibraryName(extension).replaceAll("::", ".");
            if (this.nativeLibraryClassName.lastIndexOf(".") > 0) {
                this.nativeLibraryPackageName = this.nativeLibraryClassName.substring(0, this.nativeLibraryClassName.lastIndexOf("."));
                this.nativeLibraryClassName = this.nativeLibraryClassName.substring(this.nativeLibraryClassName.lastIndexOf(".") + 1);
            }
            if (this.nativeLibraryClassName.length() == 0) {
                throw new MigrationException(MigrationException.Type.UNABLE_TO_DETECT_NATIVE_LIBRARY_CLASS_NAME, this.resourceName, (SyntaxElement)extension, "Resource name: \"" + this.resourceName + "\"");
            }
        }
    }

    private void migrateCreateExtension(CreateExtensionStatement extension) throws MigrationException {
        throw new MigrationException(MigrationException.Type.UNSUPPORTED_EXTENSION, this.resourceName, (SyntaxElement)extension, extension.getClass().getName());
    }

    private void migrateWorkflowSlotExtension(WorkflowSlotExtensionStatement extension, MigrationExecutionContext ctx) throws MigrationException {
        EClassifier returnType = ctx.getTraces().get(extension).getResultType();
        this.write("\treturn ");
        if (returnType == EcorePackage.eINSTANCE.getEString()) {
            this.write(this.stdLibImportsManager.getXpandGetStringGlobalVarOperationName());
        } else {
            this.write(this.stdLibImportsManager.getXpandGetObjectGlobalVarOperationName());
            EcorePackage.eINSTANCE.getEJavaObject();
        }
        this.write("('");
        this.write(extension.getSlotName().getValue());
        this.write("')");
        if (returnType != EcorePackage.eINSTANCE.getEString() && returnType != EcorePackage.eINSTANCE.getEJavaObject()) {
            this.write(".oclAsType(");
            this.write(this.typeManager.getQvtFQName(returnType));
            this.write(")");
        }
        this.writeln("");
    }

    private void write(CharSequence cs, int index) {
        this.output.insert(index, cs);
    }

    private void write(CharSequence cs) {
        this.output.append(cs);
    }

    private void writeln(CharSequence line) {
        this.output.append(line);
        this.output.append(ExpressionMigrationFacade.LF);
    }
}

