/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.logic;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gmf.runtime.diagram.ui.editparts.NoteEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.parts.PaletteToolTransferDragSourceListener;
import org.eclipse.gmf.runtime.diagram.ui.internal.parts.PaletteToolTransferDropTargetListener;
import org.eclipse.gmf.tests.runtime.diagram.ui.AbstractTestBase;
import org.eclipse.gmf.tests.runtime.diagram.ui.logic.LogicTestFixture;

public class PaletteTests
extends AbstractTestBase {
    public static Test suite() {
        TestSuite s = new TestSuite(PaletteTests.class);
        return s;
    }

    public PaletteTests() {
        super("Palette Tests");
    }

    protected void setTestFixture() {
        this.testFixture = new LogicTestFixture();
    }

    protected LogicTestFixture getFixture() {
        return (LogicTestFixture)this.testFixture;
    }

    public void testDNDFromPalette() throws Exception {
        this.getFixture().openDiagram();
        System.out.println(this.getDiagramEditPart().getPrimaryEditParts().size());
        PaletteTests.assertEquals((int)2, (int)this.getDiagramEditPart().getPrimaryEditParts().size());
        PaletteViewer paletteViewer = (PaletteViewer)this.getFixture().getDiagramWorkbenchPart().getAdapter(PaletteViewer.class);
        class MyPaletteToolTransferDragSourceListener
        extends PaletteToolTransferDragSourceListener {
            public MyPaletteToolTransferDragSourceListener(EditPartViewer viewer) {
                super(viewer);
            }

            public Object getTemplate() {
                return super.getTemplate();
            }
        }
        MyPaletteToolTransferDragSourceListener dragListener = new MyPaletteToolTransferDragSourceListener((EditPartViewer)paletteViewer);
        class MyPaletteToolTransferDropTargetListener
        extends PaletteToolTransferDropTargetListener {
            public MyPaletteToolTransferDropTargetListener(EditPartViewer viewer) {
                super(viewer);
            }

            public Request createTargetRequest() {
                return super.createTargetRequest();
            }

            protected Point getDropLocation() {
                return new Point(10, 10);
            }
        }
        MyPaletteToolTransferDropTargetListener dropListener = new MyPaletteToolTransferDropTargetListener((EditPartViewer)paletteViewer);
        PaletteEntry noteEntry = PaletteTests.findChildPaletteEntryRecursive((PaletteContainer)paletteViewer.getPaletteRoot(), "noteTool");
        PaletteTests.assertNotNull((Object)noteEntry);
        paletteViewer.setActiveTool((ToolEntry)noteEntry);
        paletteViewer.select((EditPart)paletteViewer.getEditPartRegistry().get(noteEntry));
        TemplateTransfer.getInstance().setTemplate((Object)noteEntry);
        PaletteTests.assertNotNull((Object)dragListener.getTemplate());
        CreateRequest request = (CreateRequest)dropListener.createTargetRequest();
        request.setLocation(new Point(10, 10));
        this.getDiagramEditPart().getCommand((Request)request).execute();
        PaletteTests.assertEquals((int)3, (int)this.getDiagramEditPart().getPrimaryEditParts().size());
        Object noteEP = this.getDiagramEditPart().getPrimaryEditParts().get(2);
        PaletteTests.assertTrue((boolean)(noteEP instanceof NoteEditPart));
        PaletteEntry noteAttachmentEntry = PaletteTests.findChildPaletteEntryRecursive((PaletteContainer)paletteViewer.getPaletteRoot(), "noteattachmentTool");
        paletteViewer.setActiveTool((ToolEntry)noteAttachmentEntry);
        paletteViewer.select((EditPart)paletteViewer.getEditPartRegistry().get(noteAttachmentEntry));
        TemplateTransfer.getInstance().setTemplate((Object)noteAttachmentEntry);
        PaletteTests.assertNull((Object)dragListener.getTemplate());
    }

    private static PaletteEntry findChildPaletteEntryRecursive(PaletteContainer container, String childId) {
        for (PaletteEntry entry : container.getChildren()) {
            PaletteEntry entry2;
            if (entry.getId().equals(childId)) {
                return entry;
            }
            if (!(entry instanceof PaletteContainer) || (entry2 = PaletteTests.findChildPaletteEntryRecursive((PaletteContainer)entry, childId)) == null) continue;
            return entry2;
        }
        return null;
    }
}

