/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.graphdef.util;

import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.BasicResourceHandler;
import org.eclipse.gmf.gmfgraph.ChildAccess;
import org.eclipse.gmf.gmfgraph.Compartment;
import org.eclipse.gmf.gmfgraph.CustomFigure;
import org.eclipse.gmf.gmfgraph.DiagramElement;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FigureAccessor;
import org.eclipse.gmf.gmfgraph.FigureDescriptor;
import org.eclipse.gmf.gmfgraph.FigureGallery;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.GMFGraphPackage;
import org.eclipse.gmf.gmfgraph.RealFigure;
import org.eclipse.gmf.internal.common.ToolingResourceFactory;
import org.eclipse.gmf.internal.common.migrate.FilteringCopier;
import org.eclipse.gmf.internal.common.migrate.Messages;
import org.eclipse.gmf.internal.common.migrate.MigrationResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigrateFactory2005
extends ToolingResourceFactory {
    private static final Object MIGRATION_IN_PROGRESS = "gmf.migration";
    private static final Object MIGRATION_PARTICIPANTS = "gmf.migration.resources";
    private static final String OLD_NS_URI = "http://www.eclipse.org/gmf/2005/GraphicalDefinition";

    public Resource createResource(URI uri) {
        ToolingResourceFactory.ToolResource r = (ToolingResourceFactory.ToolResource)super.createResource(uri);
        r.getDefaultLoadOptions().put("RESOURCE_HANDLER", new BasicResourceHandler(){

            public void postLoad(XMLResource resource, InputStream inputStream, Map<?, ?> options) {
                if (Boolean.TRUE.equals(options.get(MIGRATION_IN_PROGRESS))) {
                    List participants = (List)resource.getResourceSet().getLoadOptions().get(MIGRATION_PARTICIPANTS);
                    participants.add(resource);
                    return;
                }
                try {
                    resource.getResourceSet().getLoadOptions().put(MIGRATION_IN_PROGRESS, Boolean.TRUE);
                    LinkedList<XMLResource> participants = new LinkedList<XMLResource>();
                    participants.add(resource);
                    resource.getResourceSet().getLoadOptions().put(MIGRATION_PARTICIPANTS, participants);
                    for (EObject o : resource.getContents()) {
                        if (!this.isOfInterest(o)) continue;
                        EcoreUtil.resolveAll((EObject)o);
                    }
                    HashMap wholeMigration = new HashMap();
                    for (XMLResource r : participants) {
                        for (EObject o : r.getContents()) {
                            if (!this.isOfInterest(o)) continue;
                            wholeMigration.put(o, null);
                        }
                    }
                    MigrateFactory2005.this.migrate2005to2006(wholeMigration);
                    for (XMLResource r : participants) {
                        LinkedList<EObject> migrated = new LinkedList<EObject>();
                        for (EObject o : r.getContents()) {
                            EObject m = (EObject)wholeMigration.get(o);
                            if (m != null) {
                                migrated.add(m);
                                r.getWarnings().add(0, (Object)MigrationResource.createMessageDiagnostic((Resource)r, (String)Messages.oldModelVersionLoadedMigrationRequired));
                                continue;
                            }
                            migrated.add(o);
                        }
                        r.getContents().clear();
                        r.getContents().addAll(migrated);
                    }
                }
                finally {
                    resource.getResourceSet().getLoadOptions().remove(MIGRATION_IN_PROGRESS);
                    resource.getResourceSet().getLoadOptions().remove(MIGRATION_PARTICIPANTS);
                }
            }

            private boolean isOfInterest(EObject o) {
                return o != null && MigrateFactory2005.OLD_NS_URI.equals(o.eClass().getEPackage().getNsURI());
            }
        });
        return r;
    }

    private void migrate2005to2006(Map<EObject, EObject> original2migrated) {
        EPackage oldModel = EPackage.Registry.INSTANCE.getEPackage(OLD_NS_URI);
        EClass oldFigureClass = (EClass)oldModel.getEClassifier("Figure");
        EClass oldFigureAccessorClass = (EClass)oldModel.getEClassifier("FigureAccessor");
        EStructuralFeature deFigure = ((EClass)oldModel.getEClassifier("DiagramElement")).getEStructuralFeature("figure");
        EStructuralFeature fhReferencingElements = ((EClass)oldModel.getEClassifier("FigureHandle")).getEStructuralFeature("referencingElements");
        EStructuralFeature identityName = ((EClass)oldModel.getEClassifier("Identity")).getEStructuralFeature("name");
        EStructuralFeature figureChildren = oldFigureClass.getEStructuralFeature("children");
        EStructuralFeature faTypedFigure = oldFigureAccessorClass.getEStructuralFeature("typedFigure");
        FilteringCopier cc = new FilteringCopier(false, false, (EPackage)GMFGraphPackage.eINSTANCE);
        cc.ignore(((EClass)oldModel.getEClassifier("CustomClass")).getEStructuralFeature("bundleName"));
        cc.ignore(deFigure);
        cc.ignore(fhReferencingElements);
        cc.ignoreIn(identityName, oldFigureClass);
        cc.ignore(faTypedFigure);
        cc.substitute(figureChildren, (EStructuralFeature)GMFGraphPackage.eINSTANCE.getRealFigure_Children());
        cc.copyAll(original2migrated.keySet());
        cc.copyReferences();
        for (EObject fa : cc.getIgnoredOwners(faTypedFigure)) {
            EObject newFigure;
            EObject oldReferencedFigure = (EObject)fa.eGet(faTypedFigure);
            if (oldReferencedFigure == null) {
                CustomFigure custom = GMFGraphFactory.eINSTANCE.createCustomFigure();
                custom.setQualifiedClassName("org.eclipse.draw2d.IFigure");
                ((FigureAccessor)cc.get((Object)fa)).setTypedFigure(custom);
                continue;
            }
            if (oldReferencedFigure.eIsProxy()) {
                oldReferencedFigure = EcoreUtil.resolve((EObject)oldReferencedFigure, (EObject)fa);
            }
            if ((newFigure = (EObject)cc.get((Object)oldReferencedFigure)) == null) continue;
            assert (!newFigure.eIsProxy());
            EObject copy = EcoreUtil.copy((EObject)newFigure);
            if (!(copy instanceof RealFigure)) continue;
            ((FigureAccessor)cc.get((Object)fa)).setTypedFigure((RealFigure)copy);
        }
        EClass oldFigureGalleryClass = (EClass)oldModel.getEClassifier("FigureGallery");
        HashMap<EObject, FigureDescriptor> oldFigure2newDescriptor = new HashMap<EObject, FigureDescriptor>();
        HashMap<EObject, ChildAccess> oldFigureAccessor2newChildAccess = new HashMap<EObject, ChildAccess>();
        for (EObject fh : cc.getIgnoredOwners(fhReferencingElements)) {
            List de = (List)fh.eGet(fhReferencingElements);
            if (de.isEmpty()) continue;
            if (!oldFigureClass.isInstance((Object)fh) && !oldFigureAccessorClass.isInstance((Object)fh)) {
                assert (false);
                continue;
            }
            EObject topLevel = fh;
            while (topLevel != null && !oldFigureGalleryClass.isInstance((Object)topLevel.eContainer())) {
                topLevel = topLevel.eContainer();
            }
            if (topLevel == null) {
                assert (false);
                continue;
            }
            this.initFigureDescriptor(cc, topLevel, fh, oldFigure2newDescriptor, oldFigureAccessor2newChildAccess);
        }
        for (EObject de : cc.getIgnoredOwners(deFigure)) {
            ChildAccess access;
            EObject oldFigure;
            Object fh = de.eGet(deFigure);
            if (!(fh instanceof EObject) || (oldFigure = (EObject)fh).eIsProxy() && (oldFigure = EcoreUtil.resolve((EObject)oldFigure, (EObject)de)).eIsProxy()) continue;
            if (!oldFigureClass.isInstance((Object)oldFigure) && !oldFigureAccessorClass.isInstance((Object)oldFigure)) {
                assert (false);
                continue;
            }
            EObject topLevel = oldFigure;
            while (topLevel != null && !oldFigureGalleryClass.isInstance((Object)topLevel.eContainer())) {
                topLevel = topLevel.eContainer();
            }
            if (topLevel == null) {
                assert (false);
                continue;
            }
            if (!oldFigure2newDescriptor.containsKey(topLevel)) {
                this.initFigureDescriptor(cc, topLevel, oldFigure, oldFigure2newDescriptor, oldFigureAccessor2newChildAccess);
            }
            FigureDescriptor fd = (FigureDescriptor)oldFigure2newDescriptor.get(topLevel);
            DiagramElement newDE = (DiagramElement)cc.get((Object)de);
            newDE.setFigure(fd);
            if (topLevel == oldFigure || (access = (ChildAccess)oldFigureAccessor2newChildAccess.get(oldFigure)) == null) continue;
            if (newDE instanceof DiagramLabel) {
                ((DiagramLabel)newDE).setAccessor(access);
                continue;
            }
            if (!(newDE instanceof Compartment)) continue;
            ((Compartment)newDE).setAccessor(access);
        }
        for (EObject i : cc.getIgnoredOwners(identityName)) {
            if (!(cc.get((Object)i) instanceof RealFigure) || !i.eIsSet(identityName)) continue;
            ((RealFigure)cc.get((Object)i)).setName((String)i.eGet(identityName));
        }
        for (EObject o : new LinkedList<EObject>(original2migrated.keySet())) {
            original2migrated.put(o, (EObject)cc.get((Object)o));
        }
    }

    private void initFigureDescriptor(FilteringCopier cc, EObject topLevel, EObject fh, Map<EObject, FigureDescriptor> oldFigure2newDescriptor, Map<EObject, ChildAccess> oldFigureAccessor2newChildAccess) {
        FigureDescriptor fd = oldFigure2newDescriptor.get(topLevel);
        if (fd == null) {
            fd = GMFGraphFactory.eINSTANCE.createFigureDescriptor();
            fd.setActualFigure((RealFigure)cc.get((Object)topLevel));
            fd.setName((String)topLevel.eGet(topLevel.eClass().getEStructuralFeature("name")));
            oldFigure2newDescriptor.put(topLevel, fd);
            EObject figureGallery = topLevel.eContainer();
            ((FigureGallery)cc.get((Object)figureGallery)).getDescriptors().add((Object)fd);
        }
        if (topLevel != fh && !oldFigureAccessor2newChildAccess.containsKey(fh)) {
            ChildAccess a = GMFGraphFactory.eINSTANCE.createChildAccess();
            EClass oldFigureAccessorClass = (EClass)topLevel.eClass().getEPackage().getEClassifier("FigureAccessor");
            if (oldFigureAccessorClass.isInstance((Object)fh)) {
                FigureAccessor fa = (FigureAccessor)cc.get((Object)fh);
                if (fa != null) {
                    a.setFigure(fa.getTypedFigure());
                }
            } else {
                a.setFigure((Figure)cc.get((Object)fh));
            }
            oldFigureAccessor2newChildAccess.put(fh, a);
            fd.getAccessors().add((Object)a);
        }
    }
}

