/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.edit.policies.keyhandler;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.graphdef.editor.edit.policies.KeyHandlerEditPolicy;
import org.eclipse.gmf.graphdef.editor.edit.policies.keyhandler.KeyPressedRequest;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class KeyHandler
extends org.eclipse.gef.KeyHandler {
    public static final KeyStroke ACTIVATE_CHILD_SELECTION = KeyStroke.getPressed((char)'\f', (int)108, (int)262144);
    private IDiagramGraphicalViewer myViewer;
    private Set<KeyStroke> myHandledKeyStrokes = new HashSet<KeyStroke>();

    public KeyHandler(IDiagramGraphicalViewer viewer) {
        this.myViewer = viewer;
        this.setParent(this.myViewer.getKeyHandler());
        this.myHandledKeyStrokes.add(ACTIVATE_CHILD_SELECTION);
    }

    public boolean keyPressed(KeyEvent event) {
        return this.performRequest(KeyStroke.getPressed((char)event.character, (int)event.keyCode, (int)event.stateMask)) || super.keyPressed(event);
    }

    private boolean performRequest(KeyStroke keyStroke) {
        EditPart target;
        if (this.myHandledKeyStrokes.contains(keyStroke) && (target = this.getSelectedEditPart()) != null) {
            Command command;
            KeyPressedRequest request = new KeyPressedRequest(keyStroke);
            request.setLocation(this.getCursorLocation(target));
            EditPolicy editPolicy = target.getEditPolicy((Object)"KeyHandlerEditPolicy");
            if (editPolicy instanceof KeyHandlerEditPolicy) {
                ((KeyHandlerEditPolicy)editPolicy).processRequest(request);
            }
            if ((target = target.getTargetEditPart((Request)request)) != null && (command = target.getCommand((Request)request)) != null && command.canExecute()) {
                this.myViewer.getDiagramEditDomain().getDiagramCommandStack().execute(command);
            }
            return request.isPerformed();
        }
        return false;
    }

    private Point getCursorLocation(EditPart target) {
        Display display = this.myViewer.getControl().getDisplay();
        Control control = display.getCursorControl();
        if (control == this.myViewer.getControl() && target instanceof GraphicalEditPart) {
            Point location = new Point(control.toControl(display.getCursorLocation()));
            ((GraphicalEditPart)target).getFigure().translateToRelative((Translatable)location);
            return location;
        }
        return null;
    }

    private EditPart getSelectedEditPart() {
        for (EditPart editPart : this.myViewer.getSelectedEditParts()) {
            if (editPart.getSelected() != 2) continue;
            return editPart;
        }
        return null;
    }
}

