/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.edit.policies;

import java.util.List;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.graphdef.editor.edit.parts.AbstractFigureEditPart;

public class GridLayoutHelper {
    private GridLayout myGridLayout;
    private int myColumnCount;
    private int myRowCount;
    private int[] myWidths;
    private int[] myHeights;
    private IFigure[][] myGrid;
    private List<IFigure> myChildren;

    public GridLayoutHelper(AbstractFigureEditPart host) {
        IFigure contentPane = host.getContentPane();
        LayoutManager layout = contentPane.getLayoutManager();
        assert (layout instanceof GridLayout);
        this.myGridLayout = (GridLayout)layout;
        this.myColumnCount = this.myGridLayout.numColumns;
        this.myChildren = contentPane.getChildren();
        this.myGrid = this.buildGrid(contentPane.getChildren());
        this.myWidths = this.getColumnWidths(contentPane.getBounds().width);
        this.myHeights = this.getRowHeights(contentPane.getBounds().height);
    }

    public IFigure[][] getGrid() {
        return this.myGrid;
    }

    public int[] getWidths() {
        return this.myWidths;
    }

    public int[] getHeights() {
        return this.myHeights;
    }

    public GridLayout getGridLayout() {
        return this.myGridLayout;
    }

    public int getNewChildPosition(Point where) {
        int xIndex = this.getIndex(this.myWidths, where.x);
        int yIndex = this.getIndex(this.myHeights, where.y);
        if (xIndex == this.myWidths.length || yIndex == this.myHeights.length) {
            return this.myChildren.size() - 1;
        }
        if (this.myGrid[yIndex][xIndex] == null) {
            return -1;
        }
        return this.myChildren.indexOf(this.myGrid[yIndex][xIndex]);
    }

    /*
     * Unable to fully structure code
     */
    public Rectangle getFeedbackBounds(Point where, IFigure childFigure) {
        block21: {
            block19: {
                block20: {
                    xIndex = this.getIndex(this.myWidths, where.x);
                    yIndex = this.getIndex(this.myHeights, where.y);
                    gridData = (GridData)this.myGridLayout.getConstraint(childFigure);
                    if (xIndex != this.myWidths.length && yIndex != this.myHeights.length) break block19;
                    if (this.myChildren.size() != 0) break block20;
                    xIndex = 0;
                    yIndex = 0;
                    break block21;
                }
                lastFigure = this.myChildren.get(this.myChildren.size() - 1);
                column = this.myColumnCount - 1;
                row = this.myHeights.length - 1;
                figureFound = false;
                while (!figureFound && row >= 0) {
                    column = this.myColumnCount - 1;
                    while (!figureFound && column >= 0) {
                        if (this.myGrid[row][column] == lastFigure) {
                            figureFound = true;
                            continue;
                        }
                        --column;
                    }
                    if (figureFound) continue;
                    --row;
                }
                if (figureFound) ** GOTO lbl28
                return null;
lbl-1000:
                // 1 sources

                {
                    --row;
lbl28:
                    // 2 sources

                    ** while (row > 0 && this.myGrid[row][column] == this.myGrid[row - 1][column])
                }
lbl29:
                // 1 sources

                hSpan = Math.max(1, Math.min(gridData.horizontalSpan, this.myColumnCount));
                ** GOTO lbl45
                {
                    ++column;
                    do {
                        if (column < this.myColumnCount && this.myGrid[row][column] != null) continue block3;
                        endCount = column + hSpan;
                        if (endCount <= this.myColumnCount) {
                            index = column;
                            while (index < endCount && this.myGrid[row][index] == null) {
                                ++index;
                            }
                            if (index == endCount) break block3;
                            column = index;
                        }
                        if (column + hSpan < this.myColumnCount) continue;
                        column = 0;
                        ++row;
lbl45:
                        // 3 sources

                    } while (row < this.myHeights.length);
                }
                xIndex = column;
                yIndex = row;
                break block21;
            }
            if (this.myGrid[yIndex][xIndex] != null) ** GOTO lbl53
            return null;
lbl-1000:
            // 1 sources

            {
                --xIndex;
lbl53:
                // 2 sources

                ** while (xIndex > 0 && this.myGrid[yIndex][xIndex] == this.myGrid[yIndex][xIndex - 1])
            }
lbl54:
            // 2 sources

            while (yIndex > 0 && this.myGrid[yIndex][xIndex] == this.myGrid[yIndex - 1][xIndex]) {
                --yIndex;
            }
        }
        xPosition = 0;
        i = 0;
        while (i < xIndex) {
            xPosition += this.myWidths[i];
            ++i;
        }
        yPosition = 0;
        i = 0;
        while (i < yIndex) {
            yPosition += this.myHeights[i];
            ++i;
        }
        width = this.myWidths[xIndex];
        height = this.myHeights[yIndex];
        if (childFigure != null) {
            if (xIndex + gridData.horizontalSpan > this.myWidths.length) {
                width = childFigure.getBounds().width;
            } else {
                i = xIndex + 1;
                while (i < xIndex + gridData.horizontalSpan) {
                    width += this.myWidths[i];
                    ++i;
                }
            }
            if (yIndex + gridData.verticalAlignment > this.myHeights.length) {
                height = childFigure.getBounds().height;
            } else {
                i = yIndex + 1;
                while (i < yIndex + gridData.verticalSpan) {
                    height += this.myHeights[i];
                    ++i;
                }
            }
        }
        return new Rectangle(xPosition, yPosition, width, height);
    }

    private int getIndex(int[] cellSizes, int coordinate) {
        int position = 0;
        int i = 0;
        while (i < cellSizes.length) {
            if (position <= coordinate && coordinate < cellSizes[i] + position) {
                return i;
            }
            position += cellSizes[i];
            ++i;
        }
        return cellSizes.length;
    }

    private IFigure[][] buildGrid(List children) {
        this.myRowCount = 0;
        int row = 0;
        int column = 0;
        IFigure[][] grid = new IFigure[4][this.myColumnCount];
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            GridData data = (GridData)this.myGridLayout.getConstraint(child);
            int hSpan = Math.max(1, Math.min(data.horizontalSpan, this.myColumnCount));
            int vSpan = Math.max(1, data.verticalSpan);
            while (true) {
                int lastRow;
                if ((lastRow = row + vSpan) >= grid.length) {
                    IFigure[][] newGrid = new IFigure[lastRow + 4][this.myColumnCount];
                    System.arraycopy(grid, 0, newGrid, 0, grid.length);
                    grid = newGrid;
                }
                if (grid[row] == null) {
                    grid[row] = new IFigure[this.myColumnCount];
                }
                while (column < this.myColumnCount && grid[row][column] != null) {
                    ++column;
                }
                int endCount = column + hSpan;
                if (endCount <= this.myColumnCount) {
                    int index = column;
                    while (index < endCount && grid[row][index] == null) {
                        ++index;
                    }
                    if (index == endCount) break;
                    column = index;
                }
                if (column + hSpan < this.myColumnCount) continue;
                column = 0;
                ++row;
            }
            int j = 0;
            while (j < vSpan) {
                if (grid[row + j] == null) {
                    grid[row + j] = new IFigure[this.myColumnCount];
                }
                int k = 0;
                while (k < hSpan) {
                    grid[row + j][column + k] = child;
                    ++k;
                }
                ++j;
            }
            this.myRowCount = Math.max(this.myRowCount, row + vSpan);
            column += hSpan;
            ++i;
        }
        return grid;
    }

    private int[] getColumnWidths(int width) {
        int[] widths;
        block45: {
            int i;
            boolean[] expandColumn;
            int[] minWidths;
            int expandCount;
            int availableWidth;
            block46: {
                availableWidth = width - this.myGridLayout.horizontalSpacing * (this.myColumnCount - 1) - this.myGridLayout.marginWidth * 2;
                expandCount = 0;
                widths = new int[this.myColumnCount];
                minWidths = new int[this.myColumnCount];
                expandColumn = new boolean[this.myColumnCount];
                int j = 0;
                while (j < this.myColumnCount) {
                    int hSpan;
                    GridData data;
                    i = 0;
                    while (i < this.myRowCount) {
                        data = this.getData(this.myGrid, i, j, this.myRowCount, this.myColumnCount, true);
                        if (data != null && (hSpan = Math.max(1, Math.min(data.horizontalSpan, this.myColumnCount))) == 1) {
                            int cacheWidth = this.getCacheWidth(this.myGrid, i, j, data);
                            int w = cacheWidth + data.horizontalIndent;
                            widths[j] = Math.max(widths[j], w);
                            if (data.grabExcessHorizontalSpace) {
                                if (!expandColumn[j]) {
                                    ++expandCount;
                                }
                                expandColumn[j] = true;
                            }
                            if (data.widthHint != -1 || !data.grabExcessHorizontalSpace) {
                                minWidths[j] = Math.max(minWidths[j], w);
                            }
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < this.myRowCount) {
                        data = this.getData(this.myGrid, i, j, this.myRowCount, this.myColumnCount, false);
                        if (data != null && (hSpan = Math.max(1, Math.min(data.horizontalSpan, this.myColumnCount))) > 1) {
                            int k;
                            int last;
                            int remainder;
                            int delta;
                            int cacheWidth;
                            int w;
                            int spanWidth = 0;
                            int spanMinWidth = 0;
                            int spanExpandCount = 0;
                            int k2 = 0;
                            while (k2 < hSpan) {
                                spanWidth += widths[j - k2];
                                spanMinWidth += minWidths[j - k2];
                                if (expandColumn[j - k2]) {
                                    ++spanExpandCount;
                                }
                                ++k2;
                            }
                            if (data.grabExcessHorizontalSpace && spanExpandCount == 0) {
                                ++expandCount;
                                expandColumn[j] = true;
                            }
                            if ((w = (cacheWidth = this.getCacheWidth(this.myGrid, i, j, data)) + data.horizontalIndent - spanWidth - (hSpan - 1) * this.myGridLayout.horizontalSpacing) > 0) {
                                if (spanExpandCount == 0) {
                                    int n = j;
                                    widths[n] = widths[n] + w;
                                } else {
                                    delta = w / spanExpandCount;
                                    remainder = w % spanExpandCount;
                                    last = -1;
                                    k = 0;
                                    while (k < hSpan) {
                                        if (expandColumn[j - k]) {
                                            last = j - k;
                                            widths[last] = widths[last] + delta;
                                        }
                                        ++k;
                                    }
                                    if (last > -1) {
                                        int n = last;
                                        widths[n] = widths[n] + remainder;
                                    }
                                }
                            }
                            if (!(data.widthHint == -1 && data.grabExcessHorizontalSpace || (w = cacheWidth + data.horizontalIndent - spanMinWidth - (hSpan - 1) * this.myGridLayout.horizontalSpacing) <= 0)) {
                                if (spanExpandCount == 0) {
                                    int n = j;
                                    minWidths[n] = minWidths[n] + w;
                                } else {
                                    delta = w / spanExpandCount;
                                    remainder = w % spanExpandCount;
                                    last = -1;
                                    k = 0;
                                    while (k < hSpan) {
                                        if (expandColumn[j - k]) {
                                            last = j - k;
                                            minWidths[last] = minWidths[last] + delta;
                                        }
                                        ++k;
                                    }
                                    if (last > -1) {
                                        int n = last;
                                        minWidths[n] = minWidths[n] + remainder;
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                    ++j;
                }
                if (!this.myGridLayout.makeColumnsEqualWidth) break block46;
                int minColumnWidth = 0;
                int columnWidth = 0;
                int i2 = 0;
                while (i2 < this.myColumnCount) {
                    minColumnWidth = Math.max(minColumnWidth, minWidths[i2]);
                    columnWidth = Math.max(columnWidth, widths[i2]);
                    ++i2;
                }
                columnWidth = width == -1 || expandCount == 0 ? columnWidth : Math.max(minColumnWidth, availableWidth / this.myColumnCount);
                i2 = 0;
                while (i2 < this.myColumnCount) {
                    expandColumn[i2] = expandCount > 0;
                    widths[i2] = columnWidth;
                    ++i2;
                }
                break block45;
            }
            if (width == -1 || expandCount <= 0) break block45;
            int totalWidth = 0;
            i = 0;
            while (i < this.myColumnCount) {
                totalWidth += widths[i];
                ++i;
            }
            int count = expandCount;
            int delta = (availableWidth - totalWidth) / count;
            int remainder = (availableWidth - totalWidth) % count;
            int last = -1;
            while (totalWidth != availableWidth) {
                int j = 0;
                while (j < this.myColumnCount) {
                    if (expandColumn[j]) {
                        if (widths[j] + delta > minWidths[j]) {
                            last = j;
                            widths[last] = widths[j] + delta;
                        } else {
                            widths[j] = minWidths[j];
                            expandColumn[j] = false;
                            --count;
                        }
                    }
                    ++j;
                }
                if (last > -1) {
                    int n = last;
                    widths[n] = widths[n] + remainder;
                }
                j = 0;
                while (j < this.myColumnCount) {
                    int i3 = 0;
                    while (i3 < this.myRowCount) {
                        int hSpan;
                        GridData data = this.getData(this.myGrid, i3, j, this.myRowCount, this.myColumnCount, false);
                        if (!(data == null || (hSpan = Math.max(1, Math.min(data.horizontalSpan, this.myColumnCount))) <= 1 || data.widthHint == -1 && data.grabExcessHorizontalSpace)) {
                            int spanWidth = 0;
                            int spanExpandCount = 0;
                            int k = 0;
                            while (k < hSpan) {
                                spanWidth += widths[j - k];
                                if (expandColumn[j - k]) {
                                    ++spanExpandCount;
                                }
                                ++k;
                            }
                            int cacheWidth = this.getCacheWidth(this.myGrid, i3, j, data);
                            int w = cacheWidth + data.horizontalIndent - spanWidth - (hSpan - 1) * this.myGridLayout.horizontalSpacing;
                            if (w > 0) {
                                if (spanExpandCount == 0) {
                                    int n = j;
                                    widths[n] = widths[n] + w;
                                } else {
                                    int delta2 = w / spanExpandCount;
                                    int remainder2 = w % spanExpandCount;
                                    int last2 = -1;
                                    int k3 = 0;
                                    while (k3 < hSpan) {
                                        if (expandColumn[j - k3]) {
                                            last2 = j - k3;
                                            widths[last2] = widths[last2] + delta2;
                                        }
                                        ++k3;
                                    }
                                    if (last2 > -1) {
                                        int n = last2;
                                        widths[n] = widths[n] + remainder2;
                                    }
                                }
                            }
                        }
                        ++i3;
                    }
                    ++j;
                }
                if (count != 0) {
                    totalWidth = 0;
                    int i4 = 0;
                    while (i4 < this.myColumnCount) {
                        totalWidth += widths[i4];
                        ++i4;
                    }
                    delta = (availableWidth - totalWidth) / count;
                    remainder = (availableWidth - totalWidth) % count;
                    last = -1;
                    continue;
                }
                break;
            }
        }
        return widths;
    }

    private int[] getRowHeights(int height) {
        int availableHeight = height - this.myGridLayout.verticalSpacing * (this.myRowCount - 1) - this.myGridLayout.marginHeight * 2;
        int expandCount = 0;
        int[] heights = new int[this.myRowCount];
        int[] minHeights = new int[this.myRowCount];
        boolean[] expandRow = new boolean[this.myRowCount];
        int i = 0;
        while (i < this.myRowCount) {
            int vSpan;
            GridData data;
            int j = 0;
            while (j < this.myColumnCount) {
                data = this.getData(this.myGrid, i, j, this.myRowCount, this.myColumnCount, true);
                if (data != null && (vSpan = Math.max(1, Math.min(data.verticalSpan, this.myRowCount))) == 1) {
                    int h = this.getCacheHeight(this.myGrid, i, j, data);
                    heights[i] = Math.max(heights[i], h);
                    if (data.grabExcessVerticalSpace) {
                        if (!expandRow[i]) {
                            ++expandCount;
                        }
                        expandRow[i] = true;
                    }
                    if (data.heightHint != -1 || !data.grabExcessVerticalSpace) {
                        minHeights[i] = Math.max(minHeights[i], h);
                    }
                }
                ++j;
            }
            j = 0;
            while (j < this.myColumnCount) {
                data = this.getData(this.myGrid, i, j, this.myRowCount, this.myColumnCount, false);
                if (data != null && (vSpan = Math.max(1, Math.min(data.verticalSpan, this.myRowCount))) > 1) {
                    int k;
                    int last;
                    int remainder;
                    int delta;
                    int cacheHeight;
                    int h;
                    int spanHeight = 0;
                    int spanMinHeight = 0;
                    int spanExpandCount = 0;
                    int k2 = 0;
                    while (k2 < vSpan) {
                        spanHeight += heights[i - k2];
                        spanMinHeight += minHeights[i - k2];
                        if (expandRow[i - k2]) {
                            ++spanExpandCount;
                        }
                        ++k2;
                    }
                    if (data.grabExcessVerticalSpace && spanExpandCount == 0) {
                        ++expandCount;
                        expandRow[i] = true;
                    }
                    if ((h = (cacheHeight = this.getCacheHeight(this.myGrid, i, j, data)) - spanHeight - (vSpan - 1) * this.myGridLayout.verticalSpacing) > 0) {
                        if (spanExpandCount == 0) {
                            int n = i;
                            heights[n] = heights[n] + h;
                        } else {
                            delta = h / spanExpandCount;
                            remainder = h % spanExpandCount;
                            last = -1;
                            k = 0;
                            while (k < vSpan) {
                                if (expandRow[i - k]) {
                                    last = i - k;
                                    heights[last] = heights[last] + delta;
                                }
                                ++k;
                            }
                            if (last > -1) {
                                int n = last;
                                heights[n] = heights[n] + remainder;
                            }
                        }
                    }
                    if (!(data.heightHint == -1 && data.grabExcessVerticalSpace || (h = cacheHeight - spanMinHeight - (vSpan - 1) * this.myGridLayout.verticalSpacing) <= 0)) {
                        if (spanExpandCount == 0) {
                            int n = i;
                            minHeights[n] = minHeights[n] + h;
                        } else {
                            delta = h / spanExpandCount;
                            remainder = h % spanExpandCount;
                            last = -1;
                            k = 0;
                            while (k < vSpan) {
                                if (expandRow[i - k]) {
                                    last = i - k;
                                    minHeights[last] = minHeights[last] + delta;
                                }
                                ++k;
                            }
                            if (last > -1) {
                                int n = last;
                                minHeights[n] = minHeights[n] + remainder;
                            }
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        if (height != -1 && expandCount > 0) {
            int totalHeight = 0;
            int i2 = 0;
            while (i2 < this.myRowCount) {
                totalHeight += heights[i2];
                ++i2;
            }
            int count = expandCount;
            int delta = (availableHeight - totalHeight) / count;
            int remainder = (availableHeight - totalHeight) % count;
            int last = -1;
            while (totalHeight != availableHeight) {
                int i3 = 0;
                while (i3 < this.myRowCount) {
                    if (expandRow[i3]) {
                        if (heights[i3] + delta > minHeights[i3]) {
                            last = i3;
                            heights[last] = heights[i3] + delta;
                        } else {
                            heights[i3] = minHeights[i3];
                            expandRow[i3] = false;
                            --count;
                        }
                    }
                    ++i3;
                }
                if (last > -1) {
                    int n = last;
                    heights[n] = heights[n] + remainder;
                }
                i3 = 0;
                while (i3 < this.myRowCount) {
                    int j = 0;
                    while (j < this.myColumnCount) {
                        int vSpan;
                        GridData data = this.getData(this.myGrid, i3, j, this.myRowCount, this.myColumnCount, false);
                        if (!(data == null || (vSpan = Math.max(1, Math.min(data.verticalSpan, this.myRowCount))) <= 1 || data.heightHint == -1 && data.grabExcessVerticalSpace)) {
                            int spanHeight = 0;
                            int spanExpandCount = 0;
                            int k = 0;
                            while (k < vSpan) {
                                spanHeight += heights[i3 - k];
                                if (expandRow[i3 - k]) {
                                    ++spanExpandCount;
                                }
                                ++k;
                            }
                            int cacheHeight = this.getCacheHeight(this.myGrid, i3, j, data);
                            int h = cacheHeight - spanHeight - (vSpan - 1) * this.myGridLayout.verticalSpacing;
                            if (h > 0) {
                                if (spanExpandCount == 0) {
                                    int n = i3;
                                    heights[n] = heights[n] + h;
                                } else {
                                    int delta2 = h / spanExpandCount;
                                    int remainder2 = h % spanExpandCount;
                                    int last2 = -1;
                                    int k3 = 0;
                                    while (k3 < vSpan) {
                                        if (expandRow[i3 - k3]) {
                                            last2 = i3 - k3;
                                            heights[last2] = heights[last2] + delta2;
                                        }
                                        ++k3;
                                    }
                                    if (last2 > -1) {
                                        int n = last2;
                                        heights[n] = heights[n] + remainder2;
                                    }
                                }
                            }
                        }
                        ++j;
                    }
                    ++i3;
                }
                if (count == 0) break;
                totalHeight = 0;
                i3 = 0;
                while (i3 < this.myRowCount) {
                    totalHeight += heights[i3];
                    ++i3;
                }
                delta = (availableHeight - totalHeight) / count;
                remainder = (availableHeight - totalHeight) % count;
                last = -1;
            }
        }
        return heights;
    }

    private GridData getData(IFigure[][] grid, int row, int column, int rowCount, int columnCount, boolean first) {
        IFigure figure = grid[row][column];
        if (figure != null) {
            int j;
            GridData data = (GridData)this.myGridLayout.getConstraint(figure);
            int hSpan = Math.max(1, Math.min(data.horizontalSpan, columnCount));
            int vSpan = Math.max(1, data.verticalSpan);
            int i = first ? row + vSpan - 1 : row - vSpan + 1;
            int n = j = first ? column + hSpan - 1 : column - hSpan + 1;
            if (i >= 0 && i < rowCount && j >= 0 && j < columnCount && figure == grid[i][j]) {
                return data;
            }
        }
        return null;
    }

    private int getCacheHeight(IFigure[][] grid, int row, int column, GridData data) {
        return grid[row][column].getPreferredSize((int)data.widthHint, (int)data.heightHint).height;
    }

    private int getCacheWidth(IFigure[][] grid, int row, int column, GridData data) {
        return grid[row][column].getPreferredSize((int)data.widthHint, (int)data.heightHint).width;
    }
}

