/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.examples.runtime.diagram.logic.internal.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.LogicDiagramDebugOptions;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.LogicDiagramPlugin;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.ContainerElement;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.Element;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.Gate;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.InputOutputTerminal;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.InputTerminal;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.OutputTerminal;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.SemanticPackage;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.Terminal;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.Wire;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.util.LogicSemanticType;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;

public abstract class ConfigureLogicElementCommand
extends ConfigureElementCommand {
    private static final EReference TERMINALS = SemanticPackage.eINSTANCE.getElement_Terminals();

    protected ConfigureLogicElementCommand(ConfigureRequest request, EClass configurableType) {
        super(request);
        this.setEClass(configurableType);
    }

    protected InputTerminal createInputTerminal(Element logicElement, String id, IProgressMonitor progressMonitor) {
        return (InputTerminal)this.createTerminal(LogicSemanticType.INPUT_TERMINAL, logicElement, id, progressMonitor);
    }

    protected OutputTerminal createOutputTerminal(Element logicElement, String id, IProgressMonitor progressMonitor) {
        return (OutputTerminal)this.createTerminal(LogicSemanticType.OUTPUT_TERMINAL, logicElement, id, progressMonitor);
    }

    protected InputOutputTerminal createInputOutputTerminal(Element logicElement, String id, IProgressMonitor progressMonitor) {
        return (InputOutputTerminal)this.createTerminal(LogicSemanticType.INPUT_OUTPUT_TERMINAL, logicElement, id, progressMonitor);
    }

    private Terminal createTerminal(IElementType elementType, Element logicElement, String id, IProgressMonitor progressMonitor) {
        Terminal terminal = this.createTerminal(elementType, logicElement, progressMonitor);
        if (terminal != null) {
            this.setTerminalId(elementType, terminal, id, progressMonitor);
        }
        return terminal;
    }

    private Terminal createTerminal(IElementType terminalType, Element logicElement, IProgressMonitor progressMonitor) {
        Element result = this.createElement(logicElement, terminalType, TERMINALS, progressMonitor);
        if (result instanceof Terminal) {
            return (Terminal)result;
        }
        return null;
    }

    protected Wire createWire(OutputTerminal source, InputTerminal target, IProgressMonitor progressMonitor) {
        ICommand createCommand;
        CreateRelationshipRequest createRequest = new CreateRelationshipRequest(this.getEditingDomain(), (EObject)source, (EObject)target, LogicSemanticType.WIRE);
        IElementType elementType = ElementTypeRegistry.getInstance().getElementType(createRequest.getEditHelperContext());
        if (elementType != null && (createCommand = elementType.getEditCommand((IEditCommandRequest)createRequest)) != null && createCommand.canExecute()) {
            try {
                Object result;
                createCommand.execute(progressMonitor, null);
                CommandResult commandResult = createCommand.getCommandResult();
                if (this.isOK(commandResult) && (result = commandResult.getReturnValue()) instanceof Wire) {
                    return (Wire)result;
                }
            }
            catch (ExecutionException e) {
                Trace.catching((Plugin)LogicDiagramPlugin.getInstance(), (String)LogicDiagramDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"createWire", (Throwable)e);
                Log.error((Plugin)LogicDiagramPlugin.getInstance(), (int)4, (String)e.getLocalizedMessage());
            }
        }
        return null;
    }

    protected Gate createGate(ContainerElement container, IElementType gateType, IProgressMonitor progressMonitor) {
        Element result = this.createElement((Element)container, gateType, null, progressMonitor);
        if (result instanceof Gate) {
            return (Gate)result;
        }
        return null;
    }

    private Element createElement(Element container, IElementType type, EReference containmentFeature, IProgressMonitor progressMonitor) {
        ICommand createCommand;
        CreateElementRequest createRequest = new CreateElementRequest(this.getEditingDomain(), (EObject)container, type, containmentFeature);
        IElementType elementType = ElementTypeRegistry.getInstance().getElementType(createRequest.getEditHelperContext());
        if (elementType != null && (createCommand = elementType.getEditCommand((IEditCommandRequest)createRequest)) != null && createCommand.canExecute()) {
            try {
                Object result;
                createCommand.execute(progressMonitor, null);
                CommandResult commandResult = createCommand.getCommandResult();
                if (this.isOK(commandResult) && (result = commandResult.getReturnValue()) instanceof Element) {
                    return (Element)result;
                }
            }
            catch (ExecutionException e) {
                Trace.catching((Plugin)LogicDiagramPlugin.getInstance(), (String)LogicDiagramDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"createElement", (Throwable)e);
                Log.error((Plugin)LogicDiagramPlugin.getInstance(), (int)4, (String)e.getLocalizedMessage());
            }
        }
        return null;
    }

    private void setTerminalId(IElementType elementType, Terminal terminal, String id, IProgressMonitor progressMonitor) {
        SetRequest setRequest = new SetRequest(this.getEditingDomain(), (EObject)terminal, (EStructuralFeature)SemanticPackage.eINSTANCE.getTerminal_Id(), (Object)id);
        ICommand setCommand = elementType.getEditCommand((IEditCommandRequest)setRequest);
        if (setCommand != null && setCommand.canExecute()) {
            try {
                setCommand.execute(progressMonitor, null);
            }
            catch (ExecutionException e) {
                Trace.catching((Plugin)LogicDiagramPlugin.getInstance(), (String)LogicDiagramDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"setTerminalId", (Throwable)e);
                Log.error((Plugin)LogicDiagramPlugin.getInstance(), (int)4, (String)e.getLocalizedMessage());
            }
        }
    }
}

