/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.transform;

import org.eclipse.emf.common.ui.DiagnosticComposite;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.gmf.internal.bridge.transform.Messages;
import org.eclipse.gmf.internal.bridge.transform.TransformToGenModelOperation;
import org.eclipse.gmf.internal.bridge.transform.TransformToGenModelWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

abstract class ModelDiagnosticPage
extends WizardPage {
    private DiagnosticComposite myDiagnosticComposite;
    private Button myIgnoreButton;

    ModelDiagnosticPage(String pageName) {
        super(pageName);
    }

    void applyValidation() {
        boolean ignore = this.myIgnoreButton.getSelection();
        this.setIgnoreOption(ignore);
        this.setPageComplete(ignore);
    }

    public void createControl(Composite parent) {
        Composite plate = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        plate.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        plate.setLayoutData((Object)data);
        this.createDiagnosticComposite(plate);
        this.createIgnoreButton(plate);
        this.setControl((Control)plate);
    }

    private void createDiagnosticComposite(Composite parent) {
        this.myDiagnosticComposite = new DiagnosticComposite(parent, 0);
        this.myDiagnosticComposite.initialize(null);
        this.myDiagnosticComposite.setShowRootDiagnostic(true);
        this.myDiagnosticComposite.setSeverityMask(4);
        GridData data = new GridData(4, 4, true, true);
        this.myDiagnosticComposite.setLayoutData((Object)data);
    }

    private void createIgnoreButton(Composite parent) {
        this.myIgnoreButton = new Button(parent, 32);
        this.myIgnoreButton.setText(Messages.MapModelDiagnosticPage_btn_ignore_text);
        this.setButtonLayoutData(this.myIgnoreButton);
        this.myIgnoreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelDiagnosticPage.this.applyValidation();
            }
        });
    }

    protected abstract boolean getIgnoreOption();

    protected TransformToGenModelOperation getOperation() {
        TransformToGenModelWizard wizard = (TransformToGenModelWizard)this.getWizard();
        return wizard.getTransformOperation();
    }

    protected abstract Diagnostic getValidationResult();

    private void initControls() {
        Diagnostic diagnostic = this.getValidationResult();
        this.myDiagnosticComposite.setDiagnostic(diagnostic);
        boolean ignore = this.getIgnoreOption();
        this.myIgnoreButton.setSelection(ignore);
        this.setPageComplete(ignore);
    }

    protected abstract void setIgnoreOption(boolean var1);

    public void setVisible(boolean visible) {
        if (visible) {
            this.initControls();
        }
        super.setVisible(visible);
    }
}

