/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.ui.dashboard.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.bridge.ui.dashboard.DashboardAction;
import org.eclipse.gmf.bridge.ui.dashboard.DashboardFacade;
import org.eclipse.gmf.bridge.ui.dashboard.DashboardState;
import org.eclipse.gmf.internal.bridge.transform.TransformOptions;
import org.eclipse.gmf.internal.bridge.transform.TransformToGenModelOperation;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;

public class TransformMap2GenModelAction
implements DashboardAction {
    private DashboardFacade context;

    public void init(DashboardFacade context) {
        this.context = context;
    }

    public boolean isEnabled() {
        DashboardState state = this.context.getState();
        if (this.context.isStrict() && (state.getDM() == null || state.getDGM() == null || state.getTDM() == null)) {
            return false;
        }
        return state.getMM() != null;
    }

    public void run() {
        DashboardState state = this.context.getState();
        URI mm = state.getMM();
        URI gm = state.getGM();
        if (gm == null) {
            gm = mm.trimFileExtension().appendFileExtension("gmfgen");
            state.setGM(gm);
        }
        try {
            try {
                TransformToGenModelOperation op = new TransformToGenModelOperation();
                this.configureOptions(op.getOptions());
                ResourceSetImpl rs = new ResourceSetImpl();
                op.loadMappingModel((ResourceSet)rs, mm, (IProgressMonitor)new NullProgressMonitor());
                op.loadGenModel((ResourceSet)rs, state.getDGM(), (IProgressMonitor)new NullProgressMonitor());
                op.setGenURI(gm);
                op.executeTransformation((ResourceSet)rs, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException ce) {
                ErrorDialog.openError((Shell)this.context.getShell(), null, (String)ce.getMessage(), (IStatus)ce.getStatus());
                this.context.updateStatus();
            }
        }
        finally {
            this.context.updateStatus();
        }
    }

    protected void configureOptions(TransformOptions options) {
        options.setUseRuntimeFigures(true);
        options.setUseMapMode(true);
        options.setGenerateRCP(this.context.getState().getOption("rcp"));
    }
}

