/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.bridge.ui.dashboard;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.internal.bridge.ui.dashboard.Plugin;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public final class DashboardState {
    private static final String DM_KEY = "domainModel";
    private static final String DGM_KEY = "domainGenerationModel";
    private static final String GDM_KEY = "graphicalDefinitionModel";
    private static final String TDM_KEY = "toolingDefinitionModel";
    private static final String MM_KEY = "mappingModel";
    private static final String GM_KEY = "generationModel";
    private URI dm;
    private URI dgm;
    private URI gdm;
    private URI tdm;
    private URI mm;
    private URI gm;
    private Preferences prefs;

    public DashboardState() {
    }

    public DashboardState(Preferences prefs) {
        this.prefs = prefs;
        this.dm = this.read(DM_KEY);
        this.dgm = this.read(DGM_KEY);
        this.gdm = this.read(GDM_KEY);
        this.tdm = this.read(TDM_KEY);
        this.mm = this.read(MM_KEY);
        this.gm = this.read(GM_KEY);
    }

    public URI getDM() {
        return this.dm;
    }

    public URI getDGM() {
        return this.dgm;
    }

    public URI getGDM() {
        return this.gdm;
    }

    public URI getTDM() {
        return this.tdm;
    }

    public URI getMM() {
        return this.mm;
    }

    public URI getGM() {
        return this.gm;
    }

    public void setDM(URI uri) {
        this.dm = uri;
        this.write(DM_KEY, this.dm);
    }

    public void setDGM(URI uri) {
        this.dgm = uri;
        this.write(DGM_KEY, this.dgm);
    }

    public void setGDM(URI uri) {
        this.gdm = uri;
        this.write(GDM_KEY, this.gdm);
    }

    public void setTDM(URI uri) {
        this.tdm = uri;
        this.write(TDM_KEY, this.tdm);
    }

    public void setMM(URI uri) {
        this.mm = uri;
        this.write(MM_KEY, this.mm);
    }

    public void setGM(URI uri) {
        this.gm = uri;
        this.write(GM_KEY, this.gm);
    }

    public void setDM(IFile file) {
        this.dm = DashboardState.getURI(file);
        this.write(DM_KEY, this.dm);
    }

    public void setDGM(IFile file) {
        this.dgm = DashboardState.getURI(file);
        this.write(DGM_KEY, this.dgm);
    }

    public void setGDM(IFile file) {
        this.gdm = DashboardState.getURI(file);
        this.write(GDM_KEY, this.gdm);
    }

    public void setTDM(IFile file) {
        this.tdm = DashboardState.getURI(file);
        this.write(TDM_KEY, this.tdm);
    }

    public void setMM(IFile file) {
        this.mm = DashboardState.getURI(file);
        this.write(MM_KEY, this.mm);
    }

    public void setGM(IFile file) {
        this.gm = DashboardState.getURI(file);
        this.write(GM_KEY, this.gm);
    }

    private static URI getURI(IFile file) {
        if (file == null) {
            return null;
        }
        return URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
    }

    public int getModelsCount() {
        return 6;
    }

    public int getSpecifiedModelsCount() {
        int count = 0;
        if (this.dm != null) {
            ++count;
        }
        if (this.dgm != null) {
            ++count;
        }
        if (this.gdm != null) {
            ++count;
        }
        if (this.tdm != null) {
            ++count;
        }
        if (this.mm != null) {
            ++count;
        }
        if (this.gm != null) {
            ++count;
        }
        return count;
    }

    private URI read(String key) {
        if (this.prefs == null) {
            return null;
        }
        String s = this.prefs.get(key, null);
        if (s == null) {
            return null;
        }
        try {
            return URI.createURI((String)s);
        }
        catch (IllegalArgumentException e) {
            IStatus status = Plugin.createError("Invalid URI", e);
            Plugin.getDefault().getLog().log(status);
            return null;
        }
    }

    private void write(String key, URI uri) {
        String s = null;
        if (uri != null) {
            s = uri.toString();
        }
        this.prefs.put(key, s);
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException e) {
            IStatus status = Plugin.createError("Unable to update state", (Exception)((Object)e));
            Plugin.getDefault().getLog().log(status);
        }
    }
}

