/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.core.services;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.search.Activator;
import org.eclipse.emf.search.core.services.AbstractExtensionManager;
import org.eclipse.emf.search.core.services.ModelSearchEngineDescriptor;
import org.eclipse.emf.search.l10n.Messages;

public final class ModelExtensibleSearchEngineExtensionManager
extends AbstractExtensionManager {
    private static final String bundleId = Activator.getDefault().getBundle().getSymbolicName();
    public static final String MODELING_CORE_MODEL_SEARCH_ENGINE_EXT_POINT_ID = String.valueOf(bundleId) + ".modelSearchEngine";
    private static ModelExtensibleSearchEngineExtensionManager manager;
    private SortedSet<ModelSearchEngineDescriptor> searchEngineContributions = new TreeSet<ModelSearchEngineDescriptor>(new Comparator<ModelSearchEngineDescriptor>(){

        @Override
        public int compare(ModelSearchEngineDescriptor o1, ModelSearchEngineDescriptor o2) {
            return o1.getID().compareTo(o2.getID());
        }
    });

    protected ModelExtensibleSearchEngineExtensionManager() {
        super(MODELING_CORE_MODEL_SEARCH_ENGINE_EXT_POINT_ID);
        this.readRegistry();
    }

    public static ModelExtensibleSearchEngineExtensionManager getInstance() {
        return manager == null ? (manager = new ModelExtensibleSearchEngineExtensionManager()) : manager;
    }

    public ModelSearchEngineDescriptor find(String id) {
        for (ModelSearchEngineDescriptor desc : this.searchEngineContributions) {
            if (!id.equals(desc.getID())) continue;
            return desc;
        }
        return null;
    }

    public ModelSearchEngineDescriptor[] getModelSearchEngines() {
        return this.searchEngineContributions.toArray(new ModelSearchEngineDescriptor[this.searchEngineContributions.size()]);
    }

    protected void addExtension(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement confElt = elements[i];
            try {
                this.searchEngineContributions.add(new ModelSearchEngineDescriptor(confElt));
            }
            catch (CoreException ce) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, bundleId, 0, Messages.getString("ModelExtensibleSearchEngineExtensionManager.addExtensionErrorMessage"), (Throwable)ce));
            }
            ++i;
        }
    }

    protected void removeExtension(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement confElt = elements[i];
            String id = confElt.getAttribute("id");
            ModelSearchEngineDescriptor descriptor = this.find(id);
            this.searchEngineContributions.remove(descriptor);
            ++i;
        }
    }
}

