/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.core.engine;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.search.core.engine.IModelSearchQuery;
import org.eclipse.emf.search.core.eval.IModelSearchQueryEvaluator;
import org.eclipse.emf.search.core.parameters.IModelSearchQueryParameters;
import org.eclipse.emf.search.core.results.IModelResultEntry;
import org.eclipse.emf.search.core.results.IModelSearchResult;
import org.eclipse.emf.search.core.results.ModelSearchResult;
import org.eclipse.emf.search.core.scope.IModelSearchScope;
import org.eclipse.emf.search.l10n.Messages;
import org.eclipse.search.ui.ISearchResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModelSearchQuery
implements IModelSearchQuery {
    private IModelSearchResult modelSearchResult;
    private IModelSearchQueryParameters modelSearchParameters;
    private String expression;
    protected List<?> participantElements;
    protected Collection<?> validParticipantMetaElements;
    protected IModelSearchQueryEvaluator<IModelSearchQuery, ?> evaluator;

    public AbstractModelSearchQuery(String expr, IModelSearchQueryParameters parameters) {
        this.expression = expr;
        this.modelSearchResult = new ModelSearchResult(this);
        this.modelSearchParameters = parameters;
        if (this.modelSearchParameters != null) {
            this.participantElements = this.getModelSearchParameters().getParticipantElements();
        }
    }

    @Override
    public abstract String getResultImagePath();

    @Override
    public abstract String getQueryImagePath();

    @Override
    public abstract String getBundleSymbolicName();

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    @Override
    public abstract IModelResultEntry buildSearchResultEntryHierarchy(Object var1, Object var2);

    @Override
    public Object processSearchResultMatching(Object resource, Object o, boolean notify) {
        IModelResultEntry e = this.buildSearchResultEntryHierarchy(resource, o);
        this.getModelSearchResult().insert(resource, e, notify);
        return o;
    }

    public abstract String getLabel();

    public ISearchResult getSearchResult() {
        return this.modelSearchResult;
    }

    protected abstract IModelSearchScope<?, ?> getModelSearchScope();

    protected abstract boolean getMatchesNotificationMode();

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        this.getModelSearchResult().clean();
        IModelSearchScope<?, ?> scope = this.getModelSearchScope();
        monitor.beginTask(this.getLabel(), scope.getParticipants().size());
        for (Object participant : scope.getParticipants()) {
            if (!this.search(participant, this.getMatchesNotificationMode(), monitor).equals(Status.OK_STATUS)) {
                monitor.setCanceled(true);
                return Status.CANCEL_STATUS;
            }
            monitor.worked(1);
        }
        monitor.done();
        return new Status(0, Messages.getString("AbstractModelExtensibleSearchQuery.modelSearchFinishedMessage"), 0, Messages.getString("AbstractModelExtensibleSearchQuery.noResultMessage"), null);
    }

    @Override
    public IStatus run() {
        this.getModelSearchResult().clean();
        IModelSearchScope<?, ?> scope = this.getModelSearchScope();
        for (Object participant : scope.getParticipants()) {
            if (this.search(participant, this.getMatchesNotificationMode()).equals(Status.OK_STATUS)) continue;
            return Status.CANCEL_STATUS;
        }
        return new Status(0, Messages.getString("AbstractModelExtensibleSearchQuery.modelSearchFinishedMessage"), 0, Messages.getString("AbstractModelExtensibleSearchQuery.noResultMessage"), null);
    }

    @Override
    public IStatus runWithoutNotifications() {
        this.getModelSearchResult().clean();
        IModelSearchScope<?, ?> scope = this.getModelSearchScope();
        for (Object participant : scope.getParticipants()) {
            if (this.search(participant).equals(Status.OK_STATUS)) continue;
            return Status.CANCEL_STATUS;
        }
        return new Status(0, "Success", 0, "", null);
    }

    @Override
    public abstract IStatus search(Object var1, boolean var2, IProgressMonitor var3);

    @Override
    public IModelSearchQueryParameters getModelSearchParameters() {
        return this.modelSearchParameters;
    }

    @Override
    public IModelSearchResult getModelSearchResult() {
        return this.modelSearchResult;
    }

    @Override
    public abstract IModelSearchQueryEvaluator<IModelSearchQuery, ?> getEvaluator();

    @Override
    public String getName() {
        return Messages.getString("AbstractModelExtensibleSearchQuery.modelNameMessage");
    }

    @Override
    public Collection<?> getValidParticipantMetaElements() {
        return this.validParticipantMetaElements;
    }

    @Override
    public String getQueryExpression() {
        return this.expression;
    }

    @Override
    public boolean isValidTargetMetaModel(String nsURI) {
        return this.getTargetMetaModelIDs().contains(nsURI);
    }
}

