/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ui.services;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.search.core.services.AbstractExtensionManager;
import org.eclipse.emf.search.ui.Activator;
import org.eclipse.emf.search.ui.l10n.Messages;
import org.eclipse.emf.search.ui.services.EngineMappingDescriptor;

public final class ModelSearchEngineMappingExtensionManager
extends AbstractExtensionManager {
    private static final String bundleId = Activator.getDefault().getBundle().getSymbolicName();
    public static final String ECORE_UI_MODEL_SEARCH_ENGINE_MAPPING_EXT_POINT_ID = String.valueOf(bundleId) + ".modelSearchEngineMapping";
    private static ModelSearchEngineMappingExtensionManager manager;
    private SortedSet<EngineMappingDescriptor> engineMappingContributions = new TreeSet<EngineMappingDescriptor>(new Comparator<EngineMappingDescriptor>(){

        @Override
        public int compare(EngineMappingDescriptor o1, EngineMappingDescriptor o2) {
            return o1.getID().compareTo(o2.getID());
        }
    });

    protected ModelSearchEngineMappingExtensionManager() {
        super(ECORE_UI_MODEL_SEARCH_ENGINE_MAPPING_EXT_POINT_ID);
        this.readRegistry();
    }

    public static ModelSearchEngineMappingExtensionManager getInstance() {
        return manager == null ? (manager = new ModelSearchEngineMappingExtensionManager()) : manager;
    }

    public EngineMappingDescriptor find(String id) {
        for (EngineMappingDescriptor desc : this.engineMappingContributions) {
            if (!id.equals(desc.getID())) continue;
            return desc;
        }
        return null;
    }

    public EngineMappingDescriptor[] getModelSearchEngineMappingDescriptors() {
        return this.engineMappingContributions.toArray(new EngineMappingDescriptor[this.engineMappingContributions.size()]);
    }

    protected void addExtension(IExtension extension) {
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement confElt = iConfigurationElementArray[n2];
            try {
                this.engineMappingContributions.add(new EngineMappingDescriptor(confElt));
            }
            catch (CoreException ce) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, bundleId, 0, Messages.getString("ModelSearchEngigneMappingTabExtensionManager.1"), (Throwable)ce));
            }
            ++n2;
        }
    }

    protected void removeExtension(IExtension extension) {
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement confElt = iConfigurationElementArray[n2];
            String id = confElt.getAttribute("id");
            EngineMappingDescriptor descriptor = this.find(id);
            this.engineMappingContributions.remove(descriptor);
            ++n2;
        }
    }
}

