/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.protocol;

import org.eclipse.emf.cdo.server.ClassInfo;
import org.eclipse.emf.cdo.server.Mapper;
import org.eclipse.emf.cdo.server.PackageInfo;
import org.eclipse.emf.cdo.server.ServerCDOProtocol;
import org.eclipse.net4j.core.impl.AbstractIndicationWithResponse;

public class AnnouncePackageIndication
extends AbstractIndicationWithResponse {
    private String packageName;

    public short getSignalId() {
        return 1;
    }

    public void indicate() {
        this.packageName = this.receiveString();
        if (this.isDebugEnabled()) {
            this.debug("Announced package " + this.packageName);
        }
    }

    public void respond() {
        Mapper mapper = ((ServerCDOProtocol)this.getProtocol()).getMapper();
        PackageInfo packageInfo = mapper.getPackageManager().getPackageInfo(this.packageName);
        if (packageInfo == null) {
            if (this.isDebugEnabled()) {
                this.debug("Unknown package " + this.packageName);
            }
            this.transmitInt(-1);
        } else {
            ClassInfo[] classInfos = packageInfo.getClasses();
            this.transmitInt(classInfos.length);
            int i = 0;
            while (i < classInfos.length) {
                ClassInfo classInfo = classInfos[i];
                if (this.isDebugEnabled()) {
                    this.debug("Responding class " + classInfo.getName() + " = " + classInfo.getCID());
                }
                this.transmitInt(classInfo.getCID());
                this.transmitString(classInfo.getName());
                ++i;
            }
        }
    }
}

