/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.examples.ui.internal.editors;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.cdo.client.CDOResource;
import org.eclipse.emf.cdo.client.OptimisticControlException;
import org.eclipse.emf.cdo.client.ResourceManager;
import org.eclipse.emf.cdo.examples.client.internal.ExampleClientPlugin;
import org.eclipse.emf.cdo.examples.ui.internal.ExampleUIActivator;
import org.eclipse.emf.cdo.examples.ui.internal.editors.CDOEditorInput;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.ViewerPane;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOEditor
extends MultiPageEditorPart
implements IEditingDomainProvider,
ISelectionProvider,
IMenuListener,
IViewerProvider,
IGotoMarker,
ResourceManager.InvalidationListener {
    public static final String EDITOR_ID = "org.eclipse.emf.cdo.examples.ui.Editor";
    public static final boolean AUTO_RELOAD = true;
    protected ResourceManager resourceManager;
    protected CDOLabelProvider labelProvider;
    private Color redColor;
    private Color blueColor;
    protected AdapterFactoryEditingDomain editingDomain;
    protected ComposedAdapterFactory adapterFactory;
    protected IContentOutlinePage contentOutlinePage;
    protected IStatusLineManager contentOutlineStatusLineManager;
    protected TreeViewer contentOutlineViewer;
    protected PropertySheetPage propertySheetPage;
    protected CDOTreeViewer selectionViewer;
    protected TreeViewer parentViewer;
    protected TreeViewer treeViewer;
    protected ListViewer listViewer;
    protected TableViewer tableViewer;
    protected TreeViewer treeViewerWithColumns;
    protected ViewerPane currentViewerPane;
    protected Viewer currentViewer;
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection selectionChangedListeners = new ArrayList();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            if (p instanceof ContentOutline) {
                if (((ContentOutline)p).getCurrentPage() == CDOEditor.this.contentOutlinePage) {
                    CDOEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)CDOEditor.this);
                    CDOEditor.this.setCurrentViewer((Viewer)CDOEditor.this.contentOutlineViewer);
                }
            } else if (p instanceof PropertySheet) {
                if (((PropertySheet)p).getCurrentPage() == CDOEditor.this.propertySheetPage) {
                    CDOEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)CDOEditor.this);
                    CDOEditor.this.handleActivate();
                }
            } else if (p == CDOEditor.this) {
                CDOEditor.this.handleActivate();
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    Collection removedResources = new ArrayList();
    Collection changedResources = new ArrayList();
    Collection savedResources = new ArrayList();
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                private class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected ResourceSet resourceSet;
                    protected Collection changedResources;
                    protected Collection removedResources;

                    ResourceDeltaVisitor() {
                        this.resourceSet = (this).CDOEditor.this.editingDomain.getResourceSet();
                        this.changedResources = new ArrayList();
                        this.removedResources = new ArrayList();
                    }

                    public boolean visit(IResourceDelta delta) {
                        Resource resource;
                        if (delta.getFlags() != 131072 && delta.getResource().getType() == 1 && (delta.getKind() & 6) != 0 && (resource = this.resourceSet.getResource(URI.createURI((String)delta.getFullPath().toString()), false)) != null) {
                            if ((delta.getKind() & 2) != 0) {
                                this.removedResources.add(resource);
                            } else {
                                this.changedResources.add(resource);
                            }
                        }
                        return true;
                    }

                    public Collection getChangedResources() {
                        return this.changedResources;
                    }

                    public Collection getRemovedResources() {
                        return this.removedResources;
                    }
                }
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                if (!visitor.getRemovedResources().isEmpty()) {
                    CDOEditor.this.removedResources.addAll(visitor.getRemovedResources());
                    if (!CDOEditor.this.isDirty()) {
                        CDOEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                CDOEditor.this.getSite().getPage().closeEditor((IEditorPart)CDOEditor.this, false);
                                CDOEditor.this.dispose();
                            }
                        });
                    }
                }
                if (!visitor.getChangedResources().isEmpty()) {
                    CDOEditor.this.changedResources.addAll(visitor.getChangedResources());
                }
            }
            catch (CoreException exception) {
                ExampleUIActivator.INSTANCE.log((Object)exception);
            }
        }
    };

    protected void handleActivate() {
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
            this.setSelection(this.getSelection());
        }
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
                this.dispose();
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    protected void handleChangedResources() {
        if (!(this.changedResources.isEmpty() || this.isDirty() && !this.handleDirtyConflict())) {
            this.editingDomain.getCommandStack().flush();
            for (Resource resource : this.changedResources) {
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException exception) {
                    ExampleUIActivator.INSTANCE.log(exception);
                }
            }
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)CDOEditor.getString("_UI_FileConflict_label"), (String)CDOEditor.getString("_WARN_FileConflict"));
    }

    public CDOEditor() {
        ComposedAdapterFactory.Descriptor.Registry regsitry = EMFEditPlugin.getComposedAdapterFactoryDescriptorRegistry();
        this.adapterFactory = new ComposedAdapterFactory(regsitry);
        this.labelProvider = new CDOLabelProvider((AdapterFactory)this.adapterFactory);
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                CDOEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        CDOEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            CDOEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                        if ((this).CDOEditor.this.propertySheetPage != null) {
                            (this).CDOEditor.this.propertySheetPage.refresh();
                        }
                    }
                });
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, null);
    }

    protected void firePropertyChange(int action) {
        super.firePropertyChange(action);
    }

    public void setSelectionToViewer(Collection collection) {
        final Collection theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (CDOEditor.this.currentViewer != null) {
                        CDOEditor.this.currentViewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            runnable.run();
        }
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setCurrentViewerPane(ViewerPane viewerPane) {
        if (this.currentViewerPane != viewerPane) {
            if (this.currentViewerPane != null) {
                this.currentViewerPane.showFocus(false);
            }
            this.currentViewerPane = viewerPane;
        }
        this.setCurrentViewer(this.currentViewerPane.getViewer());
    }

    public void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        CDOEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
        }
    }

    public Viewer getViewer() {
        return this.currentViewer;
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)viewer);
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)this.editingDomain, (Viewer)viewer));
    }

    public void createModel() {
        CDOEditorInput editorInput = (CDOEditorInput)this.getEditorInput();
        String uri = editorInput.getResourceURI();
        try {
            this.resourceManager = ExampleClientPlugin.createResourceManager((ResourceSet)this.editingDomain.getResourceSet());
            this.resourceManager.addInvalidationListener((ResourceManager.InvalidationListener)this);
            this.editingDomain.loadResource(uri);
        }
        catch (Exception exception) {
            ExampleUIActivator.INSTANCE.log(exception);
        }
    }

    public void createPages() {
        this.createModel();
        TreeViewerPane viewerPane = new TreeViewerPane(this.getSite().getPage(), (IWorkbenchPart)this);
        viewerPane.createControl(this.getContainer());
        this.selectionViewer = (CDOTreeViewer)viewerPane.getViewer();
        this.selectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        this.selectionViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.selectionViewer.setInput(this.getResource());
        viewerPane.setTitle(this.getResource());
        new AdapterFactoryTreeEditor(this.selectionViewer.getTree(), (AdapterFactory)this.adapterFactory);
        this.createContextMenuFor((StructuredViewer)this.selectionViewer);
        int pageIndex = this.addPage(viewerPane.getControl());
        this.setPageText(pageIndex, CDOEditor.getString("_UI_SelectionPage_label"));
        this.setActivePage(0);
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    CDOEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
    }

    public CDOResource getResource() {
        return (CDOResource)this.editingDomain.getResourceSet().getResources().get(0);
    }

    protected void hideTabs() {
        if (this.getPageCount() <= 1) {
            this.setPageText(0, "");
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y + 6);
            }
        }
    }

    protected void pageChange(int pageIndex) {
        super.pageChange(pageIndex);
        if (this.contentOutlinePage != null) {
            this.handleContentOutlineSelection(this.contentOutlinePage.getSelection());
        }
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContentOutlinePage.class)) {
            return this.getContentOutlinePage();
        }
        if (key.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        if (key.equals(IGotoMarker.class)) {
            return this;
        }
        return super.getAdapter(key);
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            private class MyContentOutlinePage
            extends ContentOutlinePage {
                MyContentOutlinePage() {
                }

                public void createControl(Composite parent) {
                    super.createControl(parent);
                    CDOEditor.this.contentOutlineViewer = this.getTreeViewer();
                    CDOEditor.this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    CDOEditor.this.contentOutlineViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)CDOEditor.this.adapterFactory));
                    CDOEditor.this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)CDOEditor.this.labelProvider);
                    CDOEditor.this.contentOutlineViewer.setInput((Object)CDOEditor.this.editingDomain.getResourceSet());
                    CDOEditor.this.createContextMenuFor((StructuredViewer)CDOEditor.this.contentOutlineViewer);
                    if (!CDOEditor.this.editingDomain.getResourceSet().getResources().isEmpty()) {
                        ArrayList<CDOResource> selection = new ArrayList<CDOResource>();
                        selection.add(CDOEditor.this.getResource());
                        CDOEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(selection), true);
                    }
                }

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                    CDOEditor.this.contentOutlineStatusLineManager = statusLineManager;
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    CDOEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            }
            this.contentOutlinePage = new MyContentOutlinePage();
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    CDOEditor.this.handleContentOutlineSelection(event.getSelection());
                }
            });
        }
        return this.contentOutlinePage;
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new ExtendedPropertySheetPage(this.editingDomain){

                public void setSelectionToViewer(List selection) {
                    CDOEditor.this.setSelectionToViewer(selection);
                    CDOEditor.this.setFocus();
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    CDOEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            };
            this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        }
        return this.propertySheetPage;
    }

    public void handleContentOutlineSelection(ISelection selection) {
        Iterator selectedElements;
        if (this.currentViewerPane != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (selectedElements = ((IStructuredSelection)selection).iterator()).hasNext()) {
            Object selectedElement = selectedElements.next();
            if (this.currentViewerPane.getViewer() == this.selectionViewer) {
                ArrayList selectionList = new ArrayList();
                selectionList.add(selectedElement);
                while (selectedElements.hasNext()) {
                    selectionList.add(selectedElements.next());
                }
                this.selectionViewer.setSelection((ISelection)new StructuredSelection(selectionList));
            } else if (this.currentViewerPane.getViewer().getInput() != selectedElement) {
                this.currentViewerPane.getViewer().setInput(selectedElement);
                this.currentViewerPane.setTitle(selectedElement);
            }
        }
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                try {
                    boolean first = true;
                    for (Resource resource : CDOEditor.this.editingDomain.getResourceSet().getResources()) {
                        if (!(!first && resource.getContents().isEmpty() || CDOEditor.this.editingDomain.isReadOnly(resource))) {
                            CDOEditor.this.savedResources.add(resource);
                            if (!(resource instanceof CDOResource)) {
                                resource.save(Collections.EMPTY_MAP);
                            }
                        }
                        first = false;
                    }
                    CDOEditor.this.resourceManager.commit();
                }
                catch (OptimisticControlException ex) {
                    throw ex;
                }
                catch (Exception exception) {
                    ExampleUIActivator.INSTANCE.log(exception);
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (InvocationTargetException ex) {
            Throwable targetException = ex.getTargetException();
            if (targetException instanceof OptimisticControlException) {
                ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
                this.firePropertyChange(257);
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Optimistic Control Exception", (String)targetException.getLocalizedMessage());
            } else {
                ExampleUIActivator.INSTANCE.log(ex);
            }
        }
        catch (Exception ex) {
            ExampleUIActivator.INSTANCE.log(ex);
        }
        this.labelProvider.fireLabelProviderChanged();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            this.doSaveAs(URI.createPlatformResourceURI((String)file.getFullPath().toString()), (IEditorInput)new FileEditorInput(file));
        }
    }

    protected void doSaveAs(URI uri, IEditorInput editorInput) {
        this.getResource().setURI(uri);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        NullProgressMonitor progressMonitor = this.getActionBars().getStatusLineManager() != null ? this.getActionBars().getStatusLineManager().getProgressMonitor() : new NullProgressMonitor();
        this.doSave((IProgressMonitor)progressMonitor);
    }

    public void gotoMarker(IMarker marker) {
        try {
            String uriAttribute;
            if (marker.getType().equals("org.eclipse.emf.ecore.diagnostic") && (uriAttribute = marker.getAttribute("uri", null)) != null) {
                URI uri = URI.createURI((String)uriAttribute);
                EObject eObject = this.editingDomain.getResourceSet().getEObject(uri, true);
                if (eObject != null) {
                    this.setSelectionToViewer(Collections.singleton(this.editingDomain.getWrapper((Object)eObject)));
                }
            }
        }
        catch (CoreException exception) {
            ExampleUIActivator.INSTANCE.log((Object)exception);
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener(this.partListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    public void setFocus() {
        if (this.currentViewerPane != null) {
            this.currentViewerPane.setFocus();
        } else {
            this.getControl(this.getActivePage()).setFocus();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
        this.setStatusLineManager(selection);
    }

    public void setStatusLineManager(ISelection selection) {
        IStatusLineManager statusLineManager;
        IStatusLineManager iStatusLineManager = statusLineManager = this.currentViewer != null && this.currentViewer == this.contentOutlineViewer ? this.contentOutlineStatusLineManager : this.getActionBars().getStatusLineManager();
        if (statusLineManager != null) {
            if (selection instanceof IStructuredSelection) {
                List collection = ((IStructuredSelection)selection).toList();
                switch (collection.size()) {
                    case 0: {
                        statusLineManager.setMessage(CDOEditor.getString("_UI_NoObjectSelected"));
                        break;
                    }
                    case 1: {
                        String text = new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory).getText(collection.iterator().next());
                        statusLineManager.setMessage(CDOEditor.getString("_UI_SingleObjectSelected", text));
                        break;
                    }
                    default: {
                        statusLineManager.setMessage(CDOEditor.getString("_UI_MultiObjectSelected", Integer.toString(collection.size())));
                        break;
                    }
                }
            } else {
                statusLineManager.setMessage("");
            }
        }
    }

    private static String getString(String key) {
        return ExampleUIActivator.INSTANCE.getString(key);
    }

    private static String getString(String key, Object s1) {
        return ExampleUIActivator.INSTANCE.getString(key, new Object[]{s1});
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void dispose() {
        if (this.resourceManager != null) {
            this.resourceManager.removeInvalidationListener((ResourceManager.InvalidationListener)this);
            try {
                this.resourceManager.stop();
            }
            catch (Exception ex) {
                ExampleUIActivator.INSTANCE.log(ex);
            }
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.getSite().getPage().removePartListener(this.partListener);
        this.adapterFactory.dispose();
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        super.dispose();
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    protected Color getRedColor() {
        if (this.redColor == null) {
            this.redColor = Display.getDefault().getSystemColor(3);
        }
        return this.redColor;
    }

    protected Color getBlueColor() {
        if (this.blueColor == null) {
            this.blueColor = Display.getDefault().getSystemColor(9);
        }
        return this.blueColor;
    }

    public void notifyInvalidation(ResourceManager resourceManager, final List<EObject> invalidated, final List<EObject> deferred) {
        Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            public void run() {
                Control control;
                IPropertySheetPage page;
                if (CDOEditor.this.selectionViewer != null && !CDOEditor.this.selectionViewer.getControl().isDisposed()) {
                    boolean autoReload = ExampleUIActivator.getPlugin().isAutoReload();
                    Color color = ExampleUIActivator.getPlugin().getInvalidationColor();
                    for (EObject object : invalidated) {
                        try {
                            if (autoReload) {
                                CDOEditor.this.selectionViewer.refresh(object);
                                continue;
                            }
                            Widget widget = CDOEditor.this.selectionViewer.getWidget(object);
                            if (!(widget instanceof TreeItem)) continue;
                            ((TreeItem)widget).setForeground(color);
                        }
                        catch (Exception ex) {
                            ExampleUIActivator.INSTANCE.log(ex);
                        }
                    }
                }
                if ((page = CDOEditor.this.getPropertySheetPage()) instanceof PropertySheetPage && (control = page.getControl()) != null && !control.isDisposed()) {
                    try {
                        ((PropertySheetPage)page).refresh();
                    }
                    catch (Exception ex) {
                        ExampleUIActivator.INSTANCE.log(ex);
                    }
                }
                if (ExampleUIActivator.getPlugin().isShowConflicts()) {
                    if (CDOEditor.this.currentViewerPane instanceof TreeViewerPane && CDOEditor.this.getResourceManager().isRollbackOnly()) {
                        try {
                            CLabel titleLabel = ((TreeViewerPane)CDOEditor.this.currentViewerPane).getTitleLabel();
                            titleLabel.setForeground(CDOEditor.this.getRedColor());
                        }
                        catch (Exception ex) {
                            ExampleUIActivator.INSTANCE.log(ex);
                        }
                    }
                    for (EObject object : deferred) {
                        Widget widget = CDOEditor.this.selectionViewer.getWidget(object);
                        if (!(widget instanceof TreeItem)) continue;
                        try {
                            ((TreeItem)widget).setForeground(CDOEditor.this.getRedColor());
                        }
                        catch (Exception ex) {
                            ExampleUIActivator.INSTANCE.log(ex);
                        }
                    }
                }
            }
        });
    }

    public final class CDOLabelProvider
    extends AdapterFactoryLabelProvider
    implements IFontProvider,
    IColorProvider {
        private Font boldFont;

        private CDOLabelProvider(AdapterFactory factory) {
            super(factory);
        }

        public void dispose() {
            if (this.boldFont != null) {
                this.boldFont.dispose();
                this.boldFont = null;
            }
            super.dispose();
        }

        private Font getBoldFont() {
            if (this.boldFont == null) {
                Display display = CDOEditor.this.getSite().getShell().getDisplay();
                FontData[] datas = (FontData[])CDOEditor.this.currentViewer.getControl().getFont().getFontData().clone();
                datas[0].setStyle(1);
                this.boldFont = new Font((Device)display, datas);
            }
            return this.boldFont;
        }

        public void fireLabelProviderChanged(Object[] objects) {
            for (ILabelProviderListener labelProviderListener : this.labelProviderListeners) {
                labelProviderListener.labelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, objects));
            }
        }

        public Font getFont(Object element) {
            if (ExampleUIActivator.getPlugin().isShowChanges() && CDOEditor.this.getResourceManager().getTransaction().isChanged(element)) {
                return this.getBoldFont();
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (ExampleUIActivator.getPlugin().isShowConflicts() && element instanceof EObject && CDOEditor.this.getResourceManager().hasDeferredInvalidation((EObject)element)) {
                return CDOEditor.this.getRedColor();
            }
            return null;
        }
    }

    public class TreeViewerPane
    extends ViewerPane {
        public TreeViewerPane(IWorkbenchPage page, IWorkbenchPart part) {
            super(page, part);
        }

        public Viewer createViewer(Composite composite) {
            Tree tree = new Tree(composite, 2);
            CDOTreeViewer newTreeViewer = new CDOTreeViewer(tree);
            return newTreeViewer;
        }

        public void requestActivation() {
            super.requestActivation();
            CDOEditor.this.setCurrentViewerPane(this);
        }

        public CLabel getTitleLabel() {
            return this.titleLabel;
        }
    }

    public class CDOTreeViewer
    extends TreeViewer {
        public CDOTreeViewer(Tree tree) {
            super(tree);
        }

        public Widget getWidget(Object element) {
            return this.findItem(element);
        }
    }
}

