/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.client.protocol;

import org.eclipse.emf.cdo.client.AttributeConverter;
import org.eclipse.emf.cdo.client.AttributeInfo;
import org.eclipse.emf.cdo.client.CDOResource;
import org.eclipse.emf.cdo.client.ClassInfo;
import org.eclipse.emf.cdo.client.ResourceManager;
import org.eclipse.emf.cdo.client.protocol.AbstractCDOClientRequest;
import org.eclipse.emf.cdo.core.OIDEncoder;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.net4j.util.ImplementationError;

public abstract class AbstractDataRequest
extends AbstractCDOClientRequest {
    protected EObject receiveObject(long oid, int oca, int cid) {
        ClassInfo classInfo = this.getPackageManager().getClassInfo(cid);
        if (classInfo == null) {
            throw new ImplementationError("Unknown cid " + cid);
        }
        if (this.isDebugEnabled()) {
            this.debug("Receiving object " + classInfo.getName() + " " + this.getPackageManager().getOidEncoder().toString(oid) + "v" + oca);
        }
        this.receiveContainers();
        EClass eClass = classInfo.getEClass();
        EObject eObject = this.provideObject(eClass, oid, oca);
        this.receiveAttributes(eObject, classInfo);
        this.receiveReferences(eObject);
        return eObject;
    }

    protected void receiveContainers() {
        int count = this.receiveInt();
        int i = 0;
        while (i < count) {
            long oid = this.receiveLong();
            int cid = this.receiveInt();
            if (this.isDebugEnabled()) {
                this.debug("Receiving container oid=" + this.getPackageManager().getOidEncoder().toString(oid) + ", cid=" + cid);
            }
            this.provideObject(oid, cid);
            ++i;
        }
    }

    protected abstract EObject provideObject(EClass var1, long var2, int var4);

    protected EObject createProxyObject(EClass eClass, long oid) {
        OIDEncoder oidEncoder = this.getPackageManager().getOidEncoder();
        if (this.isDebugEnabled()) {
            this.debug("Creating proxy " + eClass.getName() + " " + oidEncoder.toString(oid));
        }
        int rid = oidEncoder.getRID(oid);
        ResourceManager resourceManager = this.getResourceManager();
        CDOResource cdoResource = resourceManager.getResource(rid);
        URI uri = resourceManager.createProxyURI(oid);
        EObject object = resourceManager.createEObject(eClass, oid, -1, cdoResource);
        ((InternalEObject)object).eSetProxyURI(uri);
        resourceManager.registerObject(oid, object);
        return object;
    }

    protected EObject getProxyObject(long oid) {
        if (this.isDebugEnabled()) {
            OIDEncoder oidEncoder = this.getPackageManager().getOidEncoder();
            this.debug("Searching proxy " + oidEncoder.toString(oid));
        }
        EObject object = this.getResourceManager().getProxyObject(oid);
        return object;
    }

    protected void receiveAttributes(EObject object, ClassInfo classInfo) {
        AttributeConverter converter = this.getPackageManager().getAttributeConverter();
        while (classInfo != null) {
            AttributeInfo[] attributeInfos = classInfo.getAttributeInfos();
            int i = 0;
            while (i < attributeInfos.length) {
                AttributeInfo attributeInfo = attributeInfos[i];
                if (this.isDebugEnabled()) {
                    this.debug("Receiving attribute " + attributeInfo.getName());
                }
                converter.fromChannel(object, attributeInfo.getEAttribute(), this.channel);
                ++i;
            }
            classInfo = classInfo.getParent();
        }
    }

    protected void receiveReferences(EObject object) {
        int featureId;
        while ((featureId = this.receiveInt()) != -1) {
            EReference reference = (EReference)object.eClass().getEStructuralFeature(featureId);
            if (reference == null) {
                throw new ImplementationError("Feature id " + featureId + " is not known. Maybe signalling is out of sequence.");
            }
            long targetId = this.receiveLong();
            int cid = this.receiveInt();
            if (this.isDebugEnabled()) {
                this.debug("Receiving reference \"" + reference.getName() + "\": " + this.getPackageManager().getOidEncoder().toString(targetId) + ", cid=" + cid + ", feature=" + featureId);
            }
            EObject targetObject = this.provideObject(targetId, cid);
            if (reference.isMany()) {
                EList list = (EList)object.eGet((EStructuralFeature)reference);
                list.add((Object)targetObject);
                continue;
            }
            object.eSet((EStructuralFeature)reference, (Object)targetObject);
        }
    }

    protected EObject provideObject(long oid, int cid) {
        EObject object = this.getResourceManager().getObject(oid);
        if (object == null && (object = this.getProxyObject(oid)) == null) {
            ClassInfo classInfo = this.getPackageManager().getClassInfo(cid);
            if (classInfo == null) {
                throw new ImplementationError("Unknown cid " + cid);
            }
            object = this.createProxyObject(classInfo.getEClass(), oid);
        }
        return object;
    }
}

