/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.socket.impl;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.net4j.core.SelectionListener;
import org.eclipse.net4j.socket.SelectorManager;
import org.eclipse.net4j.spring.impl.ServiceImpl;
import org.eclipse.net4j.util.Pair;
import org.eclipse.net4j.util.UnderlyingIOException;
import org.eclipse.net4j.util.thread.Worker;

public class SelectorManagerImpl
extends ServiceImpl
implements SelectorManager {
    protected transient Controller controller;
    protected transient Selector selector;
    protected transient Queue<Pair<SelectableChannel, SelectionListener>> toBeRegistered = new ConcurrentLinkedQueue<Pair<SelectableChannel, SelectionListener>>();

    public void deregister(SelectableChannel selectable) {
    }

    public void register(SelectableChannel selectable, SelectionListener listener) {
        if (this.isDebugEnabled()) {
            this.debug("Ordering registration of " + selectable + " with " + this.selector);
        }
        this.toBeRegistered.add((Pair<SelectableChannel, SelectionListener>)new Pair((Object)selectable, (Object)listener));
    }

    protected void activate() throws Exception {
        super.activate();
        this.selector = Selector.open();
        this.controller = new Controller();
    }

    protected void deactivate() throws Exception {
        if (this.controller != null) {
            this.controller.shutdown(200L);
            this.controller = null;
        }
        if (this.selector != null) {
            this.selector.close();
            this.selector = null;
        }
        this.toBeRegistered = null;
        super.deactivate();
    }

    protected final class Controller
    extends Worker {
        public Controller() {
            this.setName(String.valueOf(SelectorManagerImpl.this.getFullBeanName()) + ".Controller");
            this.startup();
        }

        public long doWorkStep(int progress) {
            block9: {
                this.handleNewSelectables();
                int count = SelectorManagerImpl.this.selector.select(500L);
                if (count != 0) break block9;
                return 0L;
            }
            try {
                Set<SelectionKey> readyKeys = SelectorManagerImpl.this.selector.selectedKeys();
                Iterator<SelectionKey> it = readyKeys.iterator();
                while (it.hasNext()) {
                    SelectionKey key = it.next();
                    it.remove();
                    try {
                        SelectionListener listener;
                        if (!key.isValid()) continue;
                        key.interestOps(0);
                        if (!key.isReadable() || (listener = (SelectionListener)key.attachment()) == null) continue;
                        listener.readyForRead(key.channel());
                    }
                    finally {
                        if (key.isValid()) {
                            key.interestOps(1);
                        }
                    }
                }
            }
            catch (ClosedChannelException closedChannelException) {
            }
            catch (IOException ex) {
                throw new UnderlyingIOException((Throwable)ex);
            }
            return 0L;
        }

        protected void handleNewSelectables() throws ClosedChannelException {
            Pair<SelectableChannel, SelectionListener> pair;
            while ((pair = SelectorManagerImpl.this.toBeRegistered.poll()) != null) {
                SelectableChannel selectable = (SelectableChannel)pair.getFirst();
                SelectionListener listener = (SelectionListener)pair.getSecond();
                if (SelectorManagerImpl.this.isDebugEnabled()) {
                    SelectorManagerImpl.this.debug("Registering " + selectable + " with " + SelectorManagerImpl.this.selector);
                }
                SelectionKey key = selectable.register(SelectorManagerImpl.this.selector, 1, listener);
                listener.notifyRegistration(selectable, key);
            }
        }
    }
}

