/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.examples.prov.server.util;

import java.util.Stack;
import org.eclipse.net4j.examples.prov.server.ProvServerPlugin;
import org.eclipse.net4j.util.StringHelper;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class SaxHandler
extends DefaultHandler
implements LexicalHandler {
    protected Locator locator;
    private ContextStack contextStack = new ContextStack();

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        AttributesImpl impl = new AttributesImpl(attributes);
        String[] context = this.contextStack.getContext();
        this.contextStack.push(qName, impl);
        try {
            this.handleStart(context, qName, impl);
        }
        catch (Exception ex) {
            ProvServerPlugin.getDefault().error(ex);
            throw new SAXException("Error while handling startElement", ex);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            AttributesImpl impl = this.contextStack.getAttributes();
            this.contextStack.pop();
            String[] context = this.contextStack.getContext();
            this.handleEnd(context, qName, impl);
        }
        catch (Exception ex) {
            ProvServerPlugin.getDefault().error(ex);
            throw new SAXException("Error while handling endElement", ex);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.handleCharacters(String.valueOf(ch, start, length));
        }
        catch (Exception ex) {
            ProvServerPlugin.getDefault().error(ex);
            throw new SAXException("Error while handling characters", ex);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        try {
            this.handleCharacters(String.valueOf(ch, start, length));
        }
        catch (Exception ex) {
            ProvServerPlugin.getDefault().error(ex);
            throw new SAXException("Error while handling ignorableWhitespace", ex);
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        try {
            this.handleCharacters("<!--" + String.valueOf(ch, start, length) + "-->");
        }
        catch (Exception ex) {
            ProvServerPlugin.getDefault().error(ex);
            throw new SAXException("Error while handling comment", ex);
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        System.out.println("Ignoring startDTD");
    }

    public void endDTD() throws SAXException {
        System.out.println("Ignoring startDTD");
    }

    public void startEntity(String name) throws SAXException {
        System.out.println("Ignoring startDTD");
    }

    public void endEntity(String name) throws SAXException {
        System.out.println("Ignoring startDTD");
    }

    public void startCDATA() throws SAXException {
        System.out.println("Ignoring startDTD");
    }

    public void endCDATA() throws SAXException {
        System.out.println("Ignoring startDTD");
    }

    protected void handleStart(String[] context, String name, AttributesImpl attributes) throws Exception {
    }

    protected void handleEnd(String[] context, String name, AttributesImpl attributes) throws Exception {
    }

    protected void handleCharacters(String chars) throws Exception {
    }

    protected String getAttribute(AttributesImpl attributes, String name) {
        return attributes.getValue(name);
    }

    protected void setAttribute(AttributesImpl attributes, String name, String value) {
        int index = attributes.getIndex(name);
        try {
            attributes.setValue(index, value);
        }
        catch (Exception exception) {}
    }

    protected boolean matchContext(String[] context, String elementName, String compare) {
        if (compare.startsWith("/")) {
            String[] array = compare.substring(1).split("/");
            if (array.length != context.length + 1) {
                return false;
            }
            int i = 0;
            while (i < array.length) {
                String contextElement;
                String compareElement = array[i];
                String string = contextElement = i < context.length ? context[i] : elementName;
                if (!StringHelper.equals((Object)compareElement, (Object)contextElement)) {
                    return false;
                }
                ++i;
            }
        } else {
            String[] array = (String.valueOf(compare) + "/" + elementName).split("/");
            if (array.length > context.length + 1) {
                return false;
            }
            int i = array.length;
            while (i > 0) {
                String contextElement;
                String compareElement = array[i];
                String string = contextElement = i < context.length ? context[i] : elementName;
                if (!StringHelper.equals((Object)compareElement, (Object)contextElement)) {
                    return false;
                }
                --i;
            }
        }
        return true;
    }

    private static class ContextStack {
        private Stack<String> elementStack = new Stack();
        private Stack<AttributesImpl> attributesStack = new Stack();

        private ContextStack() {
        }

        public void push(String element, AttributesImpl attributes) {
            this.elementStack.push(element);
            this.attributesStack.push(attributes);
        }

        public void pop() {
            this.attributesStack.pop();
            this.elementStack.pop();
        }

        public String getElement() {
            return this.elementStack.peek();
        }

        public AttributesImpl getAttributes() {
            return this.attributesStack.peek();
        }

        public String[] getContext() {
            return this.elementStack.toArray(new String[this.elementStack.size()]);
        }
    }
}

