/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.core.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.eclipse.net4j.core.Pool;
import org.eclipse.net4j.spring.impl.ServiceImpl;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.StringHelper;
import org.eclipse.net4j.util.thread.Worker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPool
extends ServiceImpl
implements Pool {
    public static final int DEFAULT_MAXIMUM_CAPACITY = 100;
    public static final int DEFAULT_MINIMUM_CAPACITY = 10;
    public static final boolean DEFAULT_VALIDATING = false;
    public static final long DEFAULT_WORKER_INTERVAL = 1000L;
    protected Map checkouts = new HashMap(211);
    protected Map keyToQueueMap = new HashMap(211);
    protected int level;
    protected int maximumCapacity = 100;
    protected int minimumCapacity = 10;
    protected Random randomGenerator = new Random(System.currentTimeMillis());
    protected List sortedWeightsArray = new ArrayList(10);
    protected boolean validating = false;
    protected Cleaner worker;
    protected long workerInterval = 1000L;

    protected abstract Class<?> doGetPooledClass(Object var1);

    @Override
    public Object get() {
        Object key = this.getDefaultKey();
        return this.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object get(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is not non-null");
        }
        AbstractPool abstractPool = this;
        synchronized (abstractPool) {
            Object object;
            Queue queue = this.getQueue(key);
            queue.incWeight();
            if (queue.isEmpty()) {
                try {
                    object = this.newPooled(key);
                }
                catch (Exception ex) {
                    this.error("Error while creating pool element for key " + key, ex);
                    return null;
                }
                queue.enqueue(object);
                ++this.level;
                if (this.isDebugEnabled()) {
                    this.debug("created new object " + AbstractPool.getPooledLabel(object) + " (queues = " + this.getPoolState() + ")");
                }
            }
            object = queue.dequeue();
            --this.level;
            if (this.validating) {
                this.checkouts.put(object, object);
            }
            if (this.isDebugEnabled()) {
                this.debug("checked out " + AbstractPool.getPooledLabel(object) + " (queues = " + this.getPoolState() + ")");
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLevel() {
        AbstractPool abstractPool = this;
        synchronized (abstractPool) {
            return this.level;
        }
    }

    @Override
    public Class<?> getPooledClass() {
        Object key = this.getDefaultKey();
        return this.getPooledClass(key);
    }

    @Override
    public Class<?> getPooledClass(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is not non-null");
        }
        return this.doGetPooledClass(key);
    }

    @Override
    public void put(Object object) {
        Object key = this.getDefaultKey();
        this.put(key, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Object key, Object object) {
        Class<?> base;
        if (key == null) {
            throw new IllegalArgumentException("key is not non-null");
        }
        if (object == null) {
            throw new IllegalArgumentException("object is not non-null");
        }
        if (this.isDebugEnabled()) {
            this.debug("checking in " + AbstractPool.getPooledLabel(object) + " (queues = " + this.getPoolState() + ")");
        }
        Object objectToUse = object;
        if (this.validating && !(base = this.getPooledClass(key)).isInstance(objectToUse)) {
            String msg = "object " + AbstractPool.getPooledLabel(objectToUse) + " does not inherit class " + this.doGetPooledClass(key);
            this.fatal(msg);
            throw new ImplementationError(msg);
        }
        AbstractPool abstractPool = this;
        synchronized (abstractPool) {
            Queue queue;
            if (this.validating) {
                Object checkout = this.checkouts.remove(objectToUse);
                if (checkout == null) {
                    String msg = "object " + AbstractPool.getPooledLabel(objectToUse) + " is not checked out";
                    this.fatal(msg);
                    throw new ImplementationError(msg);
                }
                objectToUse = checkout;
            }
            if ((queue = (Queue)this.keyToQueueMap.get(key)) == null) {
                if (this.isDebugEnabled()) {
                    this.debug("Creating queue " + key);
                }
                queue = new Queue(key);
                this.keyToQueueMap.put(key, queue);
            }
            queue.enqueue(objectToUse);
            ++this.level;
        }
    }

    public int getMaximumCapacity() {
        return this.maximumCapacity;
    }

    public int getMinimumCapacity() {
        return this.minimumCapacity;
    }

    public long getWorkerInterval() {
        return this.workerInterval;
    }

    protected void activate() throws Exception {
        super.activate();
        this.worker = new Cleaner();
        this.worker.setDaemon(true);
        this.worker.startup();
    }

    protected void deactivate() throws Exception {
        this.worker.shutdown(200L);
        this.worker = null;
        this.checkouts = null;
        this.keyToQueueMap = null;
        this.randomGenerator = null;
        this.sortedWeightsArray = null;
        super.deactivate();
    }

    public static String getPooledLabel(Object pooled) {
        return String.valueOf(pooled.getClass().getName()) + "(id=" + pooled.hashCode() + "): " + StringHelper.removePrefix((String)pooled.toString(), (String)"java.nio.DirectByteBuffer");
    }

    public String getPoolState() {
        boolean first = true;
        StringBuffer buffer = new StringBuffer();
        for (Queue queue : this.keyToQueueMap.values()) {
            buffer.append(String.valueOf(first ? "" : ", ") + queue.getKey() + ":" + queue.size());
            first = false;
        }
        return buffer.toString();
    }

    protected void doAging() {
        if (this.sortedWeightsArray.size() > 0) {
            int index = this.randomGenerator.nextInt(this.sortedWeightsArray.size());
            Queue queue = (Queue)this.sortedWeightsArray.get(index);
            queue.decWeight();
        }
    }

    protected void enforcePolicy(int amount) {
        Queue queue = null;
        switch (this.sortedWeightsArray.size()) {
            case 0: {
                return;
            }
            case 1: {
                queue = (Queue)this.sortedWeightsArray.get(0);
                break;
            }
            default: {
                Collections.sort(this.sortedWeightsArray);
            }
        }
        if (amount > 0) {
            if (queue == null) {
                queue = (Queue)this.sortedWeightsArray.get(this.sortedWeightsArray.size() - 1);
            }
            this.grow(queue, 1);
        } else {
            if (queue == null) {
                queue = (Queue)this.sortedWeightsArray.get(0);
            }
            this.shrink(queue, 1);
        }
    }

    protected Queue getQueue(Object key) {
        Queue queue = (Queue)this.keyToQueueMap.get(key);
        if (queue == null) {
            queue = new Queue(key);
            this.keyToQueueMap.put(key, queue);
            this.sortedWeightsArray.add(queue);
        }
        return queue;
    }

    protected void grow(Queue queue, int amount) {
        int i = 0;
        while (i < amount && this.level < this.maximumCapacity) {
            Object key = queue.getKey();
            try {
                Object pooled = this.newPooled(key);
                if (this.isDebugEnabled()) {
                    this.debug("created new object " + AbstractPool.getPooledLabel(pooled) + " (queues = " + this.getPoolState() + ")");
                }
                queue.enqueue(pooled);
                ++this.level;
            }
            catch (Exception ex) {
                this.error("Error while creating pool element for key " + key, ex);
                return;
            }
            ++i;
        }
    }

    protected abstract Object newPooled(Object var1) throws Exception;

    protected void shrink(Queue queue, int amount) {
        int i = 0;
        while (i < amount && this.level > this.minimumCapacity) {
            queue.dequeue();
            --this.level;
            ++i;
        }
    }

    @Override
    public Object getDefaultKey() {
        return this;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.doSet("validating", validating);
    }

    public void setMaximumCapacity(int maximumCapacity) {
        this.doSet("maximumCapacity", maximumCapacity);
    }

    public void setMinimumCapacity(int minimumCapacity) {
        this.doSet("minimumCapacity", minimumCapacity);
    }

    public void setWorkerInterval(long workerInterval) {
        this.doSet("workerInterval", workerInterval);
    }

    protected class Cleaner
    extends Worker {
        public Cleaner() {
            super(String.valueOf(AbstractPool.this.getFullBeanName()) + ".Cleaner");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long doWorkStep(int progress) {
            AbstractPool abstractPool = AbstractPool.this;
            synchronized (abstractPool) {
                int level = AbstractPool.this.getLevel();
                if (level < AbstractPool.this.minimumCapacity) {
                    AbstractPool.this.enforcePolicy(AbstractPool.this.minimumCapacity - level);
                } else if (level > AbstractPool.this.maximumCapacity) {
                    AbstractPool.this.enforcePolicy(AbstractPool.this.maximumCapacity - level);
                }
                AbstractPool.this.doAging();
            }
            return AbstractPool.this.workerInterval;
        }
    }

    protected class Queue
    implements Comparable {
        protected Object key;
        protected int weight;
        protected LinkedList list = new LinkedList();

        public Queue(Object key) {
            this.key = key;
        }

        public Iterator iterator() {
            return this.list.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enqueue(Object object) {
            LinkedList linkedList = this.list;
            synchronized (linkedList) {
                this.list.addFirst(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object dequeue() {
            LinkedList linkedList = this.list;
            synchronized (linkedList) {
                Object object = this.list.removeFirst();
                return object;
            }
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public int getWeight() {
            return this.weight;
        }

        public void incWeight() {
            ++this.weight;
        }

        public void decWeight() {
            if (this.weight > 0) {
                --this.weight;
            }
        }

        public Object getKey() {
            return this.key;
        }

        public int compareTo(Object o) {
            if (o == null || !(o instanceof Queue)) {
                String msg = "Wrong object: " + o;
                AbstractPool.this.fatal(msg);
                throw new ImplementationError(msg);
            }
            int w = ((Queue)o).getWeight();
            if (this.weight < w) {
                return -1;
            }
            if (this.weight > w) {
                return 1;
            }
            return 0;
        }

        public int size() {
            return this.list.size();
        }
    }
}

