/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ui.services;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.search.ui.areas.AbstractModelSearchCompositeArea;
import org.eclipse.emf.search.ui.areas.IModelSearchArea;
import org.eclipse.emf.search.ui.areas.IModelSearchAreaFactory;
import org.eclipse.emf.search.ui.handlers.IModelElementEditorSelectionHandler;
import org.eclipse.emf.search.ui.l10n.Messages;
import org.eclipse.emf.search.ui.pages.AbstractModelSearchPage;
import org.eclipse.emf.search.utils.ModelSearchImagesUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.osgi.framework.Bundle;

public class ParticipantTabDescriptor {
    public static final String PARTICIPANT_AREA_ID = "id";
    public static final String PARTICIPANT_AREA_LABEL_ID = "label";
    public static final String PARTICIPANT_AREA_TOOLTIP_ID = "tooltip";
    public static final String PARTICIPANT_IMAGE_ID = "image";
    public static final String PARTICIPANT_COMPOSITE_AREA_CLASS = "participantModelSearchArea";
    public static final String PARTICIPANT_ELEMENT_EDITOR_SELECTION_HANDLER_CLASS = "elementModelEditorSelectionHandler";
    public static final String PARTICIPANT_ELEMENT_COMPOSEABLE_FACTORY_ADAPTER_CLASS = "elementComposeableAdapterFactory";
    public static final String PARTICIPANT_COMPOSITE_AREA_FACTORY_CLASS = "participantCompositeAreaFactory";
    public static final String PARTICIPANT_TARGET_SEARCH_PAGE_ID = "targetSearchPageID";
    public static final String PARTICIPANT_TARGET_NS_URI = "targetNsURI";
    public String ID;
    public String label;
    public String tooltip;
    public String targetSearchPageID;
    public IModelSearchArea participantModelSearchArea;
    public IModelSearchAreaFactory participantCompositeAreaFactory;
    public IModelElementEditorSelectionHandler modelElementEditorSelectionHandler;
    public AdapterFactory elementComposeableAdapterFactory;
    public Image image;
    public String targetNsURI;
    private IConfigurationElement configElement;

    public ParticipantTabDescriptor(IConfigurationElement element) throws CoreException {
        this.configElement = element;
        this.load();
    }

    private void load() throws CoreException {
        Bundle bundle = Platform.getBundle((String)this.configElement.getNamespaceIdentifier());
        this.ID = this.configElement.getAttribute(PARTICIPANT_AREA_ID);
        this.label = this.configElement.getAttribute(PARTICIPANT_AREA_LABEL_ID);
        this.tooltip = this.configElement.getAttribute(PARTICIPANT_AREA_TOOLTIP_ID);
        this.targetSearchPageID = this.configElement.getAttribute(PARTICIPANT_TARGET_SEARCH_PAGE_ID);
        this.targetNsURI = this.configElement.getAttribute(PARTICIPANT_TARGET_NS_URI);
        this.image = ModelSearchImagesUtil.getImageDescriptor((Bundle)bundle, (String)this.configElement.getAttribute(PARTICIPANT_IMAGE_ID)).createImage();
        this.participantCompositeAreaFactory = (IModelSearchAreaFactory)this.configElement.createExecutableExtension(PARTICIPANT_COMPOSITE_AREA_FACTORY_CLASS);
        this.elementComposeableAdapterFactory = (AdapterFactory)this.configElement.createExecutableExtension(PARTICIPANT_ELEMENT_COMPOSEABLE_FACTORY_ADAPTER_CLASS);
        this.modelElementEditorSelectionHandler = (IModelElementEditorSelectionHandler)this.configElement.createExecutableExtension(PARTICIPANT_ELEMENT_EDITOR_SELECTION_HANDLER_CLASS);
        if (this.ID == null || this.participantCompositeAreaFactory == null || this.elementComposeableAdapterFactory == null || this.modelElementEditorSelectionHandler == null || this.targetSearchPageID == null || this.label == null || this.image == null) {
            throw new CoreException((IStatus)new Status(4, this.configElement.getContributor().getName(), 0, String.valueOf(Messages.getString("ParticipantTabDescriptor.invalidExtensionErrorMessage")) + this.ID, null));
        }
    }

    public String getID() {
        return this.ID;
    }

    public IModelSearchAreaFactory getQueryCompositeAreaFactory() {
        return this.participantCompositeAreaFactory;
    }

    public String getLabel() {
        return this.label;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public IModelSearchArea createArea(Composite parent, AbstractModelSearchPage searchPage) {
        this.participantModelSearchArea = this.targetNsURI != null && !"".equals(this.targetNsURI) ? this.participantCompositeAreaFactory.createArea(parent, searchPage, this.targetNsURI) : this.participantCompositeAreaFactory.createArea(parent, searchPage);
        if (this.participantModelSearchArea instanceof AbstractModelSearchCompositeArea) {
            ((AbstractModelSearchCompositeArea)this.participantModelSearchArea).getDataMap().put("SETTINGS_PREFIX", searchPage.getID());
        }
        return this.participantModelSearchArea;
    }

    public IModelSearchArea getParticipantModelSearchArea() {
        return this.participantModelSearchArea;
    }

    public AdapterFactory getElementComposeableAdapterFactory() {
        return this.elementComposeableAdapterFactory;
    }

    public IModelElementEditorSelectionHandler getModelElementEditorSelectionHandler() {
        return this.modelElementEditorSelectionHandler;
    }

    public Image getImage() {
        return this.image;
    }

    public String getTargetSearchPageID() {
        return this.targetSearchPageID;
    }
}

