/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ui.services;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.search.ui.l10n.Messages;
import org.eclipse.emf.search.utils.ModelSearchImagesUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;

public class MenuContributionDescriptor {
    public static final String MENU_CONTRIBUTION_EXT_ID = "id";
    public static final String MENU_ID = "id";
    public static final String MENU_LABEL_ID = "label";
    public static final String MENU_ORDER_ID = "order";
    public static final String MENU_IMAGE_ID = "image";
    public static final String TARGET_META_MODEL_ID = "targetMetaModelID";
    public String ID;
    public String label;
    public String order;
    public ImageDescriptor imageDescriptor;
    public String targetMetaModelID;
    private IConfigurationElement configElement;

    public MenuContributionDescriptor(IConfigurationElement element) throws CoreException {
        this.configElement = element;
        this.load();
    }

    private void load() throws CoreException {
        Bundle bundle = Platform.getBundle((String)this.configElement.getNamespaceIdentifier());
        this.ID = this.configElement.getAttribute("id");
        this.label = this.configElement.getAttribute(MENU_LABEL_ID);
        this.order = this.configElement.getAttribute(MENU_ORDER_ID);
        String imagePath = this.configElement.getAttribute(MENU_IMAGE_ID);
        this.imageDescriptor = ModelSearchImagesUtil.getImageDescriptor((Bundle)bundle, (String)imagePath);
        this.targetMetaModelID = this.configElement.getAttribute(TARGET_META_MODEL_ID);
        if (this.ID == null || this.ID.equals("") || this.label == null || this.label.equals("") || this.order == null || this.order.equals("") || this.imageDescriptor == null || this.targetMetaModelID == null || this.targetMetaModelID.equals("")) {
            throw new CoreException((IStatus)new Status(4, this.configElement.getContributor().getName(), 0, String.valueOf(Messages.getString("MenuContributionDescriptor.invalidExtensionErrorMessage")) + this.ID, null));
        }
    }

    public String getID() {
        return this.ID;
    }

    public String getLabel() {
        return this.label;
    }

    public String getOrder() {
        return this.order;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.imageDescriptor;
    }

    public String getTargetMetaModelID() {
        return this.targetMetaModelID;
    }
}

