/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ecore.evaluators;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.search.core.engine.IModelSearchQuery;
import org.eclipse.emf.search.core.eval.IModelSearchQueryEvaluator;
import org.eclipse.emf.search.ecore.engine.EcoreModelSearchQuery;
import org.eclipse.emf.search.ecore.l10n.Messages;
import org.eclipse.emf.search.ecore.regex.ModelSearchQueryTextualExpressionEnum;
import org.eclipse.emf.search.ecore.regex.ModelSearchQueryTextualExpressionMatchingHelper;
import org.eclipse.emf.search.ecore.utils.TextualFeaturesUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreTextualModelSearchQueryEvaluator<Q extends IModelSearchQuery, T>
implements IModelSearchQueryEvaluator<Q, T> {
    public List<?> eval(Q query, T target, boolean notification) {
        ArrayList<Object> results = new ArrayList<Object>();
        if (query instanceof EcoreModelSearchQuery) {
            ModelSearchQueryTextualExpressionEnum kind = ((EcoreModelSearchQuery)((Object)query)).getKind();
            String text = query.getQueryExpression();
            text = text == "" && kind == ModelSearchQueryTextualExpressionEnum.NORMAL_TEXT ? "*" : text;
            for (Object o : query.getValidParticipantMetaElements()) {
                Resource r;
                if (!(target instanceof Resource) || !(o instanceof EObject) || !((r = ((EObject)o).eResource()) instanceof Resource) || !r.getURI().equals((Object)((Resource)target).getURI())) continue;
                EObject eObj = (EObject)o;
                if (TextualFeaturesUtils.instance().getTextFromEStructuralFeatureIfAny(eObj) == null) continue;
                for (ETypedElement elem : TextualFeaturesUtils.instance().getOwnedETypedElementsFromEObject(eObj)) {
                    String elementName = TextualFeaturesUtils.instance().getTextFromETypedElement(eObj, elem);
                    if (elementName == null || !ModelSearchQueryTextualExpressionMatchingHelper.getInstance().lookAt(elementName, text, kind)) continue;
                    results.add(query.processSearchResultMatching(target, (Object)eObj, notification));
                }
            }
        }
        return results;
    }

    public String getLabel() {
        return Messages.getString("EcoreTextualModelSearchQueryEvaluator.Label");
    }
}

