/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecoretools.internal.Activator;
import org.eclipse.emf.ecoretools.internal.Messages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class NewEcoreProjectWizard
extends Wizard
implements INewWizard {
    private WizardNewProjectCreationPage mainPage;
    private IWorkbench currentWorkbench;
    private IProject newProject;

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.currentWorkbench = workbench;
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new WizardNewProjectCreationPage(Messages.NewEcoreProjectWizard_NewEcoreProject);
        this.mainPage.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.ecoretools", (String)"icons/wizban/newprj_wiz.png"));
        this.mainPage.setTitle(Messages.NewEcoreProjectWizard_EcoreProject_title);
        this.mainPage.setDescription(Messages.NewEcoreProjectWizard_EcoreProject_description);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        this.createNewProject();
        if (this.newProject == null) {
            return false;
        }
        this.selectAndReveal((IResource)this.newProject);
        return true;
    }

    private IProject createNewProject() {
        if (this.newProject != null) {
            return this.newProject;
        }
        final IProject newProjectHandle = this.mainPage.getProjectHandle();
        URI location = null;
        if (!this.mainPage.useDefaults()) {
            location = this.mainPage.getLocationURI();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocationURI(location);
        description.setNatureIds(new String[]{"org.eclipse.emf.ecoretools.ecorenature"});
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                NewEcoreProjectWizard.this.createProject(description, newProjectHandle, monitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof CoreException) {
                if (((CoreException)t).getStatus().getCode() == 275) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewEcoreProjectWizard_CreationProblems, (String)NLS.bind((String)Messages.NewEcoreProjectWizard_CaseSensitive_warning, (Object)newProjectHandle.getName()));
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)Messages.NewEcoreProjectWizard_CreationProblems, null, (IStatus)((CoreException)t).getStatus());
                }
            } else {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecoretools", 0, t.toString(), t));
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewEcoreProjectWizard_CreationProblems, (String)NLS.bind((String)Messages.NewEcoreProjectWizard_InternalError, (Object)t.getMessage()));
            }
            return null;
        }
        this.newProject = newProjectHandle;
        return this.newProject;
    }

    void createProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask("", 2000);
            projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        }
        finally {
            monitor.done();
        }
    }

    protected void selectAndReveal(IResource newResource) {
        NewEcoreProjectWizard.selectAndReveal(newResource, this.currentWorkbench.getActiveWorkbenchWindow());
    }

    public static void selectAndReveal(IResource resource, IWorkbenchWindow window) {
        if (window == null || resource == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        ArrayList<IWorkbenchPart> parts = new ArrayList<IWorkbenchPart>();
        IViewReference[] refs = page.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            IWorkbenchPart part = refs[i].getPart(false);
            if (part != null) {
                parts.add(part);
            }
            ++i;
        }
        refs = page.getEditorReferences();
        i = 0;
        while (i < refs.length) {
            if (refs[i].getPart(false) != null) {
                parts.add(refs[i].getPart(false));
            }
            ++i;
        }
        StructuredSelection selection = new StructuredSelection((Object)resource);
        for (IWorkbenchPart part : parts) {
            ISetSelectionTarget target = null;
            target = part instanceof ISetSelectionTarget ? (ISetSelectionTarget)part : (ISetSelectionTarget)part.getAdapter(ISetSelectionTarget.class);
            if (target == null) continue;
            final ISetSelectionTarget finalTarget = target;
            window.getShell().getDisplay().asyncExec(new Runnable((ISelection)selection){
                private final /* synthetic */ ISelection val$selection;
                {
                    this.val$selection = iSelection;
                }

                public void run() {
                    finalTarget.selectReveal(this.val$selection);
                }
            });
        }
    }
}

