/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.edit.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecoretools.diagram.Messages;
import org.eclipse.emf.ecoretools.diagram.edit.dialogs.ManageDiagramsDialog;
import org.eclipse.emf.ecoretools.diagram.edit.parts.EPackageNameEditPart;
import org.eclipse.emf.ecoretools.diagram.part.EcoreDiagramContentInitializer;
import org.eclipse.emf.ecoretools.diagram.part.EcoreDiagramEditor;
import org.eclipse.emf.ecoretools.diagram.part.EcoreDiagramEditorPlugin;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.OpenEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.LayoutService;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenDiagramEditPolicy
extends OpenEditPolicy {
    protected Command getOpenCommand(Request request) {
        EditPart targetEditPart = this.getTargetEditPart(request);
        if (targetEditPart instanceof EPackageNameEditPart && targetEditPart.getParent() != null) {
            targetEditPart = targetEditPart.getParent();
        }
        if (!(targetEditPart instanceof GraphicalEditPart)) {
            return UnexecutableCommand.INSTANCE;
        }
        return new ICommandProxy((ICommand)new OpenDiagramCommand(((GraphicalEditPart)targetEditPart).resolveSemanticElement(), ((EObject)targetEditPart.getModel()).eResource()));
    }

    public static class OpenDiagramCommand
    extends AbstractTransactionalCommand {
        private List<Diagram> allDiagrams = new ArrayList<Diagram>();
        private EObject domainElement;
        private Resource diagramResource;

        public OpenDiagramCommand(EObject domainElt, Resource diagResource) {
            super(TransactionUtil.getEditingDomain((EObject)domainElt), Messages.OpenDiagramEditPolicy_OpenDiagram, null);
            this.domainElement = domainElt;
            this.diagramResource = diagResource;
            if (this.domainElement instanceof EPackage) {
                for (EObject currentDiag : this.diagramResource.getContents()) {
                    if (!(currentDiag instanceof Diagram) || !this.domainElement.equals(((Diagram)currentDiag).getElement())) continue;
                    this.allDiagrams.add((Diagram)currentDiag);
                }
            }
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getSite().getShell();
            ManageDiagramsDialog manageDiagramsDialog = new ManageDiagramsDialog(shell, this.allDiagrams);
            switch (manageDiagramsDialog.open()) {
                case 1: {
                    break;
                }
                case 0: {
                    this.okPressed(manageDiagramsDialog.getSelectedDiagram());
                    break;
                }
                case 1020: {
                    this.createPressed(manageDiagramsDialog.getInitializeContentButtonState());
                    break;
                }
                case 1010: {
                    this.deletePressed(manageDiagramsDialog.getSelectedDiagram());
                    break;
                }
                default: {
                    return CommandResult.newErrorCommandResult((String)Messages.OpenDiagramEditPolicy_OperationFailed);
                }
            }
            return CommandResult.newOKCommandResult();
        }

        private void okPressed(Diagram diagram) {
            this.openEditor(diagram);
        }

        private IEditorInput getEditorInput(Diagram diagram) {
            URI parentUri = diagram.eResource().getURI();
            URI uri = parentUri.appendFragment(diagram.eResource().getURIFragment((EObject)diagram));
            return new URIEditorInput(uri);
        }

        protected void openEditor(Diagram diagram) {
            if (diagram != null) {
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorPart editorPart = activePage.getActiveEditor();
                try {
                    if (editorPart instanceof EcoreDiagramEditor) {
                        ((EcoreDiagramEditor)editorPart).setDiagram(diagram);
                    } else {
                        activePage.openEditor(this.getEditorInput(diagram), this.getEditorID());
                    }
                }
                catch (PartInitException partInitException) {
                    EcoreDiagramEditorPlugin.getInstance().logError(Messages.OpenDiagramEditPolicy_CanNotOpen);
                }
            }
        }

        protected Diagram createPressed(boolean initializeContent) {
            try {
                Diagram diagram = this.intializeNewDiagram(initializeContent);
                this.openEditor(diagram);
                return diagram;
            }
            catch (ExecutionException executionException) {
                EcoreDiagramEditorPlugin.getInstance().logError(Messages.OpenDiagramEditPolicy_CanNotOpen);
                return null;
            }
        }

        protected void deletePressed(Diagram diagram) {
            if (diagram != null) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorPart editor = page.findEditor(this.getEditorInput(diagram));
                if (editor != null) {
                    page.closeEditor(editor, true);
                }
                assert (this.diagramResource != null);
                this.diagramResource.getContents().remove((Object)diagram);
            }
        }

        protected Diagram intializeNewDiagram(boolean initializeContent) throws ExecutionException {
            Diagram diagram = ViewService.createDiagram((EObject)this.getDiagramDomainElement(), (String)this.getDiagramKind(), (PreferencesHint)this.getPreferencesHint());
            if (diagram == null) {
                throw new ExecutionException(NLS.bind((String)Messages.OpenDiagramEditPolicy_CanNotCreateDiagram, (Object)this.getDiagramKind()));
            }
            this.setDefaultNameForDiagram(diagram);
            assert (this.diagramResource != null);
            this.diagramResource.getContents().add((Object)diagram);
            if (initializeContent) {
                EcoreDiagramContentInitializer initializer = new EcoreDiagramContentInitializer();
                initializer.setInitEPackageContent(false);
                initializer.initDiagramContent(diagram);
                if (!diagram.getChildren().isEmpty()) {
                    ArrayList<Node> nodes = new ArrayList<Node>();
                    for (Object view : diagram.getChildren()) {
                        if (!(view instanceof Node)) continue;
                        nodes.add((Node)view);
                    }
                    LayoutService.getInstance().layoutNodes(nodes, true, "DEFAULT");
                }
            }
            return diagram;
        }

        protected EObject getDiagramDomainElement() {
            return this.domainElement;
        }

        protected PreferencesHint getPreferencesHint() {
            return EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT;
        }

        protected String getDiagramKind() {
            return "EcoreTools";
        }

        protected String getEditorID() {
            return "org.eclipse.emf.ecoretools.diagram.part.EcoreDiagramEditorID";
        }

        private void setDefaultNameForDiagram(Diagram elementToConfigure) {
            EPackage pseudoContainer = (EPackage)elementToConfigure.getElement();
            String baseString = String.valueOf(pseudoContainer.getName()) + "_Diagram";
            int count = 0;
            for (Diagram diagram : this.allDiagrams) {
                if (!diagram.getName().equals(String.valueOf(baseString) + count)) continue;
                ++count;
            }
            elementToConfigure.setName(String.valueOf(baseString) + count);
        }
    }
}

