/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui.editor;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.Splitter;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.ModelInputSnapshot;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.ui.ModelCompareInput;
import org.eclipse.emf.compare.ui.viewer.content.ModelContentMergeViewer;
import org.eclipse.emf.compare.ui.viewer.structure.ModelStructureMergeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ModelCompareEditorInput
extends CompareEditorInput {
    protected ModelContentMergeViewer contentMergeViewer;
    protected ModelStructureMergeViewer structureMergeViewer;
    private final DiffModel diff;
    private final ICompareInputChangeListener inputListener;
    private final ModelInputSnapshot inputSnapshot;
    private final MatchModel match;

    public ModelCompareEditorInput(ModelInputSnapshot snapshot) {
        super(new CompareConfiguration());
        this.diff = snapshot.getDiff();
        this.match = snapshot.getMatch();
        this.inputSnapshot = snapshot;
        this.inputListener = new ICompareInputChangeListener(){

            public void compareInputChanged(ICompareInput source) {
                ModelCompareEditorInput.this.structureMergeViewer.setInput(source);
                ModelCompareEditorInput.this.contentMergeViewer.setInput(source);
            }
        };
    }

    public Control createContents(Composite parent) {
        Splitter fComposite = new Splitter(parent, 512);
        this.createOutlineContents((Composite)fComposite, 256);
        CompareViewerPane pane = new CompareViewerPane((Composite)fComposite, 0);
        this.contentMergeViewer = new ModelContentMergeViewer((Composite)pane, this.getCompareConfiguration());
        pane.setContent(this.contentMergeViewer.getControl());
        this.contentMergeViewer.setInput(this.inputSnapshot);
        fComposite.setWeights(new int[]{30, 70});
        return fComposite;
    }

    public Control createOutlineContents(Composite parent, int direction) {
        Splitter splitter = new Splitter(parent, direction);
        CompareViewerPane pane = new CompareViewerPane((Composite)splitter, 0);
        this.structureMergeViewer = new ModelStructureMergeViewer((Composite)pane, this.getCompareConfiguration());
        pane.setContent((Control)this.structureMergeViewer.getTree());
        this.structureMergeViewer.setInput(this.inputSnapshot);
        return splitter;
    }

    protected Object prepareInput(IProgressMonitor monitor) {
        ModelCompareInput input = new ModelCompareInput(this.match, this.diff);
        input.addCompareInputChangeListener(this.inputListener);
        return input;
    }
}

