/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.utilities.migrator;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.net4j.util.eclipse.ResourcesHelper;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class MigratorUtil {
    private static final String REQUIRE_BUNDLE_HEADER = "Require-Bundle:";
    public static final String CLIENT_PLUGIN_ID = "org.eclipse.emf.cdo.client";
    private static final String CLIENT_PATH = "/org.eclipse.emf.cdo.client";
    private static final String ROOT_MODEL_PATH = "/org.eclipse.emf.cdo.client/model/client.ecore";
    private static final String ROOT_GENMODEL_PATH = "/org.eclipse.emf.cdo.client/model/client.genmodel";
    private static final String TEMPLATES_URI = "platform:/resource/org.eclipse.emf.cdo.client/templates";

    public static boolean updateClasspath(String fullPath) throws IOException, CoreException {
        String newContent;
        IProject project = ResourcesHelper.ROOT.getProject(new Path(fullPath).segment(0));
        IFile file = project.getFile((IPath)new Path("META-INF/MANIFEST.MF"));
        if (file == null || !file.exists()) {
            throw new FileNotFoundException(file.getFullPath() + " not found");
        }
        String oldContent = ResourcesHelper.readFileIntoString((IFile)file);
        if (oldContent.indexOf(REQUIRE_BUNDLE_HEADER) == -1) {
            newContent = String.valueOf(oldContent) + REQUIRE_BUNDLE_HEADER + " " + CLIENT_PLUGIN_ID + "\n";
        } else if (oldContent.indexOf(CLIENT_PLUGIN_ID) == -1) {
            newContent = oldContent.replaceFirst(REQUIRE_BUNDLE_HEADER, "Require-Bundle: org.eclipse.emf.cdo.client,");
        } else {
            return false;
        }
        if (newContent.equals(oldContent)) {
            return false;
        }
        ResourcesHelper.writeFile((IFile)file, (String)newContent, (IProgressMonitor)new NullProgressMonitor());
        return true;
    }

    public static int addMappings(String fullPath) throws IOException, CoreException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = MigratorUtil.loadResource((ResourceSet)resourceSet, fullPath);
        EPackage ePackage = (EPackage)resource.getContents().get(0);
        IProject project = ResourcesHelper.ROOT.getProject(new Path(fullPath).segment(0));
        IFile file = project.getFile("plugin.xml");
        String[] content = new String[]{file != null && file.exists() ? ResourcesHelper.readFileIntoString((IFile)file).trim() : "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?eclipse version=\"3.0\"?>\n<plugin>\n\n</plugin>\n"};
        int additions = MigratorUtil.addPackageMapping(ePackage, content);
        if (additions > 0) {
            ResourcesHelper.writeFile((IFile)file, (String)content[0], (IProgressMonitor)new NullProgressMonitor());
        }
        return additions;
    }

    private static int addPackageMapping(EPackage ePackage, String[] content) {
        int additions = 0;
        String nsURI = ePackage.getNsURI();
        if (nsURI != null && nsURI.length() != 0 && !MigratorUtil.containsMapping(content[0], nsURI)) {
            MigratorUtil.addMapping(content, nsURI, "META-INF/" + ePackage.getName() + ".mapping");
            ++additions;
        }
        EList subpackages = ePackage.getESubpackages();
        for (EPackage subpackage : subpackages) {
            additions += MigratorUtil.addPackageMapping(subpackage, content);
        }
        return additions;
    }

    private static void addMapping(String[] content, String nsURI, String map) {
        content[0] = content[0].replaceFirst("</plugin>", "  <extension point=\"org.eclipse.emf.cdo.client.mappings\">\n    <mapping\n       map=\"" + map + "\"\n" + "       uri=\"" + nsURI + "\"/>\n" + "  </extension>\n" + "\n" + "</plugin>");
    }

    private static boolean containsMapping(String content, String nsURI) {
        String regex = "<extension[\\s]+point[\\s]*=[\\s]*\"org\\.eclipse\\.emf\\.cdo\\.client\\.mappings\">[\\s\\S]*uri[\\s]*=[\\s]*\"" + Pattern.quote(nsURI) + "\"[\\s\\S]*" + "(/>|</mapping>)";
        Pattern pattern = Pattern.compile(regex, 8);
        Matcher matcher = pattern.matcher(content);
        return matcher.find();
    }

    public static boolean migrateGenmodel(String fullPath) throws IOException {
        boolean modified = false;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        GenPackage usedPackage = MigratorUtil.getCDOGenPackage((ResourceSet)resourceSet);
        Resource resource = MigratorUtil.loadResource((ResourceSet)resourceSet, fullPath);
        GenModel genModel = (GenModel)resource.getContents().get(0);
        if (!genModel.getUsedGenPackages().contains((Object)usedPackage)) {
            genModel.getUsedGenPackages().add((Object)usedPackage);
            modified = true;
        }
        if (!genModel.isDynamicTemplates()) {
            genModel.setDynamicTemplates(true);
            modified = true;
        }
        if (!TEMPLATES_URI.equals(genModel.getTemplateDirectory())) {
            genModel.setTemplateDirectory(TEMPLATES_URI);
            modified = true;
        }
        if (modified) {
            resource.save(Collections.EMPTY_MAP);
            return true;
        }
        return false;
    }

    public static int migrateEcore(String fullPath) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        EClass cdoRootClass = MigratorUtil.getCDORootClass((ResourceSet)resourceSet);
        Resource resource = MigratorUtil.loadResource((ResourceSet)resourceSet, fullPath);
        EPackage ePackage = (EPackage)resource.getContents().get(0);
        int modifications = MigratorUtil.migrateEcorePackage(ePackage, cdoRootClass);
        if (modifications > 0) {
            resource.save(Collections.EMPTY_MAP);
        }
        return modifications;
    }

    private static int migrateEcorePackage(EPackage ePackage, EClass cdoRootClass) {
        int modifications = 0;
        EList classifiers = ePackage.getEClassifiers();
        for (EClassifier classifier : classifiers) {
            if (!(classifier instanceof EClass) || !MigratorUtil.migrateEcoreClass((EClass)classifier, cdoRootClass)) continue;
            ++modifications;
        }
        EList subpackages = ePackage.getESubpackages();
        for (EPackage subpackage : subpackages) {
            modifications += MigratorUtil.migrateEcorePackage(subpackage, cdoRootClass);
        }
        return modifications;
    }

    private static boolean migrateEcoreClass(EClass eClass, EClass cdoRootClass) {
        boolean foundAClass = false;
        EList superTypes = eClass.getESuperTypes();
        Iterator it = superTypes.iterator();
        while (it.hasNext()) {
            EClass superType = (EClass)it.next();
            if (superType.isInterface()) continue;
            if (superType.getClassifierID() == 10) {
                it.remove();
                continue;
            }
            if (superType == cdoRootClass) {
                return false;
            }
            foundAClass = true;
        }
        if (!foundAClass) {
            superTypes.add(0, (Object)cdoRootClass);
            return true;
        }
        return false;
    }

    private static Resource loadResource(ResourceSet resourceSet, String uri) throws IOException {
        Resource resource = resourceSet.createResource(URI.createPlatformResourceURI((String)uri));
        resource.load(Collections.EMPTY_MAP);
        return resource;
    }

    private static EClass getCDORootClass(ResourceSet resourceSet) throws IOException {
        Resource cdoResource = MigratorUtil.loadResource(resourceSet, ROOT_MODEL_PATH);
        EPackage cdoPackage = (EPackage)cdoResource.getContents().get(0);
        return (EClass)cdoPackage.getEClassifier("CDOPersistent");
    }

    private static GenPackage getCDOGenPackage(ResourceSet resourceSet) throws IOException {
        Resource usedResource = MigratorUtil.loadResource(resourceSet, ROOT_GENMODEL_PATH);
        GenModel usedModel = (GenModel)usedResource.getContents().get(0);
        return (GenPackage)usedModel.getGenPackages().get(0);
    }

    public static boolean importClientPlugin() throws InvocationTargetException, InterruptedException {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        Shell shell = display.getActiveShell();
        IPluginModelBase model = MigratorUtil.findClientPlugin();
        if (model == null) {
            MessageDialog.openError((Shell)shell, (String)"", (String)"Plugin org.eclipse.emf.cdo.client not found.");
            return false;
        }
        IRunnableWithProgress op = PluginImportWizard.getImportOperation((Shell)shell, (int)3, (IPluginModelBase[])new IPluginModelBase[]{model}, (boolean)false);
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(op);
        return true;
    }

    private static IPluginModelBase findClientPlugin() {
        IPluginModelBase[] models;
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        IPluginModelBase[] iPluginModelBaseArray = models = manager.getExternalModels();
        int n = 0;
        int n2 = iPluginModelBaseArray.length;
        while (n < n2) {
            IPluginModelBase model = iPluginModelBaseArray[n];
            String name = model.getBundleDescription().getName();
            if (CLIENT_PLUGIN_ID.equals(name)) {
                return model;
            }
            ++n;
        }
        return null;
    }
}

