/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.examples.ui.internal;

import org.eclipse.emf.cdo.client.internal.ClientActivator;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.ui.EclipseUIPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.BundleContext;

public final class ExampleUIActivator
extends EMFPlugin {
    public static final ExampleUIActivator INSTANCE = new ExampleUIActivator();
    private static Implementation plugin;

    public ExampleUIActivator() {
        super(new ResourceLocator[]{ClientActivator.INSTANCE});
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static class Implementation
    extends EclipseUIPlugin {
        private RGB invalidationColorSpec;
        private Color invalidationColor;

        public Implementation() {
            plugin = this;
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
        }

        public void stop(BundleContext context) throws Exception {
            if (this.invalidationColor != null) {
                this.invalidationColor.dispose();
                this.invalidationColor = null;
            }
            super.stop(context);
        }

        public boolean isGlobalExtents() {
            IPreferenceStore store = ExampleUIActivator.getPlugin().getPreferenceStore();
            return store.getBoolean("globalExtents");
        }

        public boolean isGlobalXRefs() {
            IPreferenceStore store = ExampleUIActivator.getPlugin().getPreferenceStore();
            return store.getBoolean("globalXRefs");
        }

        public boolean isAutoReload() {
            IPreferenceStore store = ExampleUIActivator.getPlugin().getPreferenceStore();
            return store.getBoolean("autoReload");
        }

        public Color getInvalidationColor() {
            IPreferenceStore store = ExampleUIActivator.getPlugin().getPreferenceStore();
            RGB spec = PreferenceConverter.getColor((IPreferenceStore)store, (String)"invalidationColor");
            if (spec != null && !spec.equals((Object)this.invalidationColorSpec)) {
                if (this.invalidationColor != null) {
                    this.invalidationColor.dispose();
                }
                this.invalidationColor = new Color((Device)Display.getDefault(), spec);
                this.invalidationColorSpec = spec;
            }
            return this.invalidationColor;
        }

        public boolean isShowChanges() {
            IPreferenceStore store = ExampleUIActivator.getPlugin().getPreferenceStore();
            return store.getBoolean("showChanges");
        }

        public boolean isShowConflicts() {
            IPreferenceStore store = ExampleUIActivator.getPlugin().getPreferenceStore();
            return store.getBoolean("showConflicts");
        }
    }
}

