/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.client.protocol;

import java.util.Set;
import org.eclipse.emf.cdo.client.CDOResource;
import org.eclipse.emf.cdo.client.PackageInfo;
import org.eclipse.emf.cdo.client.PackageManager;
import org.eclipse.emf.cdo.client.ResourceManager;
import org.eclipse.emf.cdo.client.protocol.AnnouncePackageRequest;
import org.eclipse.emf.cdo.client.protocol.CommitTransactionRequest;
import org.eclipse.emf.cdo.client.protocol.DescribePackageRequest;
import org.eclipse.emf.cdo.client.protocol.InvalidationNotificationIndication;
import org.eclipse.emf.cdo.client.protocol.LoadObjectRequest;
import org.eclipse.emf.cdo.client.protocol.LoadResourceRequest;
import org.eclipse.emf.cdo.client.protocol.QueryExtentRequest;
import org.eclipse.emf.cdo.client.protocol.QueryXRefsRequest;
import org.eclipse.emf.cdo.client.protocol.RemovalNotificationIndication;
import org.eclipse.emf.cdo.client.protocol.ResourcePathRequest;
import org.eclipse.emf.cdo.client.protocol.ResourceRIDRequest;
import org.eclipse.emf.cdo.core.protocol.AbstractCDOProtocol;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.net4j.core.Channel;
import org.eclipse.net4j.core.Indication;
import org.eclipse.net4j.core.Request;
import org.eclipse.net4j.spring.ValidationException;
import org.eclipse.net4j.util.ImplementationError;

public class ClientCDOProtocolImpl
extends AbstractCDOProtocol {
    protected PackageManager packageManager;

    public int getType() {
        return 2;
    }

    public PackageManager getPackageManager() {
        return this.packageManager;
    }

    public void setPackageManager(PackageManager packageManager) {
        this.doSet("packageManager", packageManager);
    }

    public Indication createIndication(short signalId) {
        switch (signalId) {
            case 11: {
                return new RemovalNotificationIndication();
            }
            case 10: {
                return new InvalidationNotificationIndication();
            }
        }
        throw new ImplementationError("Invalid cdo signalId: " + signalId);
    }

    public static ResourceManager getResourceManager(Channel channel) {
        ClientCDOProtocolImpl.assertValidChannel((Channel)channel);
        ResourceManager channelData = (ResourceManager)channel.getProtocolData();
        if (channelData == null) {
            throw new ImplementationError("ChannelData has not been set");
        }
        return channelData;
    }

    public static void setResourceManager(Channel channel, ResourceManager resourceManager) {
        ClientCDOProtocolImpl.assertValidChannel((Channel)channel);
        if (channel.getProtocolData() != null) {
            throw new ImplementationError("ChannelData has already been set");
        }
        channel.setProtocolData((Object)resourceManager);
    }

    public static boolean requestAnnouncePackage(Channel channel, PackageInfo packageInfo) {
        ClientCDOProtocolImpl.assertValidChannel((Channel)channel);
        AnnouncePackageRequest signal = new AnnouncePackageRequest(packageInfo);
        Object returnValue = channel.transmit((Request)signal);
        return returnValue != null && returnValue instanceof Boolean && (Boolean)returnValue != false;
    }

    public static void requestDescribePackage(Channel channel, PackageInfo packageInfo) {
        ClientCDOProtocolImpl.assertValidChannel((Channel)channel);
        DescribePackageRequest signal = new DescribePackageRequest(packageInfo);
        channel.transmit((Request)signal);
    }

    public static int requestResourcePath(Channel channel, String path) {
        ClientCDOProtocolImpl.assertValidChannel((Channel)channel);
        ResourcePathRequest signal = new ResourcePathRequest(path);
        return (Integer)channel.transmit((Request)signal);
    }

    public static String requestResourceRID(Channel channel, int rid) {
        ClientCDOProtocolImpl.assertValidChannel((Channel)channel);
        ResourceRIDRequest signal = new ResourceRIDRequest(rid);
        return (String)channel.transmit((Request)signal);
    }

    public static Set requestQueryExtent(Channel channel, int cid, boolean exactMatch, int rid) {
        ClientCDOProtocolImpl.assertValidChannel((Channel)channel);
        QueryExtentRequest signal = new QueryExtentRequest(cid, exactMatch, rid);
        return (Set)channel.transmit((Request)signal);
    }

    public static Set requestQueryExtent(Channel channel, int cid, boolean exactMatch) {
        return ClientCDOProtocolImpl.requestQueryExtent(channel, cid, exactMatch, 0);
    }

    public static Set requestQueryExtent(Channel channel, int cid) {
        return ClientCDOProtocolImpl.requestQueryExtent(channel, cid, false);
    }

    public static EList requestQueryXRefs(Channel channel, long oid, int rid) {
        ClientCDOProtocolImpl.assertValidChannel((Channel)channel);
        QueryXRefsRequest signal = new QueryXRefsRequest(oid, rid);
        return (EList)channel.transmit((Request)signal);
    }

    public static void requestLoadResource(Channel channel, int rid, PackageManager packageManager) {
        ClientCDOProtocolImpl.assertValidChannel((Channel)channel);
        packageManager.announceNewPackages(channel);
        LoadResourceRequest signal = new LoadResourceRequest(rid);
        channel.transmit((Request)signal);
        ClientCDOProtocolImpl.postProcessNewResources(channel);
    }

    private static void postProcessNewResources(Channel channel) {
        ResourceManager resourceManager = ClientCDOProtocolImpl.getResourceManager(channel);
        EList resources = resourceManager.getResourceSet().getResources();
        for (Resource resource : resources) {
            CDOResource cdoResource;
            if (!(resource instanceof CDOResource) || (cdoResource = (CDOResource)resource).getPath() != null) continue;
            String path = ClientCDOProtocolImpl.requestResourceRID(channel, cdoResource.getRID());
            if (path == null) {
                throw new ImplementationError("path == null");
            }
            resourceManager.registerResourcePath(cdoResource, path);
            ClientCDOProtocolImpl.requestLoadResource(channel, cdoResource.getRID(), resourceManager.getPackageManager());
        }
    }

    public static void requestLoad(Channel channel, long oid) {
        ClientCDOProtocolImpl.assertValidChannel((Channel)channel);
        LoadObjectRequest signal = new LoadObjectRequest(oid);
        channel.transmit((Request)signal);
        ClientCDOProtocolImpl.postProcessNewResources(channel);
    }

    public static boolean requestCommit(Channel channel, ChangeDescription changeDescription, PackageManager packageManager) {
        ClientCDOProtocolImpl.assertValidChannel((Channel)channel);
        packageManager.announceNewPackages(channel);
        CommitTransactionRequest signal = new CommitTransactionRequest(changeDescription);
        Object result = channel.transmit((Request)signal);
        return (Boolean)result;
    }

    protected void validate() throws ValidationException {
        super.validate();
        this.assertNotNull("packageManager");
    }

    protected void deactivate() throws Exception {
        this.packageManager = null;
        super.deactivate();
    }
}

