/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.client.protocol;

import java.util.Iterator;
import org.eclipse.emf.cdo.client.ClassInfo;
import org.eclipse.emf.cdo.client.PackageManager;
import org.eclipse.emf.cdo.client.protocol.AbstractCDOClientRequest;
import org.eclipse.net4j.util.ImplementationError;

public abstract class AbstractPackageRequest
extends AbstractCDOClientRequest {
    protected void handlePackageResponse(int count) {
        int i = 0;
        while (i < count) {
            int cid = this.receiveInt();
            String className = this.receiveString();
            if (this.isDebugEnabled()) {
                this.debug("Responded class " + className + " = " + cid);
            }
            this.setCIDOnClassInfo(className, cid);
            ++i;
        }
    }

    private void setCIDOnClassInfo(String className, int cid) {
        PackageManager packageManager = this.getPackageManager();
        Iterator<ClassInfo> classInfoIt = packageManager.getClassInfos();
        while (classInfoIt.hasNext()) {
            ClassInfo classInfo = classInfoIt.next();
            if (!classInfo.getFullName().equals(className)) continue;
            classInfo.setCID(cid);
            return;
        }
        throw new ImplementationError("No ClassInfo found for class " + className);
    }
}

