/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.client.impl;

import java.util.ArrayList;
import org.eclipse.emf.cdo.client.AttributeInfo;
import org.eclipse.emf.cdo.client.CDOPackage;
import org.eclipse.emf.cdo.client.ClassInfo;
import org.eclipse.emf.cdo.client.PackageInfo;
import org.eclipse.emf.cdo.client.impl.AttributeInfoImpl;
import org.eclipse.emf.cdo.mapping.AttributeMapping;
import org.eclipse.emf.cdo.mapping.ClassMapping;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;

public class ClassInfoImpl
implements ClassInfo {
    protected int cid;
    protected String fullName;
    protected EClass eClass;
    protected ClassMapping mapping;
    protected PackageInfo packageInfo;
    protected ClassInfo parent;
    protected boolean parentCached;
    protected AttributeInfo[] attributeInfos;
    protected EReference[] allReferences;

    public ClassInfoImpl(EClass eClass, PackageInfo packageInfo, ClassMapping mapping) {
        this.eClass = eClass;
        this.mapping = mapping;
        this.packageInfo = packageInfo;
        this.fullName = String.valueOf(eClass.getEPackage().getName()) + "." + eClass.getName();
        this.initAttributeInfos();
        this.initReferences();
    }

    public String toString() {
        return this.getFullName();
    }

    public String getName() {
        return this.eClass.getName();
    }

    public String getFullName() {
        return this.fullName;
    }

    public EClass getEClass() {
        return this.eClass;
    }

    public ClassMapping getMapping() {
        return this.mapping;
    }

    public ClassInfo getParent() {
        if (!this.parentCached) {
            this.parentCached = true;
            for (EClass candidate : this.eClass.getEAllSuperTypes()) {
                if (!ClassInfoImpl.isValidClass(candidate)) continue;
                this.parent = this.packageInfo.getPackageManager().getClassInfo(candidate);
                if (this.parent != null) break;
            }
        }
        return this.parent;
    }

    public static boolean isValidClass(EClass eClass) {
        return eClass != null && !eClass.isInterface() && !ClassInfoImpl.isRootClass(eClass);
    }

    public static boolean isRootClass(EClass eClass) {
        return eClass == CDOPackage.eINSTANCE.getCDOPersistent();
    }

    public AttributeInfo[] getAttributeInfos() {
        return this.attributeInfos;
    }

    public EReference[] getAllReferences() {
        return this.allReferences;
    }

    protected void initAttributeInfos() {
        ArrayList<AttributeInfoImpl> tmp = new ArrayList<AttributeInfoImpl>();
        for (EAttribute eAttribute : this.eClass.getEAttributes()) {
            AttributeMapping attributeMapping = this.mapping.getAttributeMapping(eAttribute.getName());
            if (attributeMapping == null) continue;
            AttributeInfoImpl attributeInfo = new AttributeInfoImpl(eAttribute, attributeMapping, this);
            tmp.add(attributeInfo);
        }
        this.attributeInfos = tmp.toArray(new AttributeInfo[tmp.size()]);
    }

    protected void initReferences() {
        ArrayList<EReference> tmp = new ArrayList<EReference>();
        for (EReference reference : this.eClass.getEAllReferences()) {
            if (reference.isTransient()) continue;
            tmp.add(reference);
        }
        this.allReferences = tmp.toArray(new EReference[tmp.size()]);
    }

    public int getCID() {
        return this.cid;
    }

    public void setCID(int cid) {
        this.cid = cid;
        this.packageInfo.getPackageManager().initCID(this);
    }

    public AttributeInfo getAttributeInfo(EAttribute eAttribute) {
        int i = 0;
        while (i < this.attributeInfos.length) {
            if (this.attributeInfos[i].getEAttribute() == eAttribute) {
                return this.attributeInfos[i];
            }
            ++i;
        }
        ClassInfo parentInfo = this.getParent();
        if (parentInfo != null) {
            return parentInfo.getAttributeInfo(eAttribute);
        }
        return null;
    }

    public AttributeInfo getAttributeInfo(int feature) {
        int i = 0;
        while (i < this.attributeInfos.length) {
            if (this.attributeInfos[i].getEAttribute().getFeatureID() == feature) {
                return this.attributeInfos[i];
            }
            ++i;
        }
        ClassInfo parentInfo = this.getParent();
        if (parentInfo != null) {
            return parentInfo.getAttributeInfo(feature);
        }
        return null;
    }

    public PackageInfo getPackageInfo() {
        return this.packageInfo;
    }
}

