/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.client.impl;

import org.eclipse.emf.cdo.client.AttributeConverter;
import org.eclipse.emf.cdo.core.impl.AbstractConverter;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.net4j.core.Channel;

public class AttributeConverterImpl
extends AbstractConverter
implements AttributeConverter {
    private static final EcorePackage ECORE = EcorePackage.eINSTANCE;

    public void fromChannel(EObject object, EAttribute attribute, Channel channel) {
        int dataType = this.getCDODataType(attribute.getEAttributeType());
        if (dataType > 0) {
            boolean isNull = channel.receiveBoolean();
            if (isNull) {
                object.eSet((EStructuralFeature)attribute, null);
                return;
            }
            if (dataType < 9) {
                dataType = -dataType;
            } else if (dataType == 11) {
                Object value = this.fromChannelUserDefined(channel, attribute);
                object.eSet((EStructuralFeature)attribute, value);
                return;
            }
        }
        Object value = this.dispatchFromChannel(channel, dataType);
        object.eSet((EStructuralFeature)attribute, value);
    }

    public void toChannel(EObject object, EAttribute attribute, Channel channel) {
        int dataType = this.getCDODataType(attribute.getEAttributeType());
        Object value = object.eGet((EStructuralFeature)attribute);
        if (dataType > 0) {
            boolean isNull = value == null;
            channel.transmitBoolean(isNull);
            if (isNull) {
                return;
            }
            if (dataType < 9) {
                dataType = -dataType;
            } else if (dataType == 11) {
                this.toChannelUserDefined(channel, attribute, value);
                return;
            }
        }
        this.dispatchToChannel(channel, dataType, value);
    }

    protected Object fromChannelUserDefined(Channel channel, EAttribute attribute) {
        EFactory factory = attribute.getEType().getEPackage().getEFactoryInstance();
        EDataType dataType = attribute.getEAttributeType();
        String deserialized = channel.receiveString();
        Object value = dataType.getInstanceClassName().equals("java.lang.String") ? deserialized : factory.createFromString(dataType, deserialized);
        return value;
    }

    protected void toChannelUserDefined(Channel channel, EAttribute attribute, Object value) {
        EFactory factory = attribute.getEType().getEPackage().getEFactoryInstance();
        EDataType dataType = attribute.getEAttributeType();
        Object serialized = value instanceof String ? (String)value : (value == null ? null : factory.convertToString(dataType, value));
        channel.transmitString((String)serialized);
    }

    public int getCDODataType(EDataType eDataType) {
        if (eDataType == ECORE.getEChar()) {
            return -1;
        }
        if (eDataType == ECORE.getECharacterObject()) {
            return 1;
        }
        if (eDataType == ECORE.getEBoolean()) {
            return -2;
        }
        if (eDataType == ECORE.getEBooleanObject()) {
            return 2;
        }
        if (eDataType == ECORE.getEByte()) {
            return -3;
        }
        if (eDataType == ECORE.getEByteObject()) {
            return 3;
        }
        if (eDataType == ECORE.getEShort()) {
            return -4;
        }
        if (eDataType == ECORE.getEShortObject()) {
            return 4;
        }
        if (eDataType == ECORE.getEInt()) {
            return -5;
        }
        if (eDataType == ECORE.getEIntegerObject()) {
            return 5;
        }
        if (eDataType == ECORE.getELong()) {
            return -6;
        }
        if (eDataType == ECORE.getELongObject()) {
            return 6;
        }
        if (eDataType == ECORE.getEFloat()) {
            return -7;
        }
        if (eDataType == ECORE.getEFloatObject()) {
            return 7;
        }
        if (eDataType == ECORE.getEDouble()) {
            return -8;
        }
        if (eDataType == ECORE.getEDoubleObject()) {
            return 8;
        }
        if (eDataType == ECORE.getEString()) {
            return 10;
        }
        return 11;
    }
}

