/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mint.internal.ui.source;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.mint.CodeGenStatus;
import org.eclipse.emf.mint.IMemberAnnotationListener;
import org.eclipse.emf.mint.IMemberAnnotationManager;
import org.eclipse.emf.mint.MemberAnnotationChangedEvent;
import org.eclipse.emf.mint.MintCore;
import org.eclipse.emf.mint.internal.ui.MintUI;
import org.eclipse.emf.mint.internal.ui.source.Messages;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.themes.IThemeManager;

public class GeneratedElementDecorator
implements ILightweightLabelDecorator,
IMemberAnnotationListener,
IPropertyChangeListener {
    private final ListenerList listeners = new ListenerList();
    private IMemberAnnotationManager manager;
    private IThemeManager themeManager;
    private Color generatedColor;
    private Color generatedNotColor;
    private Color generatedNotChildrenColor;
    private ColorJob colorJob;
    private final Object colorLock = new Object();
    private final UpdateJob updateJob = new UpdateJob();

    public GeneratedElementDecorator() {
        this.manager = MintCore.getInstance().getMemberAnnotationManager();
        this.manager.addMemberAnnotationListener((IMemberAnnotationListener)this);
        this.themeManager = MintUI.getDefault().getWorkbench().getThemeManager();
        this.themeManager.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void decorate(Object element, IDecoration decoration) {
        EffectiveCodeGenStatus effectiveStatus;
        if (!(element instanceof IMember)) {
            return;
        }
        IMember member = (IMember)element;
        CodeGenStatus status = this.manager.getCodeGenStatus(member);
        switch (status) {
            case GENERATED: {
                effectiveStatus = EffectiveCodeGenStatus.GENERATED;
                break;
            }
            case GENERATED_NOT: {
                effectiveStatus = EffectiveCodeGenStatus.GENERATED_NOT;
                break;
            }
            default: {
                effectiveStatus = EffectiveCodeGenStatus.NONE;
            }
        }
        if (status != CodeGenStatus.GENERATED_NOT) {
            try {
                IJavaElement[] iJavaElementArray = member.getChildren();
                int n = iJavaElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CodeGenStatus childStatus;
                    IJavaElement child = iJavaElementArray[n2];
                    if (!(child instanceof IInitializer) && (childStatus = this.manager.getCodeGenStatus((IMember)child)) == CodeGenStatus.GENERATED_NOT) {
                        effectiveStatus = EffectiveCodeGenStatus.GENERATED_NOT_CHILDREN;
                        break;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                MintCore.getInstance().logError("Could not get element's children.", (Throwable)e);
            }
        }
        this.decorate(effectiveStatus, decoration);
    }

    private void decorate(EffectiveCodeGenStatus status, IDecoration decoration) {
        Color color = null;
        switch (status) {
            case GENERATED: {
                color = this.getGeneratedColor();
                break;
            }
            case GENERATED_NOT: {
                color = this.getGeneratedNotColor();
                break;
            }
            case GENERATED_NOT_CHILDREN: {
                color = this.getGeneratedNotChildrenColor();
            }
        }
        if (color != null) {
            decoration.setForegroundColor(color);
        }
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.listeners.clear();
        if (!this.updateJob.cancel()) {
            try {
                this.updateJob.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        Object object = this.colorLock;
        synchronized (object) {
            if (this.colorJob != null && !this.colorJob.cancel()) {
                try {
                    this.colorJob.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.themeManager.removePropertyChangeListener((IPropertyChangeListener)this);
        this.themeManager = null;
        this.manager.removeMemberAnnotationListener((IMemberAnnotationListener)this);
        this.manager = null;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove((Object)listener);
    }

    protected void fireLabelProviderChangedEvent(final LabelProviderChangedEvent event) {
        Object[] l = this.listeners.getListeners();
        int i = 0;
        while (i < l.length) {
            final ILabelProviderListener listener = (ILabelProviderListener)l[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    listener.labelProviderChanged(event);
                }
            });
            ++i;
        }
    }

    public void memberAnnotationChanged(MemberAnnotationChangedEvent event) {
        HashSet elements = new HashSet(event.getChanges().keySet());
        for (IMember member : event.getChanges().keySet()) {
            IType parent = member.getDeclaringType();
            if (parent == null) continue;
            elements.add(parent);
        }
        if (Display.getCurrent() == null) {
            this.updateJob.addElements(elements);
        } else {
            this.fireLabelProviderChangedEvent(new LabelProviderChangedEvent((IBaseLabelProvider)this, elements.toArray()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent event) {
        if ("org.eclipse.emf.mint.ui.GENERATED_COLOR".equals(event.getProperty()) || "org.eclipse.emf.mint.ui.GENERATED_NOT_COLOR".equals(event.getProperty()) || "org.eclipse.emf.mint.ui.GENERATED_NOT_CHILDREN_COLOR".equals(event.getProperty())) {
            Object object = this.colorLock;
            synchronized (object) {
                if (this.colorJob == null) {
                    return;
                }
            }
            this.colorJob.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Color getGeneratedColor() {
        Object object = this.colorLock;
        synchronized (object) {
            if (this.generatedColor == null && this.colorJob == null) {
                this.colorJob = new ColorJob();
            }
        }
        try {
            this.colorJob.join();
        }
        catch (InterruptedException interruptedException) {}
        return this.generatedColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Color getGeneratedNotColor() {
        Object object = this.colorLock;
        synchronized (object) {
            if (this.generatedNotColor == null && this.colorJob == null) {
                this.colorJob = new ColorJob();
            }
        }
        try {
            this.colorJob.join();
        }
        catch (InterruptedException interruptedException) {}
        return this.generatedNotColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Color getGeneratedNotChildrenColor() {
        Object object = this.colorLock;
        synchronized (object) {
            if (this.generatedNotChildrenColor == null && this.colorJob == null) {
                this.colorJob = new ColorJob();
            }
        }
        try {
            this.colorJob.join();
        }
        catch (InterruptedException interruptedException) {}
        return this.generatedNotChildrenColor;
    }

    private class ColorJob
    extends WorkbenchJob {
        private boolean refresh;

        public ColorJob() {
            super(Messages.GeneratedElementDecorator_ThemeJob);
            this.setSystem(true);
            this.schedule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (GeneratedElementDecorator.this.themeManager == null) {
                return Status.CANCEL_STATUS;
            }
            ColorRegistry registry = GeneratedElementDecorator.this.themeManager.getCurrentTheme().getColorRegistry();
            Object object = GeneratedElementDecorator.this.colorLock;
            synchronized (object) {
                GeneratedElementDecorator.this.generatedColor = registry.get("org.eclipse.emf.mint.ui.GENERATED_COLOR");
                GeneratedElementDecorator.this.generatedNotColor = registry.get("org.eclipse.emf.mint.ui.GENERATED_NOT_COLOR");
                GeneratedElementDecorator.this.generatedNotChildrenColor = registry.get("org.eclipse.emf.mint.ui.GENERATED_NOT_CHILDREN_COLOR");
            }
            if (this.refresh) {
                GeneratedElementDecorator.this.fireLabelProviderChangedEvent(new LabelProviderChangedEvent((IBaseLabelProvider)GeneratedElementDecorator.this));
            }
            this.refresh = true;
            return Status.OK_STATUS;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EffectiveCodeGenStatus {
        NONE,
        GENERATED,
        GENERATED_NOT,
        GENERATED_NOT_CHILDREN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UpdateJob
    extends WorkbenchJob {
        private final Object elementsLock;
        private HashSet<Object> elements;

        public UpdateJob() {
            super("update");
            this.elementsLock = new Object();
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addElements(Collection<?> elements) {
            Object object = this.elementsLock;
            synchronized (object) {
                if (this.elements == null) {
                    this.elements = new HashSet(elements);
                    this.schedule();
                } else if (this.elements.addAll(elements)) {
                    this.schedule();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            LinkedList<Object> elements;
            HashSet<Object> hashSet = this.elements;
            synchronized (hashSet) {
                elements = new LinkedList<Object>(this.elements);
                this.elements = null;
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (!elements.isEmpty()) {
                GeneratedElementDecorator.this.fireLabelProviderChangedEvent(new LabelProviderChangedEvent((IBaseLabelProvider)GeneratedElementDecorator.this, elements.toArray()));
            }
            return Status.OK_STATUS;
        }
    }
}

