/*******************************************************************************
 * Copyright (c) 2005 - 2006 Joel Cheuoua & others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Joel Cheuoua - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.codegen.jet.editor.preferences;

import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditorPreferenceConstants;
import org.eclipse.ui.texteditor.AbstractTextEditor;

/**
 * Preference Constants used for the IRL Editor
 * @author lmirguet
 * @version $Revision: 1.2 $
 */
public class JETTemplateEditorPreferenceConstants {

  public static final String JET_EXPRESSION_BACKGROUND_COLOR = "jet_expression_background";
  public static final String JET_DIRECTIVE_BACKGROUND_COLOR = "jet_directive_background";
  public static final String JET_SCRIPTLET_BACKGROUND_COLOR = "jet_scriptlet_background";
  public static final String JET_STRING_OR_COMMENT_BACKGROUND_COLOR = "string_or_comment_background";

  public static final String JAVA_KEYWORD_BOLD = "java_keyword_bold";
  public static final String JET_STRING_BOLD = "jet_string_bold";
  public static final String JET_BRACKET_BOLD = "jet_bracket_bold";
  public static final String DEFAULT_FG_BOLD = "AbstractTextEditor.Color.Foreground_bold";

  public static final String JAVA_KEYWORD_COLOR = "java_keyword";
  public static final String JET_STRING_COLOR = "jet_string";
  public static final String JET_BRACKET_COLOR = "jet_bracket";
  public static final String DEFAULT_FG_COLOR = "AbstractTextEditor.Color.Foreground";

  public static final String LINE_NUMBER = "line_number";
  public static final String AUTO_COMPLETE_ENABLED = "autoCompleteEnable";
  public static final String AUTO_COMPLETE_DELAY = "autoCompleteDelay";
  
  /**
   * Should not be instanciated.
   *
   */
  private JETTemplateEditorPreferenceConstants() {
  }

  /**
   * Initialize with the default values.
   * @param store IPreferenceStore
   */
  public static void initializeDefaultValues(IPreferenceStore store) {

    PreferenceConstants.initializeDefaultValues(store);
    AbstractDecoratedTextEditorPreferenceConstants.initializeDefaultValues(store);
    
    PreferenceConverter.setDefault(store, JET_EXPRESSION_BACKGROUND_COLOR, new RGB(225, 240, 240));
    PreferenceConverter.setDefault(store, JET_DIRECTIVE_BACKGROUND_COLOR, new RGB(230, 230, 230));
    PreferenceConverter.setDefault(store, JET_SCRIPTLET_BACKGROUND_COLOR, new RGB(230, 230, 230));
    PreferenceConverter.setDefault(store, JET_STRING_OR_COMMENT_BACKGROUND_COLOR, PreferenceConverter.getDefaultColor(
        store, AbstractTextEditor.PREFERENCE_COLOR_BACKGROUND));

    PreferenceConverter.setDefault(store, JAVA_KEYWORD_COLOR, PreferenceConverter.getDefaultColor(store,
        PreferenceConstants.EDITOR_JAVA_KEYWORD_COLOR));
    PreferenceConverter.setDefault(store, JET_STRING_COLOR, PreferenceConverter.getDefaultColor(store,
        PreferenceConstants.EDITOR_STRING_COLOR));
    PreferenceConverter.setDefault(store, JET_BRACKET_COLOR, PreferenceConverter.getDefaultColor(store,
        PreferenceConstants.EDITOR_JAVA_KEYWORD_COLOR));
    PreferenceConverter.setDefault(store, DEFAULT_FG_COLOR, PreferenceConverter.getDefaultColor(store,
        AbstractTextEditor.PREFERENCE_COLOR_FOREGROUND));

    
    store.setDefault(JAVA_KEYWORD_BOLD, store.getDefaultBoolean(PreferenceConstants.EDITOR_JAVA_KEYWORD_BOLD));
    store.setDefault(JET_STRING_BOLD, store.getDefaultBoolean(PreferenceConstants.EDITOR_STRING_BOLD));
    store.setDefault(JET_BRACKET_BOLD, store.getDefaultBoolean(PreferenceConstants.EDITOR_JAVA_KEYWORD_BOLD));
    store.setDefault(DEFAULT_FG_BOLD, store.getDefaultBoolean(PreferenceConstants.EDITOR_JAVA_DEFAULT_BOLD));

    store.setDefault(AUTO_COMPLETE_ENABLED, store.getDefaultBoolean(PreferenceConstants.CODEASSIST_AUTOACTIVATION));
    store.setDefault(AUTO_COMPLETE_DELAY, store.getDefaultInt(PreferenceConstants.CODEASSIST_AUTOACTIVATION_DELAY));
    
    
  }

}
