/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.configuration.ui.helpers;

import aima.core.logic.propositional.parsing.ast.Sentence;
import configuration.Configuration;
import configuration.Feature;
import configuration.FeatureBinding;
import java.util.ArrayList;
import org.eclipse.emf.henshin.diagram.edit.parts.RuleEditPart;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.variability.matcher.FeatureExpression;
import org.eclipse.emf.henshin.variability.wrapper.TransactionalVariabilityFactory;
import org.eclipse.emf.henshin.variability.wrapper.VariabilityNode;
import org.eclipse.gmf.runtime.notation.impl.ShapeImpl;

public class VariabilityModelHelper {
    public static Rule getRuleForEditPart(RuleEditPart ruleEditPart) {
        Rule result = null;
        if (ruleEditPart != null) {
            result = (Rule)((ShapeImpl)ruleEditPart.getModel()).getElement();
        }
        return result;
    }

    public static Sentence getFeatureExpression(Configuration configuration) {
        Sentence expr = FeatureExpression.getExpr((String)TransactionalVariabilityFactory.INSTANCE.createVariabilityRule((Rule)configuration.getRule()).getFeatureConstraint());
        for (Feature vp : configuration.getFeatures()) {
            if (vp.getBinding() == FeatureBinding.TRUE) {
                expr = FeatureExpression.and((Sentence)expr, (Sentence)FeatureExpression.getExpr((String)vp.getName()));
                continue;
            }
            if (vp.getBinding() != FeatureBinding.FALSE) continue;
            expr = FeatureExpression.andNot((Sentence)expr, (Sentence)FeatureExpression.getExpr((String)vp.getName()));
        }
        return expr;
    }

    public static String getPresenceCondition(Configuration configuration) {
        StringBuilder result = new StringBuilder();
        String delimiter = "";
        for (Feature vp : configuration.getFeatures()) {
            if (vp.getBinding() == FeatureBinding.UNBOUND) continue;
            result.append(delimiter);
            if (vp.getBinding() == FeatureBinding.FALSE) {
                result.append("!");
            }
            result.append(vp.getName());
            delimiter = " & ";
        }
        return result.toString();
    }

    private static Sentence getFeatureExpression(Configuration configuration, Feature feature) {
        Sentence expr = FeatureExpression.getExpr((String)TransactionalVariabilityFactory.INSTANCE.createVariabilityRule((Rule)configuration.getRule()).getFeatureConstraint());
        if (expr == null) {
            expr = FeatureExpression.getExpr((String)"true");
        }
        for (Feature vp : configuration.getFeatures()) {
            if (vp.getName() != feature.getName() && vp.getBinding() == FeatureBinding.TRUE) {
                expr = FeatureExpression.and((Sentence)expr, (Sentence)FeatureExpression.getExpr((String)vp.getName()));
                continue;
            }
            if (vp.getName() == feature.getName() || vp.getBinding() != FeatureBinding.FALSE) continue;
            expr = FeatureExpression.andNot((Sentence)expr, (Sentence)FeatureExpression.getExpr((String)vp.getName()));
        }
        return expr;
    }

    public static String[] getNonContradictingBindingOptions(Configuration configuration, Feature vp) {
        ArrayList<String> options = new ArrayList<String>();
        Sentence configurationExpr = VariabilityModelHelper.getFeatureExpression(configuration, vp);
        options.add(FeatureBinding.UNBOUND.getName());
        if (!FeatureExpression.contradicts((Sentence)configurationExpr, (Sentence)FeatureExpression.getExpr((String)vp.getName()))) {
            options.add(FeatureBinding.TRUE.getName());
        }
        if (!FeatureExpression.contradicts((Sentence)configurationExpr, (Sentence)FeatureExpression.getExpr((String)("!" + vp.getName())))) {
            options.add(FeatureBinding.FALSE.getName());
        }
        String[] result = new String[options.size()];
        int i = result.length - 1;
        while (i >= 0) {
            result[i] = (String)options.get(i);
            --i;
        }
        return result;
    }

    public static String getPresenceConditionForNewEdge(Edge edge, Configuration configuration) {
        String configPC = VariabilityModelHelper.getPresenceCondition(configuration);
        VariabilityNode varSource = TransactionalVariabilityFactory.INSTANCE.createVariabilityNode(edge.getSource());
        VariabilityNode varTarget = TransactionalVariabilityFactory.INSTANCE.createVariabilityNode(edge.getTarget());
        Sentence config = FeatureExpression.getExpr((String)configPC);
        Sentence source = FeatureExpression.getExpr((String)varSource.getPresenceCondition());
        Sentence target = FeatureExpression.getExpr((String)varTarget.getPresenceCondition());
        if (FeatureExpression.implies((Sentence)source, (Sentence)config)) {
            if (FeatureExpression.implies((Sentence)source, (Sentence)target)) {
                return varSource.getPresenceCondition();
            }
            return String.valueOf(varSource.getPresenceCondition()) + " & " + varTarget.getPresenceCondition();
        }
        if (FeatureExpression.implies((Sentence)target, (Sentence)config)) {
            if (FeatureExpression.implies((Sentence)target, (Sentence)config)) {
                return varTarget.getPresenceCondition();
            }
            return String.valueOf(varSource.getPresenceCondition()) + " & " + varTarget.getPresenceCondition();
        }
        if (FeatureExpression.implies((Sentence)config, (Sentence)source)) {
            if (FeatureExpression.implies((Sentence)config, (Sentence)target)) {
                return configPC;
            }
            return config + " & " + varTarget.getPresenceCondition();
        }
        if (FeatureExpression.implies((Sentence)config, (Sentence)target)) {
            return String.valueOf(varSource.getPresenceCondition()) + " & " + configPC;
        }
        return String.valueOf(varSource.getPresenceCondition()) + " & " + varTarget.getPresenceCondition() + " & " + configPC;
    }
}

