/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.multicda.cda.framework;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.multicda.cda.Pair;
import org.eclipse.emf.henshin.multicda.cda.framework.CdaWorker;
import org.eclipse.emf.henshin.multicda.cda.framework.RuleConfigurator;
import org.eclipse.emf.henshin.multicda.cda.units.Span;

public abstract class ResultCreator {
    private static Set<? extends Span> spans = new HashSet<Span>();
    private static String title = "";
    private static String path = "";
    private static Set<Rule> first;
    private static Set<Rule> second;
    private static Table table;
    private static String begin;
    private static String beginFirst;
    private static String end;
    private static String comma;
    public static boolean withBorder;

    static {
        begin = "<th>";
        beginFirst = "<th style='background:lightgrey'>";
        end = "</th>";
        comma = ", ";
        withBorder = true;
    }

    public static void create(Set<? extends Span> spans, Set<Rule> first, Set<Rule> second) {
        if (!spans.isEmpty()) {
            ResultCreator.spans = spans;
            ResultCreator.first = first;
            ResultCreator.second = second;
            ResultCreator.recreateTable();
        }
    }

    public static void create(Set<? extends Span> spans, Set<Rule> first, Set<Rule> second, String ... titlePath) {
        if (titlePath.length >= 1) {
            title = titlePath[0];
        }
        if (titlePath.length >= 2) {
            path = String.valueOf(titlePath[1]) + "/";
        }
        ResultCreator.create(spans, first, second);
    }

    public static void create(Set<? extends Span> spans, Set<Rule> first, Set<Rule> second, boolean norm, boolean abs, String ... titlePath) {
        if (!spans.isEmpty()) {
            ResultCreator.first = first;
            ResultCreator.second = second;
            ResultCreator.spans = spans;
            if (titlePath.length >= 1) {
                title = titlePath[0];
            }
            if (titlePath.length >= 2) {
                path = String.valueOf(titlePath[1]) + "/";
            }
            table = new Table();
            if (norm) {
                ResultCreator.exportResultTable(table);
            }
            if (abs) {
                ResultCreator.exportAbstractTable(table);
            }
        }
    }

    public static void create(CdaWorker cda, String ... titlePath) {
        if (titlePath.length >= 1) {
            title = titlePath[0];
        }
        if (titlePath.length >= 2) {
            path = String.valueOf(titlePath[1]) + "/";
        }
        ResultCreator.create(cda.getResult(), cda.first, cda.second);
    }

    public static void recreateTable() {
        table = new Table();
        ResultCreator.exportResultTable(table);
        ResultCreator.exportAbstractTable(table);
    }

    private static void exportResultTable(Table table) {
        String result = String.valueOf(withBorder ? "<style>th{border: 1px solid black;padding:7px;}</style>" : "") + "<div style=\"position: relative; left: 50%; right: 50%;\">" + title + "</div><table style=\"border-collapse: collapse;\" align=\"center\">\n<tr style='background:lightgrey'></th><th>";
        for (Rule r2 : second) {
            if (r2 == null) continue;
            result = String.valueOf(result) + begin + r2.getName() + end;
        }
        result = String.valueOf(result) + "</tr>\n";
        HashMap<String, String> reasonKinds = new HashMap<String, String>();
        for (Rule r1 : first) {
            if (r1 == null) continue;
            result = String.valueOf(result) + "<tr>" + beginFirst + r1.getName() + end;
            String row = "";
            for (Rule r2 : second) {
                Set<Span> reasons = table.getSpans(r1, r2);
                if (reasons == null) {
                    row = String.valueOf(row) + begin + end;
                    continue;
                }
                String entry = "";
                HashMap<String, Pair<String, Integer>> kinds = new HashMap<String, Pair<String, Integer>>();
                for (Span reason : reasons) {
                    Pair<String, Integer> id = (Pair<String, Integer>)kinds.get(reason.getFullID());
                    if (id == null) {
                        id = new Pair<String, Integer>(reason.getFullName(), 0);
                    }
                    id.second = (Integer)id.second + 1;
                    kinds.put(reason.getFullID(), id);
                }
                for (String id : kinds.keySet()) {
                    reasonKinds.put(id, (String)((Pair)kinds.get((Object)id)).first);
                    if (entry.contains(id)) continue;
                    entry = String.valueOf(entry) + comma + id + ((Integer)((Pair)kinds.get((Object)id)).second > 1 ? "(" + ((Pair)kinds.get((Object)id)).second + ")" : "");
                }
                row = String.valueOf(row) + begin + entry.substring(1) + end;
            }
            result = String.valueOf(result) + row + "</tr>\n";
        }
        result = String.valueOf(result) + "</table>";
        String legende = "<div style=\"position: relative; left: 50%; right: 50%;\">";
        for (String tag : reasonKinds.keySet()) {
            legende = String.valueOf(legende) + tag + " = " + (String)reasonKinds.get(tag) + "\n<br>";
        }
        result = String.valueOf(result) + "\n<br>" + legende + "</div>";
        ResultCreator.saveTXT(result, new char[0]);
    }

    private static void exportAbstractTable(Table table) {
        String result = "";
        String firstline = String.valueOf(withBorder ? "<style>th{border: 1px solid black;padding:7px;}</style>" : "") + "<div style=\"\r\n" + "position: relative;\r\n" + "left: 50%;\r\n" + "right: 50%;\r\n" + "\">" + title + "</div>" + "<table style=\"border-collapse: collapse;\" align=\"center\">\n<tr style='background:lightgrey'><th></th>";
        LinkedHashMap data = new LinkedHashMap();
        HashSet<RuleConfigurator.RuleType> ruleConfigurations = new HashSet<RuleConfigurator.RuleType>();
        HashMap<String, String> reasonKinds = new HashMap<String, String>();
        ArrayList<RuleConfigurator> firstIn = new ArrayList<RuleConfigurator>();
        ArrayList<RuleConfigurator> secondIn = new ArrayList<RuleConfigurator>();
        for (Rule r1 : first) {
            if (r1 == null) continue;
            RuleConfigurator rc1 = new RuleConfigurator(r1);
            for (Rule r2 : second) {
                HashMap<String, Integer> tags;
                Set<Span> reasons;
                if (r2 == null || (reasons = table.getSpans(r1, r2)) == null) continue;
                RuleConfigurator rc2 = new RuleConfigurator(r2);
                ruleConfigurations.addAll(rc1.getTypes());
                ruleConfigurations.addAll(rc2.getTypes());
                LinkedHashMap map = (LinkedHashMap)data.get(rc1);
                if (map == null) {
                    map = new LinkedHashMap();
                    data.put(rc1, map);
                }
                if (!firstIn.contains(rc1)) {
                    firstIn.add(rc1);
                }
                if (!secondIn.contains(rc2)) {
                    secondIn.add(rc2);
                }
                if ((tags = (HashMap<String, Integer>)map.get(rc2)) == null) {
                    tags = new HashMap<String, Integer>();
                    map.put(rc2, tags);
                }
                for (Span reason : reasons) {
                    Integer size = (Integer)tags.get(reason.getFullID());
                    if (size == null) {
                        size = 0;
                    }
                    size = size + 1;
                    reasonKinds.put(reason.getFullID(), reason.getFullName());
                    tags.put(reason.getFullID(), size);
                }
            }
        }
        for (RuleConfigurator r : secondIn) {
            firstline = String.valueOf(firstline) + begin + r.getTAG() + end;
        }
        for (RuleConfigurator rc1 : firstIn) {
            String row = "";
            Map rc1Data = (Map)data.get(rc1);
            if (rc1Data == null) continue;
            for (RuleConfigurator rc2 : secondIn) {
                Map rc2Data = (Map)rc1Data.get(rc2);
                String reasons = "";
                if (rc2Data == null) {
                    reasons = comma;
                } else {
                    for (String tag : rc2Data.keySet()) {
                        reasons = String.valueOf(reasons) + comma + tag + ((Integer)rc2Data.get(tag) > 1 ? "(" + rc2Data.get(tag) + ")" : "");
                    }
                }
                row = String.valueOf(row) + begin + reasons.substring(comma.length()) + end;
            }
            result = String.valueOf(result) + "<tr>" + beginFirst + rc1.getTAG() + end + row + "</tr>\n";
        }
        result = String.valueOf(firstline) + "\n" + result;
        result = String.valueOf(result) + "</table>";
        String legende = "<div style=\"position: relative; left: 50%; right: 50%;\">";
        for (RuleConfigurator.RuleType rc : ruleConfigurations) {
            legende = String.valueOf(legende) + rc.TAG + " = " + rc.description + "\n<br>";
        }
        legende = String.valueOf(legende) + "\n<br>";
        for (String tag : reasonKinds.keySet()) {
            legende = String.valueOf(legende) + tag + " = " + (String)reasonKinds.get(tag) + "\n<br>";
        }
        result = String.valueOf(result) + "\n<br>" + legende + "</div>";
        ResultCreator.saveTXT(result, 'a');
    }

    private static void saveTXT(String data, char ... sufix) {
        try {
            String name = title.replaceAll("\\ ", "_");
            char[] cArray = sufix;
            int n = sufix.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                name = String.valueOf(name) + "_" + c;
                ++n2;
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(String.valueOf(path) + name + ".html"));
            writer.write(data);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class Table {
        private Map<String, Map<String, Set<Span>>> content = new HashMap<String, Map<String, Set<Span>>>();

        public Table() {
            for (Span span : spans) {
                Set<Span> secondR;
                Map<String, Set<Span>> firstR = this.content.get(span.getRule1().getName());
                if (firstR == null) {
                    firstR = new HashMap<String, Set<Span>>();
                    this.content.put(span.getRule1().getName(), firstR);
                }
                if ((secondR = firstR.get(span.getRule2().getName())) == null) {
                    secondR = new HashSet<Span>();
                    firstR.put(span.getRule2().getName(), secondR);
                }
                secondR.add(span);
            }
        }

        public Set<Span> getSpans(Rule r1, Rule r2) {
            Map<String, Set<Span>> result = this.content.get(r1.getName());
            if (result == null) {
                return null;
            }
            return result.get(r2.getName());
        }
    }
}

