/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.multicda.cda;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.multicda.cda.ConflictAnalysis;
import org.eclipse.emf.henshin.multicda.cda.MultiGranularAnalysis;
import org.eclipse.emf.henshin.multicda.cda.ReasonFactory;
import org.eclipse.emf.henshin.multicda.cda.Utils;
import org.eclipse.emf.henshin.multicda.cda.units.Atom;
import org.eclipse.emf.henshin.multicda.cda.units.Reason;

public class DependencyAnalysis
implements MultiGranularAnalysis {
    private Rule rule1INV;
    private ConflictAnalysis ca;
    private Set<Atom.DependencyAtom> atoms = new HashSet<Atom.DependencyAtom>();
    private Set<Reason> mdrs = new HashSet<Reason>();
    private Set<Reason> drs = new HashSet<Reason>();

    public DependencyAnalysis(Rule rule1, Rule rule2) {
        this.rule1INV = Utils.invertRule(rule1);
        this.ca = new ConflictAnalysis(this.rule1INV, rule2);
    }

    public Set<Atom.DependencyAtom> computeAtoms() {
        return this.computeDependencyAtoms();
    }

    @Override
    public Atom.DependencyAtom computeResultsBinary() {
        Atom.ConflictAtom conflictAtom = this.ca.computeResultsBinary();
        if (conflictAtom != null) {
            return ReasonFactory.eINSTANCE.createDependencyAtom(conflictAtom);
        }
        return null;
    }

    public Set<Reason> computeResultsCoarse() {
        if (this.mdrs.isEmpty()) {
            for (Reason reason : this.ca.computeResultsCoarse()) {
                Reason r = ReasonFactory.eINSTANCE.createMinimalDependencyReason(reason);
                if (r == null) continue;
                this.mdrs.add(r);
            }
        }
        return this.mdrs;
    }

    public Set<Reason> computeResultsFine() {
        if (this.drs.isEmpty()) {
            for (Reason reason : this.ca.computeResultsFine()) {
                Reason r = ReasonFactory.eINSTANCE.createDependencyReason(reason);
                if (r == null) continue;
                this.drs.add(r);
            }
        }
        return this.drs;
    }

    private Set<Atom.DependencyAtom> computeDependencyAtoms() {
        if (this.atoms.isEmpty()) {
            for (Atom.ConflictAtom atom : this.ca.computeAtoms()) {
                this.atoms.add(ReasonFactory.eINSTANCE.createDependencyAtom(atom));
            }
        }
        return this.atoms;
    }
}

