/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.actions;

import java.util.List;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.MappingList;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.actions.ActionElementFinder;
import org.eclipse.emf.henshin.model.actions.GenericActionHelper;
import org.eclipse.emf.henshin.model.actions.MapEditor;
import org.eclipse.emf.henshin.model.actions.NodeMapEditor;

public class NodeActionHelper
extends GenericActionHelper<Node, Rule> {
    public static final NodeActionHelper INSTANCE = new NodeActionHelper();

    @Override
    public List<Node> getActionElements(Rule rule, Action action) {
        List candidates = ActionElementFinder.getRuleElementCandidates(rule, action, HenshinPackage.eINSTANCE.getGraph_Nodes());
        return this.filterElementsByAction(candidates, action);
    }

    @Override
    protected MapEditor<Node> getMapEditor(Graph target) {
        return new NodeMapEditor(target);
    }

    @Override
    protected MapEditor<Node> getMapEditor(Graph source, Graph target, MappingList mappings) {
        return new NodeMapEditor(source, target, mappings);
    }

    public Node getActionNode(Node node) {
        return ActionElementFinder.getActionElement(node, INSTANCE);
    }

    public Node getLhsNode(Node node) {
        Graph lhs = node.getGraph().getRule().getLhs();
        if (node.getGraph() == lhs) {
            return node;
        }
        Node opposite = this.getActionNode(node);
        if (opposite.getGraph() == lhs) {
            return opposite;
        }
        return null;
    }

    @Override
    protected NestedCondition getOrCreateAC(Action action, Rule rule) {
        NestedCondition nestedCond = super.getOrCreateAC(action, rule);
        MapEditor<Node> editor = this.getMapEditor(rule.getLhs(), nestedCond.getConclusion(), nestedCond.getMappings());
        for (Node node : rule.getLhs().getNodes()) {
            editor.copy(node);
        }
        return nestedCond;
    }
}

