/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.matching.conditions;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.henshin.interpreter.ApplicationMonitor;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.matching.conditions.IFormula;
import org.eclipse.emf.henshin.interpreter.matching.constraints.DomainSlot;
import org.eclipse.emf.henshin.interpreter.matching.constraints.Variable;
import org.eclipse.emf.henshin.interpreter.monitoring.PerformanceMonitor;
import org.eclipse.emf.henshin.interpreter.monitoring.VariableCheck;

public class ApplicationCondition
implements IFormula {
    public final EGraph graph;
    public final Map<Variable, DomainSlot> domainMap;
    public IFormula formula;
    public List<Variable> variables;
    private PerformanceMonitor monitor = null;

    public ApplicationCondition(EGraph graph, Map<Variable, DomainSlot> domainMap, ApplicationMonitor monitor) {
        this.domainMap = domainMap;
        this.graph = graph;
        if (monitor instanceof PerformanceMonitor) {
            this.monitor = (PerformanceMonitor)((Object)monitor);
        }
    }

    public boolean findGraph() {
        for (Variable var : this.variables) {
            if (!var.typeConstraint.instantiationPossible(this.domainMap.get(var), this.graph)) {
                return false;
            }
            if (this.monitor == null) continue;
            this.monitor.addVariableInfoRecord(var.variableId, var.name, var.typeConstraint.type.getName(), this.variables.indexOf(var), this.graph.getDomainSize(var.typeConstraint.type, var.typeConstraint.strictTyping));
        }
        return this.findMatch(0);
    }

    protected boolean findMatch(int index) {
        if (index == this.variables.size()) {
            for (Variable variable : this.variables) {
                DomainSlot slot;
                if (!variable.requiresFinalCheck || (slot = this.domainMap.get(variable)).recheck(variable, this.domainMap)) continue;
                return false;
            }
            return this.formula.eval();
        }
        Variable variable = this.variables.get(index);
        DomainSlot slot = this.domainMap.get(variable);
        VariableCheck varCheckRecord = null;
        if (this.monitor != null) {
            varCheckRecord = new VariableCheck(variable.variableId, true);
            slot.setVarCheckRecord(varCheckRecord);
        }
        boolean valid = false;
        while (!valid) {
            valid = slot.instantiate(variable, this.domainMap, this.graph);
            if (valid) {
                if (this.monitor != null) {
                    this.monitor.addVariableCheckRecord(varCheckRecord);
                }
                valid = this.findMatch(index + 1);
                if (this.monitor != null) {
                    varCheckRecord = new VariableCheck(variable.variableId, false);
                    slot.setVarCheckRecord(varCheckRecord);
                    if (!valid) {
                        this.monitor.addBacktrackRecord(variable.variableId);
                    }
                }
            }
            if (valid) continue;
            slot.unlock(variable);
            if (slot.instantiationPossible()) continue;
            slot.clear(variable);
            if (this.monitor != null) {
                this.monitor.addVariableCheckRecord(varCheckRecord);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean eval() {
        boolean result = this.findGraph();
        for (Variable var : this.variables) {
            this.domainMap.get(var).reset(var);
        }
        return result;
    }
}

