/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.name;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.name.Named;
import com.google.inject.name.NamedImpl;
import com.google.inject.spi.SourceProvider;
import com.google.inject.spi.SourceProviders;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Names {
    private Names() {
    }

    public static Named named(String name) {
        return new NamedImpl(name);
    }

    public static void bindProperties(final Binder binder, final Map<String, String> properties) {
        SourceProviders.withDefault(new SimpleSourceProvider(SourceProviders.defaultSource()), new Runnable(){

            public void run() {
                for (Map.Entry entry : properties.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    binder.bind(Key.get(String.class, (Annotation)new NamedImpl(key))).toInstance(value);
                }
            }
        });
    }

    public static void bindProperties(final Binder binder, final Properties properties) {
        SourceProviders.withDefault(new SimpleSourceProvider(SourceProviders.defaultSource()), new Runnable(){

            public void run() {
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    binder.bind(Key.get(String.class, (Annotation)new NamedImpl(key))).toInstance(value);
                }
            }
        });
    }

    static {
        SourceProviders.skip(Names.class);
    }

    static class SimpleSourceProvider
    implements SourceProvider {
        final Object source;

        SimpleSourceProvider(Object source) {
            this.source = source;
        }

        public Object source() {
            return this.source;
        }
    }
}

