/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.impl.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.eef.runtime.EEFRuntimePlugin;
import org.eclipse.emf.eef.runtime.api.adapters.SemanticAdapter;
import org.eclipse.emf.eef.runtime.context.PropertiesEditingContext;
import org.eclipse.emf.eef.runtime.context.impl.DomainPropertiesEditionContext;
import org.eclipse.emf.eef.runtime.ui.widgets.eobjflatcombo.EObjectFlatComboSettings;
import org.eclipse.emf.eef.runtime.ui.widgets.referencestable.ReferencesTableSettings;
import org.eclipse.emf.eef.runtime.ui.widgets.settings.EEFEditorSettings;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EEFUtils {
    public static final String JDT_CORE_SYMBOLIC_NAME = "org.eclipse.jdt.core";

    public static Object choiceOfValues(EObject eObject, EStructuralFeature feature) {
        return EEFUtils.choiceOfValues(EEFRuntimePlugin.getDefault().getAdapterFactory(), eObject, feature);
    }

    public static Object choiceOfValues(AdapterFactory adapterFactory, EObject eObject, EStructuralFeature feature) {
        IItemPropertyDescriptor propertyDescriptor;
        Object choiceOfValues = null;
        IItemPropertySource ps = (IItemPropertySource)adapterFactory.adapt((Notifier)eObject, IItemPropertySource.class);
        if (ps != null && (propertyDescriptor = ps.getPropertyDescriptor((Object)eObject, (Object)feature)) != null) {
            choiceOfValues = propertyDescriptor.getChoiceOfValues((Object)eObject);
        }
        if (choiceOfValues == null && eObject.eResource() != null && eObject.eResource().getResourceSet() != null) {
            choiceOfValues = eObject.eResource().getResourceSet();
        }
        if (choiceOfValues == null) {
            choiceOfValues = "";
        } else if (choiceOfValues instanceof List) {
            List list = (List)choiceOfValues;
            int i = 0;
            while (i < list.size()) {
                Object next = list.get(i);
                if (next == null) {
                    list.set(i, "");
                }
                ++i;
            }
        }
        return choiceOfValues;
    }

    public static String getLabel(AdapterFactory adapterFactory, EObject eObject) {
        IItemLabelProvider labelProvider = (IItemLabelProvider)adapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class);
        if (labelProvider != null) {
            return labelProvider.getText((Object)eObject);
        }
        return null;
    }

    public static List<EClass> allTypeFor(EReference eReference, EditingDomain editingDomain) {
        Collection list = editingDomain.getNewChildDescriptors((Object)EEFUtils.searchInstanceOf(editingDomain.getResourceSet(), eReference.getEContainingClass()), null);
        ArrayList<EClass> instanciableTypesInHierarchy = new ArrayList<EClass>();
        for (Object object : list) {
            if (!(object instanceof CommandParameter) || !(((CommandParameter)object).getFeature() instanceof EReference) || !((CommandParameter)object).getFeature().equals(eReference)) continue;
            instanciableTypesInHierarchy.add(((CommandParameter)object).getEValue().eClass());
        }
        return instanciableTypesInHierarchy;
    }

    public static EObject searchInstanceOf(ResourceSet allResources, EClass eClass) {
        for (Resource resource : allResources.getResources()) {
            TreeIterator iterator = resource.getAllContents();
            while (iterator.hasNext()) {
                Object objectTemp = iterator.next();
                if (!(objectTemp instanceof EObject) || !eClass.isInstance(objectTemp)) continue;
                return (EObject)objectTemp;
            }
        }
        return null;
    }

    public static List<EClass> instanciableTypesInHierarchy(EClassifier eClassifier, ResourceSet resourceSet) {
        ArrayList<EClass> result = new ArrayList<EClass>();
        if (eClassifier instanceof EClass) {
            EClass eClass = (EClass)eClassifier;
            if (!eClass.isAbstract()) {
                result.add(eClass);
            }
            result.addAll(EEFUtils.instanciableSubTypes(eClass, resourceSet));
        }
        return result;
    }

    private static List<EClass> instanciableSubTypes(EClass eClass, ResourceSet resourceSet) {
        ArrayList<EClass> result = new ArrayList<EClass>();
        for (EPackage ePackage : EEFUtils.allPackages(eClass, resourceSet)) {
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                EClass eClass2;
                if (!(eClassifier instanceof EClass) || (eClass2 = (EClass)eClassifier).equals(eClass) || !eClass.isSuperTypeOf(eClass2) || eClass2.isAbstract() || eClass2.isInterface()) continue;
                result.add(eClass2);
            }
        }
        return result;
    }

    private static List<EPackage> allPackages(EClass eClass, ResourceSet resourceSet) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        if (eClass.eResource() != null) {
            EcoreUtil.resolveAll((EObject)eClass);
            EList resourcesToProcess = null;
            if (eClass.eResource().getResourceSet() != null) {
                resourcesToProcess = eClass.eResource().getResourceSet().getResources();
            } else {
                resourcesToProcess = new ArrayList();
                resourcesToProcess.add(eClass.eResource());
            }
            for (Resource resource : resourcesToProcess) {
                result.addAll(EEFUtils.allPackageOfResource(resource));
            }
        } else {
            EPackage rootPackage = eClass.getEPackage();
            while (rootPackage.getESuperPackage() != null) {
                rootPackage = rootPackage.getESuperPackage();
            }
            result.addAll(EEFUtils.allSubPackages(rootPackage));
        }
        if (resourceSet != null) {
            for (EPackage ePackage : EEFUtils.getAllEPackagesFromResourceSet(resourceSet)) {
                if (result.contains(ePackage)) continue;
                result.add(ePackage);
            }
        }
        return result;
    }

    private static List<EPackage> getAllEPackagesFromResourceSet(ResourceSet resourceSet_p) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        for (Resource resource : resourceSet_p.getResources()) {
            for (EPackage pkg : EEFUtils.allPackageOfResource(resource)) {
                EPackage staticPackage = EEFUtils.getStaticPackage(pkg);
                if (staticPackage == null) continue;
                result.add(staticPackage);
            }
        }
        return result;
    }

    private static EPackage getStaticPackage(EPackage ePackage_p) {
        Object staticPackage = EPackage.Registry.INSTANCE.get((Object)ePackage_p.getNsURI());
        if (staticPackage != null) {
            if (staticPackage instanceof EPackage) {
                return (EPackage)staticPackage;
            }
            if (staticPackage instanceof EPackage.Descriptor) {
                return ((EPackage.Descriptor)staticPackage).getEPackage();
            }
        }
        return null;
    }

    private static List<EPackage> allSubPackages(EPackage ePackage) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        for (EPackage subPackage : ePackage.getESubpackages()) {
            result.addAll(EEFUtils.allSubPackages(subPackage));
        }
        return result;
    }

    private static List<EPackage> allPackageOfResource(Resource resource) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        TreeIterator iterator = resource.getAllContents();
        while (iterator.hasNext()) {
            EObject type = (EObject)iterator.next();
            if (!(type instanceof EPackage)) continue;
            result.add((EPackage)type);
        }
        return result;
    }

    public static List<Object> asList(TreeIterator<Object> iter) {
        ArrayList<Object> result = new ArrayList<Object>();
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        return result;
    }

    public static List<EObject> asEObjectList(TreeIterator<EObject> iter) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        while (iter.hasNext()) {
            result.add((EObject)iter.next());
        }
        return result;
    }

    public static boolean isBundleLoaded(String name) {
        Bundle bundle = Platform.getBundle((String)name);
        return bundle != null && bundle.getState() == 32;
    }

    public static boolean containsInstanceOfEClass(EObject element, EClass eClassToCheck) {
        if (EEFUtils.isInstanceOfEClass(element, eClassToCheck)) {
            return true;
        }
        for (EObject container : element.eContents()) {
            if (!EEFUtils.containsInstanceOfEClass(container, eClassToCheck)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInstanceOfEClass(EObject element, EClass eClassToCheck) {
        EClass eClass = element.eClass();
        if (eClass.equals(eClassToCheck)) {
            return true;
        }
        for (EClass eSuperClass : eClass.getEAllSuperTypes()) {
            if (!eSuperClass.equals(eClassToCheck)) continue;
            return true;
        }
        return false;
    }

    public static void putToReference(EEFEditorSettings settings, EObject eObject) {
        if (settings instanceof ReferencesTableSettings) {
            ((ReferencesTableSettings)settings).addToReference(eObject);
        } else if (settings instanceof EObjectFlatComboSettings) {
            ((EObjectFlatComboSettings)settings).setToReference(eObject);
        }
    }

    public static EditingDomain getEditingDomain(PropertiesEditingContext editingContext) {
        if (editingContext instanceof DomainPropertiesEditionContext) {
            return ((DomainPropertiesEditionContext)editingContext).getEditingDomain();
        }
        if (editingContext.getParentContext() != null) {
            return EEFUtils.getEditingDomain(editingContext.getParentContext());
        }
        return null;
    }

    public static EObject resolveSemanticObject(Object object) {
        Object getAdapter;
        IAdaptable adaptable = null;
        if (object instanceof IAdaptable && (getAdapter = (adaptable = (IAdaptable)object).getAdapter(SemanticAdapter.class)) != null) {
            return ((SemanticAdapter)getAdapter).getEObject();
        }
        Object loadAdapter = Platform.getAdapterManager().loadAdapter(object, SemanticAdapter.class.getName());
        if (loadAdapter != null) {
            return ((SemanticAdapter)loadAdapter).getEObject();
        }
        if (object instanceof EObject) {
            return (EObject)object;
        }
        if (adaptable != null && adaptable.getAdapter(EObject.class) != null) {
            return (EObject)adaptable.getAdapter(EObject.class);
        }
        return null;
    }
}

