/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.spi.net4j;

import java.text.MessageFormat;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.ILocationAware;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.channel.ChannelException;
import org.eclipse.net4j.connector.ConnectorException;
import org.eclipse.net4j.connector.ConnectorState;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.connector.IConnectorStateEvent;
import org.eclipse.net4j.protocol.IProtocol;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.security.INegotiationContext;
import org.eclipse.net4j.util.security.INegotiator;
import org.eclipse.net4j.util.security.NegotiationException;
import org.eclipse.spi.net4j.ChannelMultiplexer;
import org.eclipse.spi.net4j.InternalChannel;
import org.eclipse.spi.net4j.InternalConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Connector
extends ChannelMultiplexer
implements InternalConnector {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_CONNECTOR, Connector.class);
    private String userID;
    private transient ConnectorState connectorState = ConnectorState.DISCONNECTED;
    @ReflectUtil.ExcludeFromDump
    private transient CountDownLatch finishedConnecting;
    @ReflectUtil.ExcludeFromDump
    private transient CountDownLatch finishedNegotiating;
    @ReflectUtil.ExcludeFromDump
    private transient INegotiationContext negotiationContext;
    @ReflectUtil.ExcludeFromDump
    private transient NegotiationException negotiationException;

    public INegotiator getNegotiator() {
        return this.getConfig().getNegotiator();
    }

    public void setNegotiator(INegotiator negotiator) {
        this.getConfig().setNegotiator(negotiator);
    }

    public INegotiationContext getNegotiationContext() {
        return this.negotiationContext;
    }

    @Override
    public boolean isClient() {
        return this.getLocation() == ILocationAware.Location.CLIENT;
    }

    @Override
    public boolean isServer() {
        return this.getLocation() == ILocationAware.Location.SERVER;
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String userID) {
        this.checkState(this.getState() != ConnectorState.CONNECTED, "Connector is already connected");
        if (TRACER.isEnabled()) {
            TRACER.format("Setting userID {0} for {1}", new Object[]{userID, this});
        }
        this.userID = userID;
    }

    @Override
    public ConnectorState getState() {
        return this.connectorState;
    }

    public void setState(ConnectorState newState) throws ConnectorException {
        ConnectorState oldState = this.getState();
        if (newState != oldState) {
            if (TRACER.isEnabled()) {
                TRACER.format("Setting state {0} (was {1}) for {2}", new Object[]{newState, oldState.toString().toLowerCase(), this});
            }
            this.connectorState = newState;
            switch (newState) {
                case DISCONNECTED: {
                    if (this.finishedConnecting != null) {
                        this.finishedConnecting.countDown();
                        this.finishedConnecting = null;
                    }
                    if (this.finishedNegotiating == null) break;
                    this.finishedNegotiating.countDown();
                    this.finishedNegotiating = null;
                    break;
                }
                case CONNECTING: {
                    this.finishedConnecting = new CountDownLatch(1);
                    this.finishedNegotiating = new CountDownLatch(1);
                    break;
                }
                case NEGOTIATING: {
                    this.finishedConnecting.countDown();
                    this.negotiationContext = this.createNegotiationContext();
                    this.getNegotiator().negotiate(this.negotiationContext);
                    break;
                }
                case CONNECTED: {
                    this.negotiationContext = null;
                    this.deferredActivate(true);
                    this.finishedConnecting.countDown();
                    this.finishedNegotiating.countDown();
                }
            }
            this.fireEvent(new ConnectorStateEvent((INotifier)this, oldState, newState));
        }
    }

    public boolean isDisconnected() {
        return this.connectorState == ConnectorState.DISCONNECTED;
    }

    public boolean isConnecting() {
        return this.connectorState == ConnectorState.CONNECTING;
    }

    public boolean isNegotiating() {
        return this.connectorState == ConnectorState.NEGOTIATING;
    }

    @Override
    public boolean isConnected() {
        if (this.negotiationException != null) {
            throw new ConnectorException("Connector negotiation failed", (Throwable)this.negotiationException);
        }
        return this.connectorState == ConnectorState.CONNECTED;
    }

    @Override
    public void connectAsync() throws ConnectorException {
        try {
            this.activate();
        }
        catch (ConnectorException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean waitForConnection(long timeout) throws ConnectorException {
        boolean withTimeout = timeout != -1L;
        try {
            long t;
            if (TRACER.isEnabled()) {
                TRACER.trace("Waiting for connection...");
            }
            do {
                t = 100L;
                if (!withTimeout) continue;
                t = Math.min(100L, timeout);
                timeout -= 100L;
            } while (t > 0L && this.finishedNegotiating != null && !this.finishedNegotiating.await(t, TimeUnit.MILLISECONDS));
            return this.isConnected();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    @Override
    public boolean connect(long timeout) throws ConnectorException {
        this.connectAsync();
        return this.waitForConnection(timeout);
    }

    @Override
    public boolean connect() throws ConnectorException {
        return this.connect(-1L);
    }

    public void close() {
        LifecycleUtil.deactivate((Object)this, (OMLogger.Level)OMLogger.Level.DEBUG);
    }

    public boolean isClosed() {
        return !this.isActive();
    }

    @Override
    public short getBufferCapacity() {
        return this.getConfig().getBufferProvider().getBufferCapacity();
    }

    @Override
    public IBuffer provideBuffer() {
        return this.getConfig().getBufferProvider().provideBuffer();
    }

    @Override
    public void retainBuffer(IBuffer buffer) {
        this.getConfig().getBufferProvider().retainBuffer(buffer);
    }

    protected void leaveConnecting() {
        if (this.getNegotiator() == null) {
            this.setState(ConnectorState.CONNECTED);
        } else {
            this.setState(ConnectorState.NEGOTIATING);
        }
    }

    @Override
    protected abstract INegotiationContext createNegotiationContext();

    protected NegotiationException getNegotiationException() {
        return this.negotiationException;
    }

    protected void setNegotiationException(NegotiationException negotiationException) {
        this.negotiationException = negotiationException;
    }

    @Override
    protected void initChannel(InternalChannel channel, IProtocol<?> protocol) {
        super.initChannel(channel, protocol);
        channel.setUserID(this.getUserID());
    }

    @Override
    protected void deregisterChannelFromPeer(InternalChannel channel) throws ChannelException {
    }

    @Override
    public ILocationAware.Location getLocation() {
        return null;
    }

    @Override
    public String getURL() {
        return null;
    }

    protected boolean isDeferredActivation() {
        return true;
    }

    @Override
    protected void doBeforeOpenChannel(IProtocol<?> protocol) {
        super.doBeforeOpenChannel(protocol);
        this.waitForConnection(this.getOpenChannelTimeout());
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.getConfig().getBufferProvider(), "getConfig().getBufferProvider()");
        if (this.userID != null && this.getConfig().getNegotiator() == null) {
            throw new IllegalStateException("A user ID on this connector requires a negotiator");
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.setState(ConnectorState.CONNECTING);
    }

    @Override
    protected void doDeactivate() throws Exception {
        this.setState(ConnectorState.DISCONNECTED);
        super.doDeactivate();
    }

    private static class ConnectorStateEvent
    extends Event
    implements IConnectorStateEvent {
        private static final long serialVersionUID = 1L;
        private ConnectorState oldState;
        private ConnectorState newState;

        public ConnectorStateEvent(INotifier notifier, ConnectorState oldState, ConnectorState newState) {
            super(notifier);
            this.oldState = oldState;
            this.newState = newState;
        }

        public IConnector getConnector() {
            return (IConnector)this.getSource();
        }

        public ConnectorState getOldState() {
            return this.oldState;
        }

        public ConnectorState getNewState() {
            return this.newState;
        }

        public String toString() {
            return MessageFormat.format("ConnectorStateEvent[source={0}, oldState={1}, newState={2}]", new Object[]{this.getSource(), this.getOldState(), this.getNewState()});
        }
    }
}

