/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.om.monitor;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.om.monitor.MonitorCanceledException;
import org.eclipse.net4j.util.om.monitor.NestedMonitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public abstract class AbstractMonitor
implements OMMonitor {
    private static final long NOT_BEGUN = -1L;
    private double totalWork = -1.0;
    private double work;

    public boolean hasBegun() throws MonitorCanceledException {
        this.checkCanceled();
        return this.totalWork != -1.0;
    }

    public OMMonitor begin(double totalWork) throws MonitorCanceledException {
        this.checkCanceled();
        this.totalWork = totalWork;
        return this;
    }

    public OMMonitor begin() throws MonitorCanceledException {
        return this.begin(1.0);
    }

    public void worked(double work) throws MonitorCanceledException {
        this.checkBegun();
        this.work += work;
    }

    public void worked() throws MonitorCanceledException {
        this.worked(1.0);
    }

    public OMMonitor fork(double work) {
        this.checkBegun();
        return this.createNestedMonitor(work);
    }

    public OMMonitor fork() {
        return this.fork(1.0);
    }

    public OMMonitor.Async forkAsync(double work) {
        this.checkBegun();
        AsyncTimerTask asyncTimerTask = this.createAsyncTimerTask(work);
        long period = this.getAsyncSchedulePeriod();
        this.getTimer().scheduleAtFixedRate((TimerTask)asyncTimerTask, period, period);
        return asyncTimerTask;
    }

    public OMMonitor.Async forkAsync() {
        return this.forkAsync(1.0);
    }

    public void done() {
        double rest;
        if (!this.isCanceled() && (rest = this.totalWork - this.work) > 0.0) {
            this.worked(rest);
        }
    }

    public double getTotalWork() {
        return this.totalWork;
    }

    public double getWork() {
        return this.work;
    }

    public double getWorkPercent() {
        return Math.min(this.work * 100.0 / this.totalWork, 100.0);
    }

    protected OMMonitor createNestedMonitor(double work) {
        return new NestedMonitor(this, work);
    }

    protected AsyncTimerTask createAsyncTimerTask(double work) {
        return new AsyncTimerTask(this, work, 1000.0);
    }

    protected abstract long getAsyncSchedulePeriod();

    protected abstract Timer getTimer();

    private void checkBegun() throws MonitorCanceledException {
        if (!this.hasBegun()) {
            throw new IllegalStateException("begin() has not been called");
        }
    }

    public static class AsyncTimerTask
    extends TimerTask
    implements OMMonitor.Async {
        private OMMonitor monitor;
        private boolean canceled;

        public AsyncTimerTask(AbstractMonitor parent, double parentWork, double timeFactor) {
            this.monitor = parent.fork(parentWork);
            this.monitor.begin();
        }

        public void run() {
            if (!this.canceled) {
                double work = 1.0 - this.monitor.getWork();
                this.monitor.worked(work / 10.0);
            }
        }

        public void stop() {
            try {
                this.monitor.done();
                this.cancel();
            }
            catch (Exception ex) {
                OM.LOG.error(ex);
            }
        }

        public boolean cancel() {
            this.canceled = true;
            return super.cancel();
        }
    }
}

