/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.buddies.internal.common.protocol;

import org.eclipse.net4j.buddies.common.ICollaboration;
import org.eclipse.net4j.buddies.common.ICollaborationProvider;
import org.eclipse.net4j.buddies.common.IMessage;
import org.eclipse.net4j.buddies.internal.common.protocol.ProtocolUtil;
import org.eclipse.net4j.buddies.spi.common.Facility;
import org.eclipse.net4j.signal.Indication;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageIndication
extends Indication {
    private ICollaborationProvider collaborationProvider;

    public MessageIndication(SignalProtocol<?> protocol, ICollaborationProvider collaborationProvider) {
        super(protocol, (short)13);
        this.collaborationProvider = collaborationProvider;
    }

    protected void indicating(ExtendedDataInputStream in) throws Exception {
        String facilityType;
        long collaborationID = in.readLong();
        Facility facility = this.getFacility(collaborationID, facilityType = in.readString());
        if (facility != null) {
            IMessage message = ProtocolUtil.readMessage(in, facility.getClass().getClassLoader());
            facility.handleMessage(message);
        }
    }

    private Facility getFacility(long collaborationID, String facilityType) {
        ICollaboration collaboration = this.collaborationProvider.getCollaboration(collaborationID);
        if (collaboration == null) {
            return null;
        }
        return (Facility)collaboration.getFacility(facilityType);
    }
}

