/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.internal.cdo.net4j.protocol.CDOClientRequest;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceIDRequest
extends CDOClientRequest<CDOID> {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, ResourceIDRequest.class);
    private int viewID;
    private String path;

    public ResourceIDRequest(CDOClientProtocol protocol, int viewID, String path) {
        super(protocol, (short)5);
        this.viewID = viewID;
        this.path = path;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing viewID: {0}", new Object[]{this.viewID});
        }
        out.writeInt(this.viewID);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing path: {0}", new Object[]{this.path});
        }
        out.writeString(this.path);
    }

    @Override
    protected CDOID confirming(CDODataInput in) throws IOException {
        CDOID id = in.readCDOID();
        if (TRACER.isEnabled()) {
            TRACER.format("Read ID: {0}", new Object[]{id});
        }
        return id;
    }
}

