/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.net4j.protocol;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.transaction.CDOTimeStampContext;
import org.eclipse.emf.internal.cdo.net4j.protocol.AbstractSyncRevisionsRequest;
import org.eclipse.emf.internal.cdo.net4j.protocol.CDOClientProtocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncRevisionsRequest
extends AbstractSyncRevisionsRequest {
    public SyncRevisionsRequest(CDOClientProtocol protocol, Map<CDOID, CDOIDAndVersion> idAndVersions, int referenceChunk) {
        this(protocol, 20, idAndVersions, referenceChunk);
    }

    public SyncRevisionsRequest(CDOClientProtocol protocol, short signalID, Map<CDOID, CDOIDAndVersion> idAndVersions, int referenceChunk) {
        super(protocol, signalID, idAndVersions, referenceChunk);
    }

    @Override
    protected Collection<CDOTimeStampContext> confirming(CDODataInput in) throws IOException {
        Object contexts = super.confirming(in);
        List<CDOPackageUnit> emptyNewPackageUnits = Collections.emptyList();
        Iterator iterator = contexts.iterator();
        while (iterator.hasNext()) {
            CDOTimeStampContext timestampContext = (CDOTimeStampContext)iterator.next();
            this.getSession().handleSyncResponse(timestampContext.getTimeStamp(), emptyNewPackageUnits, timestampContext.getDirtyObjects(), timestampContext.getDetachedObjects());
        }
        return contexts;
    }
}

