/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server;

import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public final class StoreThreadLocal {
    private static final ThreadLocal<ISession> SESSION = new InheritableThreadLocal<ISession>();
    private static final ThreadLocal<IStoreAccessor> ACCESSOR = new InheritableThreadLocal<IStoreAccessor>();
    private static final ThreadLocal<IStoreAccessor.CommitContext> COMMIT_CONTEXT = new InheritableThreadLocal<IStoreAccessor.CommitContext>();

    private StoreThreadLocal() {
    }

    public static void setSession(ISession session) {
        SESSION.set(session);
        ACCESSOR.set(null);
    }

    public static ISession getSession() {
        ISession session = SESSION.get();
        if (session == null) {
            throw new IllegalStateException("session == null");
        }
        return session;
    }

    public static void setAccessor(IStoreAccessor accessor) {
        SESSION.set(accessor == null ? null : accessor.getSession());
        ACCESSOR.set(accessor);
    }

    public static IStoreAccessor getAccessor() {
        IStoreAccessor accessor = ACCESSOR.get();
        if (accessor == null) {
            ISession session = StoreThreadLocal.getSession();
            IStore store = session.getSessionManager().getRepository().getStore();
            accessor = store.getReader(session);
            ACCESSOR.set(accessor);
        }
        return accessor;
    }

    public static void setCommitContext(IStoreAccessor.CommitContext commitContext) {
        COMMIT_CONTEXT.set(commitContext);
    }

    public static IStoreAccessor.CommitContext getCommitContext() {
        return COMMIT_CONTEXT.get();
    }

    public static void release() {
        IStoreAccessor accessor = ACCESSOR.get();
        if (accessor != null) {
            if (LifecycleUtil.isActive((Object)accessor)) {
                accessor.release();
            }
            ACCESSOR.set(null);
        }
        SESSION.set(null);
        COMMIT_CONTEXT.set(null);
    }
}

