/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate.tuplizer;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.server.hibernate.id.CDOIDHibernate;
import org.eclipse.emf.cdo.server.hibernate.internal.id.CDOIDHibernateFactoryImpl;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateUtil;
import org.eclipse.net4j.util.WrappedException;
import org.hibernate.Hibernate;
import org.hibernate.usertype.UserType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOIDUserType
implements UserType {
    private static final int[] SQL_TYPES = new int[]{12, 12, 12};
    private final HashMap<String, Constructor<?>> constructors = new HashMap();

    public int[] sqlTypes() {
        return SQL_TYPES;
    }

    public Class<?> returnedClass() {
        return CDOID.class;
    }

    public boolean isMutable() {
        return false;
    }

    public Object deepCopy(Object value) {
        return value;
    }

    public boolean equals(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        return x.equals(y);
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws SQLException {
        String entityName = (String)Hibernate.STRING.nullSafeGet(rs, names[0]);
        if (rs.wasNull()) {
            return null;
        }
        String idStr = (String)Hibernate.STRING.nullSafeGet(rs, names[1]);
        if (rs.wasNull()) {
            return null;
        }
        String idClassName = (String)Hibernate.STRING.nullSafeGet(rs, names[2]);
        if (rs.wasNull()) {
            return null;
        }
        Serializable id = this.getId(idStr, idClassName);
        return CDOIDHibernateFactoryImpl.getInstance().createCDOID(id, entityName);
    }

    public void nullSafeSet(PreparedStatement statement, Object value, int index) throws SQLException {
        if (value == null || value instanceof CDOID && ((CDOID)value).isNull()) {
            statement.setNull(index, 12);
            statement.setNull(index + 1, 12);
            statement.setNull(index + 2, 12);
        } else if (value instanceof CDOIDTemp) {
            CDORevision cdoRevision = HibernateUtil.getInstance().getCDORevisionNullable((CDOID)value);
            if (cdoRevision != null) {
                value = cdoRevision.getID();
            }
            if (value instanceof CDOIDTemp) {
                statement.setNull(index, 12);
                statement.setNull(index + 1, 12);
                statement.setNull(index + 2, 12);
            } else {
                CDOIDHibernate cdoID = (CDOIDHibernate)value;
                statement.setString(index, cdoID.getEntityName());
                statement.setString(index + 1, cdoID.getId().toString());
                statement.setString(index + 2, cdoID.getId().getClass().getName());
            }
        } else {
            CDOIDHibernate cdoID = value instanceof CDORevision ? (CDOIDHibernate)((CDORevision)value).getID() : (CDOIDHibernate)value;
            statement.setString(index, cdoID.getEntityName());
            statement.setString(index + 1, cdoID.getId().toString());
            statement.setString(index + 2, cdoID.getId().getClass().getName());
        }
    }

    public Serializable disassemble(Object value) {
        return (Serializable)value;
    }

    public Object assemble(Serializable cachedValue, Object owner) {
        return cachedValue;
    }

    public Object replace(Object original, Object target, Object owner) {
        return original;
    }

    public int hashCode(Object x) {
        return x.hashCode();
    }

    private Serializable getId(String idStr, String idType) {
        try {
            Constructor<?> constructor = this.constructors.get(idType);
            if (constructor == null) {
                Class<?> idClass = this.getClass().getClassLoader().loadClass(idType);
                constructor = idClass.getConstructor(String.class);
                this.constructors.put(idType, constructor);
            }
            return (Serializable)constructor.newInstance(idStr);
        }
        catch (Exception e) {
            throw WrappedException.wrap((Exception)e);
        }
    }
}

